/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.annotations;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.teneo.annotations.mapper.EDataTypeAnnotator;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEDataType;
import org.eclipse.emf.teneo.hibernate.hbannotation.HbannotationFactory;
import org.eclipse.emf.teneo.hibernate.hbannotation.Parameter;
import org.eclipse.emf.teneo.hibernate.hbannotation.TypeDef;
import org.eclipse.emf.teneo.hibernate.hbmodel.HbAnnotatedEDataType;
import org.eclipse.emf.teneo.util.EcoreDataTypes;

public class HbEDataTypeAnnotator
extends EDataTypeAnnotator {
    protected static final Log log = LogFactory.getLog(HbEDataTypeAnnotator.class);

    public void annotate(PAnnotatedEDataType ped) {
        HbAnnotatedEDataType hed = (HbAnnotatedEDataType)ped;
        if (hed.getHbTypeDef() != null) {
            return;
        }
        String typeClass = this.getCustomDataType(ped.getModelEDataType());
        if (typeClass == null) {
            log.debug((Object)("Not creating typedef for edatatype: " + ped.getModelEDataType().getName() + " because it is natively handled by hibernate"));
            return;
        }
        log.debug((Object)("Creating default typedef for edatatype " + hed.getModelEDataType().getName()));
        TypeDef typeDef = HbannotationFactory.eINSTANCE.createTypeDef();
        typeDef.setName(String.valueOf(hed.getModelEDataType().getEPackage().getName()) + "." + ped.getModelEDataType().getName());
        typeDef.setTypeClass(this.getDefaultUserType());
        Parameter paramPackage = HbannotationFactory.eINSTANCE.createParameter();
        paramPackage.setName("epackage");
        paramPackage.setValue(hed.getModelEDataType().getEPackage().getNsURI());
        typeDef.getParameters().add((Object)paramPackage);
        Parameter edParam = HbannotationFactory.eINSTANCE.createParameter();
        edParam.setName("edatatype");
        edParam.setValue(hed.getModelEDataType().getName());
        typeDef.getParameters().add((Object)edParam);
        hed.setHbTypeDef(typeDef);
    }

    private String getCustomDataType(EDataType eDataType) {
        Class<?> compClass;
        Class instanceClass;
        String typeClassName = eDataType.getInstanceClassName();
        if (EcoreDataTypes.INSTANCE.isSimpleType(eDataType, this.getPersistenceOptions())) {
            return null;
        }
        if (EcoreDataTypes.INSTANCE.isEnum((EClassifier)eDataType)) {
            return null;
        }
        if (eDataType.getInstanceClass() == Object.class) {
            return null;
        }
        if (typeClassName != null && (instanceClass = eDataType.getInstanceClass()) != null && instanceClass.isArray() && EcoreDataTypes.INSTANCE.isPrimitive(compClass = instanceClass.getComponentType())) {
            return null;
        }
        return typeClassName;
    }

    public String getDefaultUserType() {
        return "org.eclipse.emf.teneo.hibernate.mapping.DefaultToStringUserType";
    }
}

