/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.mapper;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEReference;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEStructuralFeature;
import org.eclipse.emf.teneo.annotations.pannotation.CascadeType;
import org.eclipse.emf.teneo.annotations.pannotation.JoinColumn;
import org.eclipse.emf.teneo.annotations.pannotation.JoinTable;
import org.eclipse.emf.teneo.annotations.pannotation.ManyToOne;
import org.eclipse.emf.teneo.extension.ExtensionPoint;
import org.eclipse.emf.teneo.hibernate.hbmodel.HbAnnotatedEReference;
import org.eclipse.emf.teneo.hibernate.hbmodel.HbAnnotatedETypeElement;
import org.eclipse.emf.teneo.hibernate.mapper.AbstractAssociationMapper;
import org.eclipse.emf.teneo.simpledom.Element;

public class ManyToOneMapper
extends AbstractAssociationMapper
implements ExtensionPoint {
    private static final Log log = LogFactory.getLog(ManyToOneMapper.class);

    public void process(PAnnotatedEReference paReference) {
        boolean nullable;
        HbAnnotatedEReference hbReference;
        boolean isProperty;
        Element currentElement;
        log.debug((Object)("Process many-to-one " + paReference));
        List<JoinColumn> jcs = this.getJoinColumns(paReference);
        EClass referedTo = paReference.getModelEReference().getEReferenceType();
        ManyToOne mto = paReference.getManyToOne();
        String targetName = mto.getTargetEntity();
        if (targetName == null) {
            targetName = this.getHbmContext().getEntityName(referedTo);
        }
        log.debug((Object)("Target " + targetName));
        JoinTable joinTable = null;
        PAnnotatedEReference aOpposite = null;
        if (paReference.getModelEReference().getEOpposite() != null && (aOpposite = paReference.getPaModel().getPAnnotated(paReference.getModelEReference().getEOpposite())).getOneToMany() != null && !aOpposite.getOneToMany().isList() && aOpposite.getJoinTable() != null) {
            joinTable = aOpposite.getJoinTable();
        }
        if (joinTable != null) {
            boolean addInverse = aOpposite != null && aOpposite.getOneToMany() != null && aOpposite.getOneToMany().getMappedBy() == null;
            currentElement = this.getHbmContext().getCurrent().addElement("join").addAttribute("table", joinTable.getName()).addAttribute("inverse", Boolean.toString(addInverse)).addAttribute("optional", Boolean.toString(mto.isOptional()));
        } else {
            currentElement = this.getHbmContext().getCurrent();
        }
        if (joinTable != null) {
            Element keyElement = currentElement.addElement("key");
            this.addKeyColumns((HbAnnotatedETypeElement)paReference, keyElement, (List<JoinColumn>)joinTable.getInverseJoinColumns());
        }
        Element associationElement = this.addManyToOne(currentElement, paReference, targetName, false);
        this.addAccessor(associationElement);
        if (!associationElement.getName().equals("any")) {
            this.addLazyProxy(associationElement, mto.getFetch(), paReference);
        }
        boolean bl = isProperty = (hbReference = (HbAnnotatedEReference)paReference).getHbType() != null;
        if (!isProperty && hbReference.getNaturalId() != null) {
            associationElement.addAttribute("natural-id", Boolean.toString(hbReference.getNaturalId().isMutable()));
        }
        if (!isProperty && joinTable != null) {
            this.addJoinColumns(paReference, associationElement, (List<JoinColumn>)joinTable.getJoinColumns(), mto.isOptional() || this.getHbmContext().isDoForceOptional((PAnnotatedEStructuralFeature)paReference) || this.getHbmContext().isCurrentElementFeatureMap());
        }
        if (!isProperty) {
            this.addCascadesForSingle(associationElement, this.getCascades(hbReference.getHbCascade(), (List<CascadeType>)mto.getCascade()));
        }
        if (hbReference.getHbFetch() != null) {
            associationElement.addAttribute("fetch", hbReference.getHbFetch().getValue().getName().toLowerCase());
        }
        boolean bl2 = nullable = this.getHbmContext().isDoForceOptional((PAnnotatedEStructuralFeature)paReference) || mto.isOptional() || this.getHbmContext().isCurrentElementFeatureMap();
        if (this.isEObject(targetName)) {
            String erefName = paReference.getModelEReference().getName();
            this.addColumnsAndFormula(associationElement, (PAnnotatedEStructuralFeature)paReference, this.getAnyTypeColumns(erefName, true), true, false);
        } else if (!isProperty) {
            this.addForeignKeyAttribute(associationElement, (PAnnotatedEStructuralFeature)paReference);
            this.addLazyProxy(associationElement, mto.getFetch(), paReference);
            if (joinTable == null) {
                this.addJoinColumns(paReference, associationElement, jcs, this.getHbmContext().isDoForceOptional((PAnnotatedEStructuralFeature)paReference) || mto.isOptional() || this.getHbmContext().isCurrentElementFeatureMap());
                associationElement.addAttribute("not-null", nullable ? "false" : "true");
            }
        } else if (isProperty) {
            associationElement.addAttribute("not-null", nullable ? "false" : "true");
        }
        if (paReference.getModelEReference().isContainment() && !nullable) {
            associationElement.addAttribute("unique", "true");
        }
    }
}

