/**
 * <copyright>
 *
 * Copyright (c) 2005, 2006, 2007, 2008 Springsite BV (The Netherlands) and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Martin Taal
 * </copyright>
 *
 * $Id: ExportXML.java,v 1.3 2008/02/28 07:07:59 mtaal Exp $
 */

package org.eclipse.emf.teneo.hibernate.eclipse;

import java.io.ByteArrayOutputStream;
import java.util.Properties;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.teneo.eclipse.resourcehandler.StoreExportXML;
import org.eclipse.emf.teneo.hibernate.HbConstants;
import org.eclipse.emf.teneo.hibernate.HbDataStore;
import org.eclipse.emf.teneo.hibernate.HbUtil;

/**
 * Performs the export xml action
 * 
 * @author <a href="mailto:mtaal@elver.org">Martin Taal</a>
 * @version $Revision: 1.3 $
 */

public class ExportXML extends StoreExportXML {
	/** Does the real export */
	protected byte[] doExport(Properties props) {
		HbDataStore emfds = HbUtil.getCreateDataStore(props);
		// for now export the whole content to one byte array
		final ByteArrayOutputStream os = new ByteArrayOutputStream();
		emfds.exportDataStore(os, HbConstants.EXCHANGE_FORMAT_XML, ResourcesPlugin.getEncoding());
		return os.toByteArray();
	}

}
