/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.annotations;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.teneo.PersistenceOptions;
import org.eclipse.emf.teneo.annotations.mapper.AbstractAnnotator;
import org.eclipse.emf.teneo.annotations.mapper.ManyToOneReferenceAnnotator;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEClass;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEReference;
import org.eclipse.emf.teneo.annotations.pannotation.FetchType;
import org.eclipse.emf.teneo.hibernate.annotations.HbAnnotationUtil;
import org.eclipse.emf.teneo.hibernate.hbmodel.HbAnnotatedEClass;

public class HbManyToOneReferenceAnnotator
extends ManyToOneReferenceAnnotator {
    protected static final Log log = LogFactory.getLog(HbManyToOneReferenceAnnotator.class);
    private boolean optionSetProxy = false;

    public void annotate(PAnnotatedEReference aReference) {
        if (this.getPersistenceOptions().isAddIndexForForeignKey()) {
            HbAnnotationUtil.setIndex(aReference, (AbstractAnnotator)this);
        }
        super.annotate(aReference);
    }

    protected FetchType getFetch(PAnnotatedEClass aClass) {
        if (aClass == null) {
            return FetchType.EAGER;
        }
        if (this.optionSetProxy) {
            return FetchType.LAZY;
        }
        if (((HbAnnotatedEClass)aClass).getHbProxy() != null) {
            return FetchType.LAZY;
        }
        return super.getFetch(aClass);
    }

    public void setPersistenceOptions(PersistenceOptions persistenceOptions) {
        super.setPersistenceOptions(persistenceOptions);
        this.optionSetProxy = persistenceOptions.isSetProxy();
    }
}

