/*
 * Decompiled with CFR 0.152.
 */
package extlibrary;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.AbstractEnumerator;

public final class BookCategory
extends AbstractEnumerator {
    public static final int MYSTERY = 0;
    public static final int SCIENCE_FICTION = 1;
    public static final int BIOGRAPHY = 2;
    public static final BookCategory MYSTERY_LITERAL = new BookCategory(0, "Mystery", "Mystery");
    public static final BookCategory SCIENCE_FICTION_LITERAL = new BookCategory(1, "ScienceFiction", "ScienceFiction");
    public static final BookCategory BIOGRAPHY_LITERAL = new BookCategory(2, "Biography", "Biography");
    private static final BookCategory[] VALUES_ARRAY = new BookCategory[]{MYSTERY_LITERAL, SCIENCE_FICTION_LITERAL, BIOGRAPHY_LITERAL};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

    public static BookCategory get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BookCategory result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BookCategory getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BookCategory result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BookCategory get(int value) {
        switch (value) {
            case 0: {
                return MYSTERY_LITERAL;
            }
            case 1: {
                return SCIENCE_FICTION_LITERAL;
            }
            case 2: {
                return BIOGRAPHY_LITERAL;
            }
        }
        return null;
    }

    private BookCategory(int value, String name, String literal) {
        super(value, name, literal);
    }
}

