/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.glazedlists.filterrow;

import ca.odell.glazedlists.matchers.ThresholdMatcherEditor;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Pattern;
import org.eclipse.nebula.widgets.nattable.filterrow.ParseResult;
import org.eclipse.nebula.widgets.nattable.filterrow.TextMatchingMode;
import org.eclipse.nebula.widgets.nattable.util.ObjectUtils;

public final class FilterRowUtils {
    private static final String TWO_CHARACTER_REGEX = "\\[(((.){2})|((.)\\\\(.))|(\\\\(.){2})|(\\\\(.)\\\\(.)))\\]";
    private static final String MASKED_BACKSLASH = "\\\\";
    private static final String BACKSLASH_REPLACEMENT = "backslash";

    private FilterRowUtils() {
    }

    public static List<ParseResult> parse(String string, String textDelimiter, TextMatchingMode textMatchingMode) {
        ArrayList<ParseResult> parseResults = new ArrayList<ParseResult>();
        if (!(textDelimiter == null || string.startsWith("(") && string.endsWith(")"))) {
            String[] splitted;
            String[] stringArray = splitted = string.split(textDelimiter);
            int n = splitted.length;
            int n2 = 0;
            while (n2 < n) {
                String split = stringArray[n2];
                FilterRowUtils.parse(split, textMatchingMode, parseResults);
                ++n2;
            }
        } else {
            FilterRowUtils.parse(string, textMatchingMode, parseResults);
        }
        return parseResults;
    }

    private static void parse(String string, TextMatchingMode textMatchingMode, List<ParseResult> parseResults) {
        ParseResult parseResult = textMatchingMode == TextMatchingMode.REGULAR_EXPRESSION ? FilterRowUtils.parseExpression(string) : FilterRowUtils.parseLiteral(string);
        parseResults.add(parseResult);
    }

    public static ParseResult parseExpression(String string) {
        Scanner scanner = new Scanner(string.trim());
        ParseResult parseResult = new ParseResult();
        Pattern p = Pattern.compile("<>|([>|<]?=?)");
        String opToken = scanner.findWithinHorizon(p, 2);
        if (ObjectUtils.isNotEmpty((String)opToken)) {
            parseResult.setMatchType(ParseResult.MatchType.parse((String)opToken));
            while (scanner.hasNext()) {
                parseResult.setValueToMatch(scanner.next());
            }
        } else {
            parseResult.setValueToMatch(string.trim());
        }
        scanner.close();
        return parseResult;
    }

    public static ParseResult parseLiteral(String string) {
        ParseResult parseResult = new ParseResult();
        parseResult.setMatchType(ParseResult.MatchType.NONE);
        parseResult.setValueToMatch(string);
        return parseResult;
    }

    public static <T> void setMatchOperation(ThresholdMatcherEditor<T, Object> thresholdMatcherEditor, ParseResult.MatchType matchType) {
        switch (matchType) {
            case GREATER_THAN: {
                thresholdMatcherEditor.setMatchOperation(ThresholdMatcherEditor.GREATER_THAN);
                break;
            }
            case GREATER_THAN_OR_EQUAL: {
                thresholdMatcherEditor.setMatchOperation(ThresholdMatcherEditor.GREATER_THAN_OR_EQUAL);
                break;
            }
            case LESS_THAN: {
                thresholdMatcherEditor.setMatchOperation(ThresholdMatcherEditor.LESS_THAN);
                break;
            }
            case LESS_THAN_OR_EQUAL: {
                thresholdMatcherEditor.setMatchOperation(ThresholdMatcherEditor.LESS_THAN_OR_EQUAL);
                break;
            }
            case NOT_EQUAL: {
                thresholdMatcherEditor.setMatchOperation(ThresholdMatcherEditor.NOT_EQUAL);
                break;
            }
            default: {
                thresholdMatcherEditor.setMatchOperation(ThresholdMatcherEditor.EQUAL);
            }
        }
    }

    public static String[] getSeparatorCharacters(String delimiter) {
        if (delimiter != null && delimiter.matches(TWO_CHARACTER_REGEX)) {
            String inspect = delimiter.substring(1, delimiter.length() - 1);
            inspect = inspect.replace(MASKED_BACKSLASH, BACKSLASH_REPLACEMENT);
            inspect = inspect.replaceAll(MASKED_BACKSLASH, "");
            if ((inspect = inspect.replace(BACKSLASH_REPLACEMENT, "\\")).length() == 2) {
                String[] result = new String[]{inspect.substring(0, 1), inspect.substring(1, 2)};
                return result;
            }
        }
        return null;
    }
}

