/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.fillhandle.action;

import java.util.Date;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.eclipse.nebula.widgets.nattable.Messages;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.copy.InternalCellClipboard;
import org.eclipse.nebula.widgets.nattable.fillhandle.command.FillHandlePasteCommand;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public final class FillHandleActionHelper {
    private FillHandleActionHelper() {
    }

    public static boolean showMenu(NatTable natTable, InternalCellClipboard clipboard) {
        if (clipboard == null || clipboard.getCopiedCells() == null) {
            return false;
        }
        Class<?> type = null;
        ILayerCell[][] iLayerCellArray = clipboard.getCopiedCells();
        int n = iLayerCellArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILayerCell[] cells;
            ILayerCell[] iLayerCellArray2 = cells = iLayerCellArray[n2];
            int n3 = cells.length;
            int n4 = 0;
            while (n4 < n3) {
                ILayerCell cell = iLayerCellArray2[n4];
                if (cell.getDataValue() == null) {
                    return false;
                }
                if (type == null ? !Number.class.isAssignableFrom(type = cell.getDataValue().getClass()) && !Date.class.isAssignableFrom(type) : type != cell.getDataValue().getClass()) {
                    return false;
                }
                ++n4;
            }
            ++n2;
        }
        return true;
    }

    public static Menu createFillHandleMenu(final NatTable natTable, final Supplier<SelectionLayer.MoveDirectionEnum> directionProvider, final Consumer<NatTable> resetRunnable) {
        Menu menu = new Menu((Control)natTable);
        MenuItem copyItem = new MenuItem(menu, 8);
        copyItem.setText(Messages.getLocalizedMessage("%FillHandleDragMode.menu.item.copy"));
        copyItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                natTable.doCommand(new FillHandlePasteCommand(FillHandlePasteCommand.FillHandleOperation.COPY, (SelectionLayer.MoveDirectionEnum)((Object)directionProvider.get()), natTable.getConfigRegistry()));
            }
        });
        MenuItem seriesItem = new MenuItem(menu, 8);
        seriesItem.setText(Messages.getLocalizedMessage("%FillHandleDragMode.menu.item.series"));
        seriesItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                natTable.doCommand(new FillHandlePasteCommand(FillHandlePasteCommand.FillHandleOperation.SERIES, (SelectionLayer.MoveDirectionEnum)((Object)directionProvider.get()), natTable.getConfigRegistry()));
            }
        });
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuHidden(MenuEvent e) {
                Display.getDefault().asyncExec(() -> resetRunnable.accept(natTable));
            }
        });
        natTable.addDisposeListener(e -> menu.dispose());
        return menu;
    }
}

