/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.coordinate;

import org.eclipse.nebula.widgets.nattable.layer.ILayer;

public final class PositionCoordinate {
    private ILayer layer;
    public int columnPosition;
    public int rowPosition;

    public PositionCoordinate(ILayer layer, int columnPosition, int rowPosition) {
        this.layer = layer;
        this.columnPosition = columnPosition;
        this.rowPosition = rowPosition;
    }

    public PositionCoordinate(PositionCoordinate coord) {
        this(coord.layer, coord.columnPosition, coord.rowPosition);
    }

    public ILayer getLayer() {
        return this.layer;
    }

    public int getColumnPosition() {
        return this.columnPosition;
    }

    public void setColumnPosition(int columnPosition) {
        this.columnPosition = columnPosition;
    }

    public int getRowPosition() {
        return this.rowPosition;
    }

    public void setRowPosition(int rowPosition) {
        this.rowPosition = rowPosition;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + String.valueOf(this.layer) + ":" + this.columnPosition + "," + this.rowPosition + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PositionCoordinate other = (PositionCoordinate)obj;
        if (this.columnPosition != other.columnPosition) {
            return false;
        }
        if (this.layer == null ? other.layer != null : !this.layer.equals(other.layer)) {
            return false;
        }
        return this.rowPosition == other.rowPosition;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.columnPosition;
        result = 31 * result + (this.layer == null ? 0 : this.layer.hashCode());
        result = 31 * result + this.rowPosition;
        return result;
    }
}

