/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.nosql.delete;

import ee.jakarta.tck.nosql.AbstractTemplateTest;
import ee.jakarta.tck.nosql.entities.Beer;
import ee.jakarta.tck.nosql.entities.Drink;
import ee.jakarta.tck.nosql.factories.DrinkListSupplier;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ArgumentsSource;

public class DeleteTemplateInheritanceTest
extends AbstractTemplateTest {
    @ParameterizedTest
    @ArgumentsSource(value=DrinkListSupplier.class)
    @DisplayName(value="Should insert Iterable and delete with no conditions")
    void shouldInsertIterableAndDeleteNoCondition(List<Drink> entities) {
        entities.forEach(entity -> this.template.insert(entity));
        try {
            this.template.delete(Drink.class).execute();
            List result = this.template.select(Drink.class).result();
            Assertions.assertThat((List)result).isEmpty();
        }
        catch (UnsupportedOperationException exp) {
            Assertions.assertThat((Throwable)exp).isInstanceOf(UnsupportedOperationException.class);
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=DrinkListSupplier.class)
    @DisplayName(value="Should insert Iterable and delete with simple condition on alcoholPercentage")
    void shouldInsertIterableAndDeleteWithSimpleCondition(List<Drink> entities) {
        entities.forEach(entity -> this.template.insert(entity));
        try {
            this.template.delete(Drink.class).where("alcoholPercentage").eq((Object)entities.get(0).getAlcoholPercentage()).execute();
            List result = this.template.select(Drink.class).where("alcoholPercentage").eq((Object)entities.get(0).getAlcoholPercentage()).result();
            Assertions.assertThat((List)result).isEmpty();
        }
        catch (UnsupportedOperationException exp) {
            Assertions.assertThat((Throwable)exp).isInstanceOf(UnsupportedOperationException.class);
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=DrinkListSupplier.class)
    @DisplayName(value="Should insert Iterable and delete with greater-than condition on alcoholPercentage")
    void shouldInsertIterableAndDeleteWithGreaterThanCondition(List<Drink> entities) {
        entities.forEach(entity -> this.template.insert(entity));
        try {
            this.template.delete(Drink.class).where("alcoholPercentage").gt((Object)entities.get(0).getAlcoholPercentage()).execute();
            List result = this.template.select(Drink.class).where("alcoholPercentage").gt((Object)entities.get(0).getAlcoholPercentage()).result();
            Assertions.assertThat((List)result).isEmpty();
        }
        catch (UnsupportedOperationException exp) {
            Assertions.assertThat((Throwable)exp).isInstanceOf(UnsupportedOperationException.class);
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=DrinkListSupplier.class)
    @DisplayName(value="Should insert Iterable and delete with less-than condition on alcoholPercentage")
    void shouldInsertIterableAndDeleteWithLessThanCondition(List<Drink> entities) {
        entities.forEach(entity -> this.template.insert(entity));
        try {
            this.template.delete(Drink.class).where("alcoholPercentage").lt((Object)entities.get(0).getAlcoholPercentage()).execute();
            List result = this.template.select(Drink.class).where("alcoholPercentage").lt((Object)entities.get(0).getAlcoholPercentage()).result();
            Assertions.assertThat((List)result).isEmpty();
        }
        catch (UnsupportedOperationException exp) {
            Assertions.assertThat((Throwable)exp).isInstanceOf(UnsupportedOperationException.class);
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=DrinkListSupplier.class)
    @DisplayName(value="Should insert Iterable and delete with 'in' condition on alcoholPercentage")
    void shouldInsertIterableAndDeleteWithInCondition(List<Drink> entities) {
        entities.forEach(entity -> this.template.insert(entity));
        try {
            this.template.delete(Drink.class).where("alcoholPercentage").in(List.of(Double.valueOf(entities.get(0).getAlcoholPercentage()))).execute();
            List result = this.template.select(Drink.class).where("alcoholPercentage").in(List.of(Double.valueOf(entities.get(0).getAlcoholPercentage()))).result();
            Assertions.assertThat((List)result).isEmpty();
        }
        catch (UnsupportedOperationException exp) {
            Assertions.assertThat((Throwable)exp).isInstanceOf(UnsupportedOperationException.class);
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=DrinkListSupplier.class)
    @DisplayName(value="Should insert Iterable and delete with 'between' condition on alcoholPercentage")
    void shouldInsertIterableAndDeleteWithBetweenCondition(List<Drink> entities) {
        entities.forEach(entity -> this.template.insert(entity));
        try {
            this.template.delete(Drink.class).where("alcoholPercentage").between((Object)entities.get(0).getAlcoholPercentage(), (Object)(entities.get(0).getAlcoholPercentage() + 5.0)).execute();
            List result = this.template.select(Drink.class).where("alcoholPercentage").between((Object)entities.get(0).getAlcoholPercentage(), (Object)(entities.get(0).getAlcoholPercentage() + 5.0)).result();
            Assertions.assertThat((List)result).isEmpty();
        }
        catch (UnsupportedOperationException exp) {
            Assertions.assertThat((Throwable)exp).isInstanceOf(UnsupportedOperationException.class);
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=DrinkListSupplier.class)
    @DisplayName(value="Should insert Iterable and delete with 'complex' query using 'and' on alcoholPercentage")
    void shouldInsertIterableAndDeleteWithComplexQueryAnd(List<Drink> entities) {
        entities.forEach(entity -> this.template.insert(entity));
        try {
            this.template.delete(Drink.class).where("alcoholPercentage").gt((Object)entities.get(0).getAlcoholPercentage()).and("name").eq((Object)entities.get(0).getName()).execute();
            List result = this.template.select(Drink.class).where("alcoholPercentage").gt((Object)entities.get(0).getAlcoholPercentage()).and("name").eq((Object)entities.get(0).getName()).result();
            Assertions.assertThat((List)result).isEmpty();
        }
        catch (UnsupportedOperationException exp) {
            Assertions.assertThat((Throwable)exp).isInstanceOf(UnsupportedOperationException.class);
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=DrinkListSupplier.class)
    @DisplayName(value="Should insert Iterable and delete with no conditions")
    void shouldDeleteUsingSubType(List<Drink> entities) {
        entities.forEach(entity -> this.template.insert(entity));
        try {
            this.template.delete(Beer.class).execute();
            List result = this.template.select(Drink.class).result();
            ((ListAssert)Assertions.assertThat((List)result).isNotEmpty()).allMatch(d -> !d.getClass().equals(Beer.class));
        }
        catch (UnsupportedOperationException exp) {
            Assertions.assertThat((Throwable)exp).isInstanceOf(UnsupportedOperationException.class);
        }
    }
}

