/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.quickaccess;

import java.util.Arrays;
import java.util.Optional;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.quickaccess.QuickAccessContents;
import org.eclipse.ui.internal.quickaccess.QuickAccessDialog;

public class QuickAccessHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent executionEvent) {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow(executionEvent);
        if (window == null) {
            return null;
        }
        Optional<QuickAccessContents> existingContents = Arrays.stream(window.getShell().getDisplay().getShells()).filter(Shell::isVisible).map(Widget::getData).filter(QuickAccessDialog.class::isInstance).map(QuickAccessDialog.class::cast).map(QuickAccessDialog::getQuickAccessContents).findAny();
        if (existingContents.isPresent()) {
            QuickAccessContents contents;
            contents.setShowAllMatches(!(contents = existingContents.get()).getShowAllMatches());
        } else {
            QuickAccessHandler.displayQuickAccessDialog(window, executionEvent.getCommand());
        }
        return null;
    }

    private static void displayQuickAccessDialog(IWorkbenchWindow window, Command command) {
        QuickAccessDialog popupDialog = new QuickAccessDialog(window, command);
        popupDialog.open();
    }
}

