/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.filetransfer.events.socket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.filetransfer.events.socket.ISocketEvent;
import org.eclipse.ecf.filetransfer.events.socket.ISocketEventSource;
import org.eclipse.ecf.filetransfer.events.socket.ISocketListener;
import org.eclipse.ecf.filetransfer.events.socketfactory.INonconnectedSocketFactory;
import org.eclipse.ecf.provider.filetransfer.events.socket.AbstractSocketWrapper;
import org.eclipse.ecf.provider.filetransfer.events.socket.SocketClosedEvent;
import org.eclipse.ecf.provider.filetransfer.events.socket.SocketConnectedEvent;
import org.eclipse.ecf.provider.filetransfer.events.socket.SocketCreatedEvent;

public class SocketEventCreateUtil {
    static void fireEvent(ISocketListener spyListener, ISocketEvent event) {
        if (spyListener != null) {
            spyListener.handleSocketEvent(event);
        }
        event.getSource().fireEvent(event);
    }

    public static Socket createSocket(final ISocketListener spyListener, final ISocketEventSource socketEventSource, INonconnectedSocketFactory unconnectedFactory, InetSocketAddress remoteInetAddress, InetSocketAddress localInetAddress, int timeout) throws IOException {
        Trace.entering((String)"org.eclipse.ecf.filetransfer", (String)"org.eclipse.ecf.provider.filetransfer/debug/methods/entering", SocketEventCreateUtil.class, (String)("createSocket " + remoteInetAddress.toString() + " timeout=" + timeout));
        final Socket factorySocket = unconnectedFactory.createSocket();
        SocketEventCreateUtil.fireEvent(spyListener, new SocketCreatedEvent(socketEventSource, factorySocket));
        try {
            Trace.trace((String)"org.eclipse.ecf.filetransfer", (String)("bind(" + localInetAddress.toString() + ")"));
            factorySocket.bind(localInetAddress);
            Trace.trace((String)"org.eclipse.ecf.filetransfer", (String)("connect(" + remoteInetAddress.toString() + ", " + timeout + ")"));
            factorySocket.connect(remoteInetAddress, timeout);
            Trace.trace((String)"org.eclipse.ecf.filetransfer", (String)"connected");
        }
        catch (IOException e) {
            Trace.catching((String)"org.eclipse.ecf.filetransfer", (String)"org.eclipse.ecf.provider.filetransfer/debug/exceptions/catching", SocketEventCreateUtil.class, (String)"createSocket", (Throwable)e);
            SocketEventCreateUtil.fireEvent(spyListener, new SocketClosedEvent(socketEventSource, factorySocket, factorySocket));
            Trace.throwing((String)"org.eclipse.ecf.filetransfer", (String)"org.eclipse.ecf.provider.filetransfer/debug/exceptions/throwing", SocketEventCreateUtil.class, (String)"createSocket", (Throwable)e);
            throw e;
        }
        final Socket[] wrap = new Socket[1];
        AbstractSocketWrapper myWrap = new AbstractSocketWrapper(factorySocket){

            @Override
            public void close() throws IOException {
                try {
                    Trace.trace((String)"org.eclipse.ecf.filetransfer", (String)("closing socket " + this.toString()));
                    super.close();
                }
                finally {
                    SocketEventCreateUtil.fireEvent(spyListener, new SocketClosedEvent(socketEventSource, factorySocket, wrap[0]));
                }
            }
        };
        SocketConnectedEvent connectedEvent = new SocketConnectedEvent(socketEventSource, factorySocket, myWrap);
        SocketEventCreateUtil.fireEvent(spyListener, connectedEvent);
        wrap[0] = connectedEvent.getSocket() == myWrap ? myWrap : connectedEvent.getSocket();
        return wrap[0];
    }
}

