/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.preferences;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.internal.preferences.Base64;
import org.eclipse.core.internal.preferences.ImmutableMap;
import org.eclipse.core.internal.preferences.PreferencesOSGiUtils;
import org.eclipse.core.internal.preferences.PrefsMessages;
import org.eclipse.core.internal.preferences.RootPreferences;
import org.eclipse.core.internal.preferences.ScopeDescriptor;
import org.eclipse.core.internal.preferences.SortedProperties;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferenceNodeVisitor;
import org.eclipse.core.runtime.preferences.IScope;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class EclipsePreferences
implements IEclipsePreferences,
IScope {
    public static final String DEFAULT_PREFERENCES_DIRNAME = ".settings";
    public static final String PREFS_FILE_EXTENSION = "prefs";
    protected static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String FALSE = "false";
    private static final String TRUE = "true";
    protected static final String VERSION_KEY = "eclipse.preferences.version";
    protected static final String VERSION_VALUE = "1";
    protected static final String PATH_SEPARATOR = String.valueOf('/');
    protected static final String DOUBLE_SLASH = "//";
    protected static final String EMPTY_STRING = "";
    private static final String BACKUP_FILE_EXTENSION = ".bak";
    private String cachedPath;
    protected ImmutableMap properties = ImmutableMap.EMPTY;
    protected Map<String, Object> children;
    private final Object childAndPropertyLock = new Object();
    protected boolean dirty = false;
    protected boolean loading = false;
    protected final String name;
    protected final EclipsePreferences parent;
    protected boolean removed = false;
    private final ListenerList<IEclipsePreferences.INodeChangeListener> nodeChangeListeners = new ListenerList();
    private final ListenerList<IEclipsePreferences.IPreferenceChangeListener> preferenceChangeListeners = new ListenerList();
    private ScopeDescriptor descriptor;
    public static final boolean DEBUG_PREFERENCE_GENERAL;
    public static final boolean DEBUG_PREFERENCE_SET;
    public static final boolean DEBUG_PREFERENCE_GET;
    private static final Object WRITE_LOCK;

    static {
        PreferencesOSGiUtils osgiDefaults = PreferencesOSGiUtils.getDefault();
        DEBUG_PREFERENCE_GENERAL = osgiDefaults.getBooleanDebugOption("org.eclipse.equinox.preferences/general", false);
        DEBUG_PREFERENCE_SET = osgiDefaults.getBooleanDebugOption("org.eclipse.equinox.preferences/set", false);
        DEBUG_PREFERENCE_GET = osgiDefaults.getBooleanDebugOption("org.eclipse.equinox.preferences/get", false);
        WRITE_LOCK = new Object();
    }

    public EclipsePreferences() {
        this(null, null);
    }

    protected EclipsePreferences(EclipsePreferences parent, String name) {
        this.parent = parent;
        this.name = name;
        this.cachedPath = null;
    }

    public String absolutePath() {
        if (this.cachedPath == null) {
            String parentPath;
            this.cachedPath = this.parent == null ? PATH_SEPARATOR : ((parentPath = this.parent.absolutePath()).length() == 1 ? parentPath + this.name() : parentPath + PATH_SEPARATOR + this.name());
        }
        return this.cachedPath;
    }

    @Override
    public void accept(IPreferenceNodeVisitor visitor) throws BackingStoreException {
        if (!visitor.visit(this)) {
            return;
        }
        for (IEclipsePreferences p : this.getChildren(true)) {
            p.accept(visitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IEclipsePreferences addChild(String childName, IEclipsePreferences child) {
        Object object = this.childAndPropertyLock;
        synchronized (object) {
            if (this.children == null) {
                this.children = new ConcurrentHashMap<String, Object>();
            }
            this.children.put(childName, child == null ? childName : child);
            return child;
        }
    }

    @Override
    public void addNodeChangeListener(IEclipsePreferences.INodeChangeListener listener) {
        this.checkRemoved();
        this.nodeChangeListeners.add((Object)listener);
        if (DEBUG_PREFERENCE_GENERAL) {
            PrefsMessages.message("Added preference node change listener: " + String.valueOf(listener) + " to: " + this.absolutePath());
        }
    }

    @Override
    public void addPreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener listener) {
        this.checkRemoved();
        this.preferenceChangeListeners.add((Object)listener);
        if (DEBUG_PREFERENCE_GENERAL) {
            PrefsMessages.message("Added preference property change listener: " + String.valueOf(listener) + " to: " + this.absolutePath());
        }
    }

    private IEclipsePreferences calculateRoot() {
        IEclipsePreferences result = this;
        while (result.parent() != null) {
            result = (IEclipsePreferences)result.parent();
        }
        return result;
    }

    protected void checkRemoved() {
        if (this.removed) {
            throw new IllegalStateException(NLS.bind((String)PrefsMessages.preferences_removedNode, (Object)this.name));
        }
    }

    public String[] childrenNames() throws BackingStoreException {
        this.checkRemoved();
        String[] internal = this.internalChildNames();
        if (internal.length != 0) {
            return internal;
        }
        if (this.descriptor != null && EclipsePreferences.getSegmentCount(this.absolutePath()) == 1) {
            return this.descriptor.childrenNames(this.absolutePath());
        }
        return internal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String[] internalChildNames() {
        Object object = this.childAndPropertyLock;
        synchronized (object) {
            if (this.children == null || this.children.isEmpty()) {
                return EMPTY_STRING_ARRAY;
            }
            return (String[])this.children.keySet().toArray(String[]::new);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        String[] keys;
        this.checkRemoved();
        Object object = this.childAndPropertyLock;
        synchronized (object) {
            keys = this.properties.keys();
        }
        String[] stringArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            this.remove(key);
            ++n2;
        }
        this.makeDirty();
    }

    protected List<String> computeChildren(IPath root) {
        if (root == null) {
            return List.of();
        }
        IPath dir = root.append(DEFAULT_PREFERENCES_DIRNAME);
        ArrayList<String> result = new ArrayList<String>();
        String extension = ".prefs";
        File[] totalFiles = dir.toFile().listFiles();
        if (totalFiles != null) {
            File[] fileArray = totalFiles;
            int n = totalFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File totalFile = fileArray[n2];
                String filename = totalFile.getName();
                if (filename.endsWith(extension) && totalFile.isFile()) {
                    String shortName = filename.substring(0, filename.length() - extension.length());
                    result.add(shortName);
                }
                ++n2;
            }
        }
        return result;
    }

    protected IPath computeLocation(IPath root, String qualifier) {
        return root == null ? null : root.append(DEFAULT_PREFERENCES_DIRNAME).append(qualifier).addFileExtension(PREFS_FILE_EXTENSION);
    }

    protected static void convertFromProperties(EclipsePreferences node, Properties table, boolean notify) {
        String version = table.getProperty(VERSION_KEY);
        if (version != null) {
            VERSION_VALUE.equals(version);
        }
        table.remove(VERSION_KEY);
        for (Object propName : table.keySet()) {
            String fullKey = (String)propName;
            String value = table.getProperty(fullKey);
            if (value == null) continue;
            String[] splitPath = EclipsePreferences.decodePath(fullKey);
            String path = splitPath[0];
            path = EclipsePreferences.makeRelative(path);
            String key = splitPath[1];
            if (DEBUG_PREFERENCE_SET) {
                PrefsMessages.message("Setting preference: " + path + "/" + key + "=" + value);
            }
            EclipsePreferences childNode = (EclipsePreferences)node.internalNode(path, false, null);
            String oldValue = childNode.internalPut(key, value);
            if (!notify || value.equals(oldValue)) continue;
            childNode.firePreferenceEvent(key, oldValue, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(Properties props, IPath location) throws BackingStoreException {
        Path preferenceFile = location.toFile().toPath();
        Path parentFile = preferenceFile.getParent();
        if (parentFile == null) {
            return;
        }
        try {
            Files.createDirectories(parentFile, new FileAttribute[0]);
            String fileContent = EclipsePreferences.removeTimestampFromTable(props);
            Object object = WRITE_LOCK;
            synchronized (object) {
                if (Files.exists(preferenceFile, new LinkOption[0])) {
                    Path tmp = preferenceFile.resolveSibling(String.valueOf(preferenceFile.getFileName()) + BACKUP_FILE_EXTENSION);
                    Files.writeString(tmp, (CharSequence)fileContent, StandardCharsets.UTF_8, new OpenOption[0]);
                    try {
                        Files.move(tmp, preferenceFile, StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (NoSuchFileException e) {
                        Files.move(tmp, preferenceFile, StandardCopyOption.REPLACE_EXISTING);
                    }
                } else {
                    Files.writeString(preferenceFile, (CharSequence)fileContent, StandardCharsets.UTF_8, new OpenOption[0]);
                }
            }
        }
        catch (IOException e) {
            String message = NLS.bind((String)PrefsMessages.preferences_saveException, (Object)location);
            EclipsePreferences.log(Status.error((String)message, (Throwable)e));
            throw new BackingStoreException(message, (Throwable)e);
        }
    }

    protected static String removeTimestampFromTable(Properties properties) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        properties.store(output, null);
        String string = output.toString(StandardCharsets.UTF_8);
        String separator = System.lineSeparator();
        return string.substring(string.indexOf(separator) + separator.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties convertToProperties(Properties result, String prefix) throws BackingStoreException {
        ImmutableMap temp;
        boolean addSeparator = prefix.length() != 0;
        Object object = this.childAndPropertyLock;
        synchronized (object) {
            temp = this.properties;
        }
        String[] stringArray = temp.keys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            String value = temp.get(key);
            if (value != null) {
                result.put(EclipsePreferences.encodePath(prefix, key), value);
            }
            ++n2;
        }
        for (IEclipsePreferences childNode : this.getChildren(true)) {
            EclipsePreferences child = (EclipsePreferences)childNode;
            String fullPath = addSeparator ? prefix + PATH_SEPARATOR + child.name() : child.name();
            child.convertToProperties(result, fullPath);
        }
        return result;
    }

    @Override
    public IEclipsePreferences create(IEclipsePreferences nodeParent, String nodeName) {
        return this.create((EclipsePreferences)nodeParent, nodeName, null);
    }

    protected boolean isLoading() {
        return this.loading;
    }

    protected void setLoading(boolean isLoading) {
        this.loading = isLoading;
    }

    public IEclipsePreferences create(EclipsePreferences nodeParent, String nodeName, Object context) {
        EclipsePreferences result = this.internalCreate(nodeParent, nodeName, context);
        nodeParent.addChild(nodeName, result);
        IEclipsePreferences loadLevel = result.getLoadLevel();
        if (loadLevel == null || result != loadLevel || this.isAlreadyLoaded(result) || result.isLoading()) {
            return result;
        }
        try {
            try {
                result.setLoading(true);
                result.load();
                result.loaded();
                result.flush();
            }
            catch (BackingStoreException e) {
                IPath location = result.getLocation();
                String message = NLS.bind((String)PrefsMessages.preferences_loadException, (Object)(location == null ? EMPTY_STRING : location.toString()));
                IStatus status = Status.error((String)message, (Throwable)e);
                RuntimeLog.log((IStatus)status);
                result.setLoading(false);
            }
        }
        finally {
            result.setLoading(false);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws BackingStoreException {
        IEclipsePreferences toFlush = null;
        Object object = this.childAndPropertyLock;
        synchronized (object) {
            toFlush = this.internalFlush();
        }
        if (toFlush != null) {
            toFlush.flush();
        }
    }

    protected IEclipsePreferences internalFlush() throws BackingStoreException {
        this.checkRemoved();
        IEclipsePreferences loadLevel = this.getLoadLevel();
        if (loadLevel == null) {
            String[] stringArray = this.childrenNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String childrenName = stringArray[n2];
                this.node(childrenName).flush();
                ++n2;
            }
            return null;
        }
        if (this != loadLevel) {
            return loadLevel;
        }
        if (!this.dirty) {
            return null;
        }
        this.dirty = false;
        try {
            this.save();
        }
        catch (BackingStoreException e) {
            this.dirty = true;
            throw e;
        }
        return null;
    }

    public String get(String key, String defaultValue) {
        String value = this.internalGet(key);
        return value == null ? defaultValue : value;
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        String value = this.internalGet(key);
        return value == null ? defaultValue : TRUE.equalsIgnoreCase(value);
    }

    public byte[] getByteArray(String key, byte[] defaultValue) {
        String value = this.internalGet(key);
        return value == null ? defaultValue : Base64.decode(value.getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean childExists(String childName) {
        Object object = this.childAndPropertyLock;
        synchronized (object) {
            block4: {
                if (this.children != null) break block4;
                return false;
            }
            return this.children.get(childName) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IEclipsePreferences getChild(String key, Object context, boolean create) {
        Object object = this.childAndPropertyLock;
        synchronized (object) {
            block9: {
                Object value;
                block8: {
                    block7: {
                        if (this.children != null) break block7;
                        return null;
                    }
                    value = this.children.get(key);
                    if (value != null) break block8;
                    return null;
                }
                if (value instanceof IEclipsePreferences) {
                    IEclipsePreferences eclipsePreferences = (IEclipsePreferences)value;
                    return eclipsePreferences;
                }
                if (create) break block9;
                return null;
            }
        }
        return this.addChild(key, this.create(this, key, context));
    }

    private List<IEclipsePreferences> getChildren(boolean create) {
        ArrayList<IEclipsePreferences> result = new ArrayList<IEclipsePreferences>();
        String[] stringArray = this.internalChildNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String n3 = stringArray[n2];
            IEclipsePreferences child = this.getChild(n3, null, create);
            if (child != null) {
                result.add(child);
            }
            ++n2;
        }
        return result;
    }

    public double getDouble(String key, double defaultValue) {
        String value = this.internalGet(key);
        double result = defaultValue;
        if (value != null) {
            try {
                result = Double.parseDouble(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    public float getFloat(String key, float defaultValue) {
        String value = this.internalGet(key);
        float result = defaultValue;
        if (value != null) {
            try {
                result = Float.parseFloat(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    public int getInt(String key, int defaultValue) {
        String value = this.internalGet(key);
        int result = defaultValue;
        if (value != null) {
            try {
                result = Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    protected IEclipsePreferences getLoadLevel() {
        return this.descriptor == null ? null : this.descriptor.getLoadLevel(this);
    }

    protected IPath getLocation() {
        return null;
    }

    public long getLong(String key, long defaultValue) {
        String value = this.internalGet(key);
        long result = defaultValue;
        if (value != null) {
            try {
                result = Long.parseLong(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    protected EclipsePreferences internalCreate(EclipsePreferences nodeParent, String nodeName, Object context) {
        EclipsePreferences result = new EclipsePreferences(nodeParent, nodeName);
        result.descriptor = this.descriptor;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String internalGet(String key) {
        String result;
        if (key == null) {
            throw new NullPointerException();
        }
        this.checkRemoved();
        Object object = this.childAndPropertyLock;
        synchronized (object) {
            result = this.properties.get(key);
        }
        if (DEBUG_PREFERENCE_GET) {
            PrefsMessages.message("Getting preference value: " + this.absolutePath() + "/" + key + "->" + result);
        }
        return result;
    }

    protected IEclipsePreferences internalNode(String path, boolean notify, Object context) {
        this.checkRemoved();
        if (path.isEmpty()) {
            return this;
        }
        if (path.charAt(0) == '/') {
            return (IEclipsePreferences)this.calculateRoot().node(path.substring(1));
        }
        int index = path.indexOf(47);
        String key = index == -1 ? path : path.substring(0, index);
        boolean added = false;
        IEclipsePreferences child = this.getChild(key, context, true);
        if (child == null) {
            child = this.create(this, key, context);
            added = true;
        }
        if (added && notify) {
            this.fireNodeEvent(new IEclipsePreferences.NodeChangeEvent(this, child), true);
        }
        return (IEclipsePreferences)child.node(index == -1 ? EMPTY_STRING : path.substring(index + 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String internalPut(String key, String newValue) {
        Object object = this.childAndPropertyLock;
        synchronized (object) {
            this.checkRemoved();
            String oldValue = this.properties.get(key);
            if (oldValue != null && oldValue.equals(newValue)) {
                return oldValue;
            }
            if (DEBUG_PREFERENCE_SET) {
                PrefsMessages.message("Setting preference: " + this.absolutePath() + "/" + key + "=" + newValue);
            }
            this.properties = this.properties.put(key.intern(), newValue.intern());
            return oldValue;
        }
    }

    protected boolean isAlreadyLoaded(IEclipsePreferences node) {
        return this.descriptor == null ? true : this.descriptor.isAlreadyLoaded(node.absolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] keys() {
        Object object = this.childAndPropertyLock;
        synchronized (object) {
            this.checkRemoved();
            return this.properties.keys();
        }
    }

    protected void load() throws BackingStoreException {
        if (this.descriptor == null) {
            this.load(this.getLocation());
        } else {
            Properties props = this.descriptor.load(this.absolutePath());
            if (props == null || props.isEmpty()) {
                return;
            }
            EclipsePreferences.convertFromProperties(this, props, false);
        }
    }

    protected static Properties loadProperties(IPath location) throws BackingStoreException {
        if (DEBUG_PREFERENCE_GENERAL) {
            PrefsMessages.message("Loading preferences from file: " + String.valueOf(location));
        }
        Properties result = new Properties();
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try (InputStream input = EclipsePreferences.getSaveInputStream(location);){
                result.load(input);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            if (DEBUG_PREFERENCE_GENERAL) {
                PrefsMessages.message("Preference file does not exist: " + String.valueOf(location));
            }
        }
        catch (IOException | IllegalArgumentException e) {
            String message = NLS.bind((String)PrefsMessages.preferences_loadException, (Object)location);
            EclipsePreferences.log((IStatus)new Status(1, "org.eclipse.equinox.preferences", 1, message, (Throwable)e));
            throw new BackingStoreException(message, (Throwable)e);
        }
        return result;
    }

    private static InputStream getSaveInputStream(IPath location) throws IOException {
        File target = location.toFile().getAbsoluteFile();
        if (!target.exists()) {
            target = new File(String.valueOf(target) + BACKUP_FILE_EXTENSION);
        }
        return new FileInputStream(target);
    }

    protected void load(IPath location) throws BackingStoreException {
        if (location == null) {
            if (DEBUG_PREFERENCE_GENERAL) {
                PrefsMessages.message("Unable to determine location of preference file for node: " + this.absolutePath());
            }
            return;
        }
        Properties fromDisk = EclipsePreferences.loadProperties(location);
        EclipsePreferences.convertFromProperties(this, fromDisk, false);
    }

    protected void loaded() {
        if (this.descriptor != null) {
            this.descriptor.loaded(this.absolutePath());
        }
    }

    public static void log(IStatus status) {
        RuntimeLog.log((IStatus)status);
    }

    protected void makeDirty() {
        EclipsePreferences node = this;
        while (node != null && !node.removed) {
            node.dirty = true;
            node = (EclipsePreferences)node.parent();
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public String name() {
        return this.name;
    }

    @Override
    public Preferences node(String pathName) {
        return this.internalNode(pathName, true, null);
    }

    protected void fireNodeEvent(IEclipsePreferences.NodeChangeEvent event, boolean added) {
        for (IEclipsePreferences.INodeChangeListener listener : this.nodeChangeListeners) {
            SafeRunner.run(() -> {
                if (added) {
                    listener.added(event);
                } else {
                    listener.removed(event);
                }
            });
        }
    }

    public boolean nodeExists(String path) throws BackingStoreException {
        boolean noSlash;
        if (path.isEmpty()) {
            return !this.removed;
        }
        this.checkRemoved();
        if (path.charAt(0) == '/') {
            return this.calculateRoot().nodeExists(path.substring(1));
        }
        int index = path.indexOf(47);
        boolean bl = noSlash = index == -1;
        if (noSlash) {
            return this.childExists(path);
        }
        String childName = path.substring(0, index);
        if (!this.childExists(childName)) {
            return false;
        }
        IEclipsePreferences child = this.getChild(childName, null, true);
        if (child == null) {
            return false;
        }
        return child.nodeExists(path.substring(index + 1));
    }

    public Preferences parent() {
        this.checkRemoved();
        return this.parent;
    }

    protected void firePreferenceEvent(String key, Object oldValue, Object newValue) {
        IEclipsePreferences.PreferenceChangeEvent event = new IEclipsePreferences.PreferenceChangeEvent(this, key, oldValue, newValue);
        for (IEclipsePreferences.IPreferenceChangeListener listener : this.preferenceChangeListeners) {
            SafeRunner.run(() -> listener.preferenceChange(event));
        }
    }

    public void put(String key, String newValue) {
        if (key == null || newValue == null) {
            throw new NullPointerException();
        }
        String oldValue = this.internalPut(key, newValue);
        if (!newValue.equals(oldValue)) {
            this.makeDirty();
            this.firePreferenceEvent(key, oldValue, newValue);
        }
    }

    public void putBoolean(String key, boolean value) {
        this.put(key, value ? TRUE : FALSE);
    }

    public void putByteArray(String key, byte[] value) {
        this.put(key, new String(Base64.encode(value)));
    }

    public void putDouble(String key, double value) {
        this.put(key, Double.toString(value));
    }

    public void putFloat(String key, float value) {
        this.put(key, Float.toString(value));
    }

    public void putInt(String key, int value) {
        this.put(key, Integer.toString(value));
    }

    public void putLong(String key, long value) {
        this.put(key, Long.toString(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String key) {
        String oldValue;
        Object object = this.childAndPropertyLock;
        synchronized (object) {
            this.checkRemoved();
            oldValue = this.properties.get(key);
            if (oldValue == null) {
                return;
            }
            this.properties = this.properties.removeKey(key);
        }
        this.makeDirty();
        this.firePreferenceEvent(key, oldValue, null);
    }

    @Override
    public void removeNode() throws BackingStoreException {
        String[] keys;
        this.checkRemoved();
        String[] stringArray = keys = this.keys();
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            this.remove(key);
            ++n2;
        }
        if (this.parent != null && !(this.parent instanceof RootPreferences)) {
            this.removed = true;
            this.parent.removeNode(this);
        }
        for (IEclipsePreferences childNode : this.getChildren(false)) {
            try {
                childNode.removeNode();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    protected void removeNode(IEclipsePreferences child) {
        if (this.removeNode(child.name()) != null) {
            this.fireNodeEvent(new IEclipsePreferences.NodeChangeEvent(this, child), false);
            if (this.descriptor != null) {
                this.descriptor.removed(child.absolutePath());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object removeNode(String key) {
        Object object = this.childAndPropertyLock;
        synchronized (object) {
            if (this.children != null) {
                Object result = this.children.remove(key);
                if (result != null) {
                    this.makeDirty();
                }
                if (this.children.isEmpty()) {
                    this.children = null;
                }
                return result;
            }
        }
        return null;
    }

    @Override
    public void removeNodeChangeListener(IEclipsePreferences.INodeChangeListener listener) {
        this.checkRemoved();
        this.nodeChangeListeners.remove((Object)listener);
        if (DEBUG_PREFERENCE_GENERAL) {
            PrefsMessages.message("Removed preference node change listener: " + String.valueOf(listener) + " from: " + this.absolutePath());
        }
    }

    @Override
    public void removePreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener listener) {
        this.checkRemoved();
        this.preferenceChangeListeners.remove((Object)listener);
        if (DEBUG_PREFERENCE_GENERAL) {
            PrefsMessages.message("Removed preference property change listener: " + String.valueOf(listener) + " from: " + this.absolutePath());
        }
    }

    protected void save() throws BackingStoreException {
        if (this.descriptor == null) {
            this.save(this.getLocation());
        } else {
            this.descriptor.save(this.absolutePath(), this.convertToProperties(new Properties(), EMPTY_STRING));
        }
    }

    protected void save(IPath location) throws BackingStoreException {
        Properties table;
        if (location == null) {
            if (DEBUG_PREFERENCE_GENERAL) {
                PrefsMessages.message("Unable to determine location of preference file for node: " + this.absolutePath());
            }
            return;
        }
        if (DEBUG_PREFERENCE_GENERAL) {
            PrefsMessages.message("Saving preferences to file: " + String.valueOf(location));
        }
        if ((table = this.convertToProperties(new SortedProperties(), EMPTY_STRING)).isEmpty()) {
            if (location.toFile().exists() && !location.toFile().delete()) {
                String message = NLS.bind((String)PrefsMessages.preferences_failedDelete, (Object)location);
                EclipsePreferences.log(Status.warning((String)message));
            }
            return;
        }
        table.put(VERSION_KEY, VERSION_VALUE);
        this.write(table, location);
    }

    public static String encodePath(String path, String key) {
        int pathLength;
        int n = pathLength = path == null ? 0 : path.length();
        if (key.indexOf(47) == -1) {
            if (pathLength == 0) {
                return key;
            }
            return path + "/" + key;
        }
        if (pathLength == 0) {
            return DOUBLE_SLASH + key;
        }
        return path + DOUBLE_SLASH + key;
    }

    public static String getSegment(String path, int segment) {
        int start = path.indexOf(47) == 0 ? 1 : 0;
        int end = path.indexOf(47, start);
        if (end == path.length() - 1) {
            end = -1;
        }
        int i = 0;
        while (i < segment) {
            if (end == -1) {
                return null;
            }
            start = end + 1;
            end = path.indexOf(47, start);
            ++i;
        }
        if (end == -1) {
            end = path.length();
        }
        return path.substring(start, end);
    }

    public static int getSegmentCount(String path) {
        StringTokenizer tokenizer = new StringTokenizer(path, String.valueOf('/'));
        return tokenizer.countTokens();
    }

    public static String makeRelative(String path) {
        if (path == null) {
            return EMPTY_STRING;
        }
        if (path.length() > 0 && path.charAt(0) == '/') {
            return path.substring(1);
        }
        return path;
    }

    public static String[] decodePath(String fullPath) {
        String key;
        String path = null;
        int index = fullPath.indexOf(DOUBLE_SLASH);
        if (index == -1) {
            int lastIndex = fullPath.lastIndexOf(47);
            if (lastIndex == -1) {
                key = fullPath;
            } else {
                path = fullPath.substring(0, lastIndex);
                key = fullPath.substring(lastIndex + 1);
            }
        } else {
            path = fullPath.substring(0, index);
            key = fullPath.substring(index + 2);
        }
        if (path != null) {
            if (path.isEmpty()) {
                path = null;
            } else if (path.charAt(0) == '/') {
                path = path.substring(1);
            }
        }
        return new String[]{path, key};
    }

    public void sync() throws BackingStoreException {
        this.checkRemoved();
        IEclipsePreferences node = this.getLoadLevel();
        if (node == null) {
            if (DEBUG_PREFERENCE_GENERAL) {
                PrefsMessages.message("Preference node is not a load root: " + this.absolutePath());
            }
            return;
        }
        if (node instanceof EclipsePreferences) {
            EclipsePreferences eclipsePreferences = (EclipsePreferences)node;
            eclipsePreferences.load();
            node.flush();
        }
    }

    public String toDeepDebugString() {
        StringBuilder buffer = new StringBuilder();
        try {
            this.accept(node -> {
                buffer.append(node).append('\n');
                String[] stringArray = node.keys();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String key = stringArray[n2];
                    buffer.append(node.absolutePath()).append(PATH_SEPARATOR);
                    buffer.append(key).append('=').append(node.get(key, "*default*")).append('\n');
                    ++n2;
                }
                return true;
            });
        }
        catch (BackingStoreException e) {
            System.out.println("Exception while calling #toDeepDebugString()");
            e.printStackTrace();
        }
        return buffer.toString();
    }

    public String toString() {
        return this.absolutePath();
    }

    void setDescriptor(ScopeDescriptor descriptor) {
        this.descriptor = descriptor;
    }
}

