/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.installer;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.edit.provider.IItemFontProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedFontRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.oomph.setup.internal.installer.SetupInstallerPlugin;
import org.eclipse.oomph.setup.internal.installer.URISchemeUtil;
import org.eclipse.oomph.setup.ui.AbstractSetupDialog;
import org.eclipse.oomph.ui.OomphUIPlugin;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URISchemeDialog
extends AbstractSetupDialog {
    public static final String TITLE = "Web Links Activation";
    public static final String DESCRIPTION = "Select the schemes to activate";
    private static final int APPLY_ID = 1025;
    private Map<String, String> registrations = new LinkedHashMap<String, String>();
    private CheckboxTableViewer registrationViewer;
    private Button applyButton;

    public URISchemeDialog(Shell parentShell) {
        super(parentShell, TITLE, 800, 300, (OomphUIPlugin)SetupInstallerPlugin.INSTANCE, false);
        this.registrations.putAll(URISchemeUtil.getRegistrations());
    }

    protected String getShellText() {
        return TITLE;
    }

    protected String getDefaultMessage() {
        if (!URISchemeUtil.getConflictingRegistrations().isEmpty()) {
            return "Select the schemes to activate. Each bold entry will replace another application's registration.";
        }
        return "Select the schemes to activate.";
    }

    protected void createUI(Composite parent) {
        TableColumnLayout tableLayout = new TableColumnLayout();
        parent.setLayout((Layout)tableLayout);
        this.registrationViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)0);
        final Table registrationTable = this.registrationViewer.getTable();
        registrationTable.setLinesVisible(true);
        registrationTable.setHeaderVisible(true);
        registrationTable.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.registrationViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return URISchemeDialog.this.registrations.entrySet().toArray();
            }
        });
        TableViewerColumn schemeColumn = new TableViewerColumn((TableViewer)this.registrationViewer, 0);
        schemeColumn.getColumn().setText("Scheme");
        tableLayout.setColumnData((Widget)schemeColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(30, true));
        schemeColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((Map.Entry)element).getKey().toString();
            }
        });
        TableViewerColumn launcherColumn = new TableViewerColumn((TableViewer)this.registrationViewer, 0);
        launcherColumn.getColumn().setText("Application");
        tableLayout.setColumnData((Widget)launcherColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(70, true));
        launcherColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((Map.Entry)element).getValue().toString();
            }

            public Font getFont(Object element) {
                boolean isConflict = URISchemeUtil.getConflictingRegistrations().containsKey(((Map.Entry)element).getKey());
                return isConflict ? ExtendedFontRegistry.INSTANCE.getFont(registrationTable.getFont(), (Object)IItemFontProvider.BOLD_FONT) : null;
            }
        });
        this.registrationViewer.setInput(this.registrations);
        this.registrationViewer.setCheckedElements(this.getCurrentSelfRegistrations().entrySet().toArray());
        this.registrationViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                URISchemeDialog.this.updateEnablement();
            }
        });
    }

    protected Map<String, String> getCurrentSelfRegistrations() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        String selfLauncher = URISchemeUtil.getSelfLauncher();
        Set<String> selfRegistrations = URISchemeUtil.getSelfRegistrations();
        for (String scheme : selfRegistrations) {
            result.put(scheme, selfLauncher);
        }
        return result;
    }

    protected void updateEnablement() {
        boolean selectionChanged;
        HashSet<Object> checkedElements = new HashSet<Object>(Arrays.asList(this.registrationViewer.getCheckedElements()));
        boolean applyEnabled = selectionChanged = !checkedElements.equals(this.getCurrentSelfRegistrations().entrySet());
        this.applyButton.setEnabled(applyEnabled);
        this.applyButton.setText("Apply");
        Map<String, String> currentRegistrations = URISchemeUtil.getRegistrations();
        String selfLauncher = URISchemeUtil.getSelfLauncher();
        for (Map.Entry<String, String> entry : this.registrations.entrySet()) {
            if (checkedElements.contains(entry)) {
                entry.setValue(selfLauncher);
                continue;
            }
            entry.setValue(currentRegistrations.get(entry.getKey()));
        }
        this.registrationViewer.refresh();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.applyButton = this.createButton(parent, 1025, "Apply", false);
        this.applyButton.setEnabled(false);
        super.createButtonsForButtonBar(parent);
        this.updateEnablement();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1025 || buttonId == 0) {
            LinkedHashMap<String, String> newRegistrations = new LinkedHashMap<String, String>(this.registrations);
            HashSet<Object> checkedElements = new HashSet<Object>(Arrays.asList(this.registrationViewer.getCheckedElements()));
            String selfLauncher = URISchemeUtil.getSelfLauncher();
            for (Map.Entry entry : newRegistrations.entrySet()) {
                if (checkedElements.contains(entry) || !((String)entry.getValue()).equals(selfLauncher)) continue;
                entry.setValue("");
            }
            URISchemeUtil.setRegistrations(newRegistrations);
        }
        super.buttonPressed(buttonId);
    }
}

