/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.cdatetime;

import java.util.Calendar;
import java.util.Date;
import org.eclipse.nebula.cwt.v.IControlPainter;
import org.eclipse.nebula.cwt.v.VButton;
import org.eclipse.nebula.cwt.v.VButtonPainter;
import org.eclipse.nebula.cwt.v.VControl;
import org.eclipse.nebula.cwt.v.VLabelPainter;
import org.eclipse.nebula.cwt.v.VPanel;
import org.eclipse.nebula.cwt.v.VPanelPainter;
import org.eclipse.nebula.widgets.cdatetime.CDT;
import org.eclipse.nebula.widgets.cdatetime.CDateTime;
import org.eclipse.nebula.widgets.cdatetime.DatePicker;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;

public class CDateTimePainter
implements IControlPainter {
    protected CDateTime cdt;
    protected IControlPainter buttonPainter = new VButtonPainter();
    protected IControlPainter labelPainter = new VLabelPainter();
    protected IControlPainter panelPainter = new VPanelPainter();

    private void defaultPaintBackground(VControl control, Event e) {
        switch (control.getType()) {
            case Button: {
                this.buttonPainter.paintBackground(control, e);
                break;
            }
            case Label: {
                this.labelPainter.paintBackground(control, e);
                break;
            }
            case Panel: {
                this.panelPainter.paintBackground(control, e);
            }
        }
    }

    private void defaultPaintBorders(VControl control, Event e) {
        switch (control.getType()) {
            case Button: {
                this.buttonPainter.paintBorders(control, e);
                break;
            }
            case Label: {
                this.labelPainter.paintBorders(control, e);
                break;
            }
            case Panel: {
                this.panelPainter.paintBorders(control, e);
            }
        }
    }

    private void defaultPaintContent(VControl control, Event e) {
        switch (control.getType()) {
            case Button: {
                this.buttonPainter.paintContent(control, e);
                break;
            }
            case Label: {
                this.labelPainter.paintContent(control, e);
                break;
            }
            case Panel: {
                this.panelPainter.paintContent(control, e);
            }
        }
    }

    public void dispose() {
        this.buttonPainter.dispose();
        this.labelPainter.dispose();
        this.panelPainter.dispose();
    }

    protected VPanel getPicker() {
        return this.cdt.picker;
    }

    protected final int indexOf(VControl control) {
        Object obj = control.getData((Enum)CDT.Key.Index);
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        return -1;
    }

    protected final boolean isActive(VControl control) {
        Object obj = control.getData((Enum)CDT.Key.Active);
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        return false;
    }

    protected final boolean isToday(VControl control) {
        Object obj = control.getData((Enum)CDT.Key.Today);
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        return false;
    }

    public final void paintBackground(VControl control, Event e) {
        switch ((CDT.PickerPart)((Object)control.getData("PickerPart"))) {
            case ClearButton: {
                this.paintClearButtonBackground(control, e);
                break;
            }
            case DateNow: {
                this.paintDateNowBackground(control, e);
                break;
            }
            case DayButton: {
                this.paintDayButtonBackground(control, e);
                break;
            }
            case DayOfWeekLabel: {
                this.paintDayOfWeekLabelBackground(control, e);
                break;
            }
            case DayOfWeekPanel: {
                this.paintDayOfWeekPanelBackground(control, e);
                break;
            }
            case DayPanel: {
                this.paintDayPanelBackground(control, e);
                break;
            }
            case TodayButton: {
                this.paintFooterButtonBackground(control, e);
                break;
            }
            case FooterPanel: {
                this.paintFooterPanelBackground(control, e);
                break;
            }
            case HeaderPanel: {
                this.paintHeaderPanelBackground(control, e);
                break;
            }
            case MonthLabel: {
                this.paintMonthLabelBackground(control, e);
                break;
            }
            case MonthNext: {
                this.paintMonthNextBackground(control, e);
                break;
            }
            case MonthPrev: {
                this.paintMonthPrevBackground(control, e);
                break;
            }
            case YearLabel: {
                this.paintYearLabelBackground(control, e);
                break;
            }
            case YearNext: {
                this.paintYearNextBackground(control, e);
                break;
            }
            case YearPrev: {
                this.paintYearPrevBackground(control, e);
                break;
            }
            default: {
                this.defaultPaintBackground(control, e);
            }
        }
    }

    public final void paintBorders(VControl control, Event e) {
        switch ((CDT.PickerPart)((Object)control.getData("PickerPart"))) {
            case ClearButton: {
                this.paintClearButtonBorders(control, e);
                break;
            }
            case DateNow: {
                this.paintDateNowBorders(control, e);
                break;
            }
            case DayButton: {
                this.paintDayButtonBorders(control, e);
                break;
            }
            case DayOfWeekLabel: {
                this.paintDayOfWeekLabelBorders(control, e);
                break;
            }
            case DayOfWeekPanel: {
                this.paintDayOfWeekPanelBorders(control, e);
                break;
            }
            case DayPanel: {
                this.paintDayPanelBorders(control, e);
                break;
            }
            case TodayButton: {
                this.paintFooterButtonBorders(control, e);
                break;
            }
            case FooterPanel: {
                this.paintFooterPanelBorders(control, e);
                break;
            }
            case HeaderPanel: {
                this.paintHeaderPanelBorders(control, e);
                break;
            }
            case MonthLabel: {
                this.paintMonthLabelBorders(control, e);
                break;
            }
            case MonthNext: {
                this.paintMonthNextBorders(control, e);
                break;
            }
            case MonthPrev: {
                this.paintMonthPrevBorders(control, e);
                break;
            }
            case YearLabel: {
                this.paintYearLabelBorders(control, e);
                break;
            }
            case YearNext: {
                this.paintYearNextBorders(control, e);
                break;
            }
            case YearPrev: {
                this.paintYearPrevBorders(control, e);
                break;
            }
            default: {
                this.defaultPaintBorders(control, e);
            }
        }
    }

    protected void paintClearButtonBackground(VControl control, Event e) {
        this.defaultPaintBackground(control, e);
    }

    protected void paintClearButtonBorders(VControl control, Event e) {
        this.defaultPaintBorders(control, e);
    }

    protected void paintClearButtonContent(VControl control, Event e) {
        this.defaultPaintContent(control, e);
    }

    public final void paintContent(VControl control, Event e) {
        switch ((CDT.PickerPart)((Object)control.getData("PickerPart"))) {
            case ClearButton: {
                this.paintClearButtonContent(control, e);
                break;
            }
            case DateNow: {
                this.paintDateNowContent(control, e);
                break;
            }
            case DayButton: {
                this.paintDayButtonContent(control, e);
                break;
            }
            case DayOfWeekLabel: {
                this.paintDayOfWeekLabelContent(control, e);
                break;
            }
            case DayOfWeekPanel: {
                this.paintDayOfWeekPanelContent(control, e);
                break;
            }
            case DayPanel: {
                this.paintDayPanelContent(control, e);
                break;
            }
            case TodayButton: {
                this.paintFooterButtonContent(control, e);
                break;
            }
            case FooterPanel: {
                this.paintFooterPanelContent(control, e);
                break;
            }
            case HeaderPanel: {
                this.paintHeaderPanelContent(control, e);
                break;
            }
            case MonthLabel: {
                this.paintMonthLabelContent(control, e);
                break;
            }
            case MonthNext: {
                this.paintMonthNextContent(control, e);
                break;
            }
            case MonthPrev: {
                this.paintMonthPrevContent(control, e);
                break;
            }
            case YearLabel: {
                this.paintYearLabelContent(control, e);
                break;
            }
            case YearNext: {
                this.paintYearNextContent(control, e);
                break;
            }
            case YearPrev: {
                this.paintYearPrevContent(control, e);
                break;
            }
            default: {
                this.defaultPaintContent(control, e);
            }
        }
    }

    protected void paintDateNowBackground(VControl control, Event e) {
        this.defaultPaintBackground(control, e);
    }

    protected void paintDateNowBorders(VControl control, Event e) {
        this.defaultPaintBorders(control, e);
    }

    protected void paintDateNowContent(VControl control, Event e) {
        this.defaultPaintContent(control, e);
    }

    protected void paintDayButtonBackground(VControl control, Event e) {
        this.defaultPaintBackground(control, e);
    }

    protected void paintDayButtonBorders(VControl control, Event e) {
        this.defaultPaintBorders(control, e);
    }

    protected void paintDayButtonContent(VControl control, Event e) {
        this.defaultPaintContent(control, e);
    }

    protected void paintDayOfWeekLabelBackground(VControl control, Event e) {
        this.defaultPaintBackground(control, e);
    }

    protected void paintDayOfWeekLabelBorders(VControl control, Event e) {
        this.defaultPaintBorders(control, e);
    }

    protected void paintDayOfWeekLabelContent(VControl control, Event e) {
        this.defaultPaintContent(control, e);
    }

    protected void paintDayOfWeekPanelBackground(VControl control, Event e) {
        this.defaultPaintBackground(control, e);
    }

    protected void paintDayOfWeekPanelBorders(VControl control, Event e) {
        this.defaultPaintBorders(control, e);
    }

    protected void paintDayOfWeekPanelContent(VControl control, Event e) {
        this.defaultPaintContent(control, e);
    }

    protected void paintDayPanelBackground(VControl control, Event e) {
        this.defaultPaintBackground(control, e);
    }

    protected void paintDayPanelBorders(VControl control, Event e) {
        this.defaultPaintBorders(control, e);
        Calendar cal = this.cdt.getCalendarInstance();
        VPanel picker = this.getPicker();
        if (picker instanceof DatePicker) {
            VButton[] days = ((DatePicker)picker).dayButtons;
            int i = 1;
            while (i < days.length) {
                VButton day = days[i];
                cal.setTime((Date)day.getData((Enum)CDT.Key.Date, Date.class));
                if (cal.get(5) == 1 && !this.isActive((VControl)day) && !this.isActive((VControl)days[i - 1])) {
                    Rectangle bounds = day.getBounds();
                    Rectangle pbounds = control.getBounds();
                    if (this.indexOf((VControl)day) % 7 != 0) {
                        e.gc.drawLine(bounds.x, bounds.y, bounds.x, bounds.y + bounds.height);
                    }
                    if (this.indexOf((VControl)day) > 7) {
                        e.gc.drawLine(bounds.x, bounds.y, pbounds.x + pbounds.width, bounds.y);
                    }
                    e.gc.drawLine(pbounds.x, bounds.y + bounds.height, bounds.x, bounds.y + bounds.height);
                    i += 28;
                }
                ++i;
            }
        }
    }

    protected void paintDayPanelContent(VControl control, Event e) {
        this.defaultPaintContent(control, e);
    }

    protected void paintFooterButtonBackground(VControl control, Event e) {
        this.defaultPaintBackground(control, e);
    }

    protected void paintFooterButtonBorders(VControl control, Event e) {
        this.defaultPaintBorders(control, e);
    }

    protected void paintFooterButtonContent(VControl control, Event e) {
        this.defaultPaintContent(control, e);
    }

    protected void paintFooterPanelBackground(VControl control, Event e) {
        this.defaultPaintBackground(control, e);
    }

    protected void paintFooterPanelBorders(VControl control, Event e) {
        this.defaultPaintBorders(control, e);
    }

    protected void paintFooterPanelContent(VControl control, Event e) {
        this.defaultPaintContent(control, e);
    }

    protected void paintHeaderPanelBackground(VControl control, Event e) {
        this.defaultPaintBackground(control, e);
    }

    protected void paintHeaderPanelBorders(VControl control, Event e) {
        this.defaultPaintBorders(control, e);
    }

    protected void paintHeaderPanelContent(VControl control, Event e) {
        this.defaultPaintContent(control, e);
    }

    protected void paintMonthLabelBackground(VControl control, Event e) {
        this.defaultPaintBackground(control, e);
    }

    protected void paintMonthLabelBorders(VControl control, Event e) {
        this.defaultPaintBorders(control, e);
    }

    protected void paintMonthLabelContent(VControl control, Event e) {
        this.defaultPaintContent(control, e);
    }

    protected void paintMonthNextBackground(VControl control, Event e) {
        this.defaultPaintBackground(control, e);
    }

    protected void paintMonthNextBorders(VControl control, Event e) {
        this.defaultPaintBorders(control, e);
    }

    protected void paintMonthNextContent(VControl control, Event e) {
        this.defaultPaintContent(control, e);
    }

    protected void paintMonthPrevBackground(VControl control, Event e) {
        this.defaultPaintBackground(control, e);
    }

    protected void paintMonthPrevBorders(VControl control, Event e) {
        this.defaultPaintBorders(control, e);
    }

    protected void paintMonthPrevContent(VControl control, Event e) {
        this.defaultPaintContent(control, e);
    }

    protected void paintYearLabelBackground(VControl control, Event e) {
        this.defaultPaintBackground(control, e);
    }

    protected void paintYearLabelBorders(VControl control, Event e) {
        this.defaultPaintBorders(control, e);
    }

    protected void paintYearLabelContent(VControl control, Event e) {
        this.defaultPaintContent(control, e);
    }

    protected void paintYearNextBackground(VControl control, Event e) {
        this.defaultPaintBackground(control, e);
    }

    protected void paintYearNextBorders(VControl control, Event e) {
        this.defaultPaintBorders(control, e);
    }

    protected void paintYearNextContent(VControl control, Event e) {
        this.defaultPaintContent(control, e);
    }

    protected void paintYearPrevBackground(VControl control, Event e) {
        this.defaultPaintBackground(control, e);
    }

    protected void paintYearPrevBorders(VControl control, Event e) {
        this.defaultPaintBorders(control, e);
    }

    protected void paintYearPrevContent(VControl control, Event e) {
        this.defaultPaintContent(control, e);
    }

    public final void setButtonPainter(IControlPainter painter) {
        this.buttonPainter = painter;
    }

    void setCDateTime(CDateTime cdt) {
        this.cdt = cdt;
    }

    public final void setLabelPainter(IControlPainter painter) {
        this.labelPainter = painter;
    }

    public final void update(VControl control) {
        if (control == null) {
            return;
        }
        switch ((CDT.PickerPart)((Object)control.getData("PickerPart"))) {
            case ClearButton: {
                this.updateClearButton(control);
                break;
            }
            case DateNow: {
                this.updateDateNow(control);
                break;
            }
            case DayButton: {
                this.updateDayButton(control);
                break;
            }
            case DayOfWeekLabel: {
                this.updateDayOfWeekLabel(control);
                break;
            }
            case DayOfWeekPanel: {
                this.updateDayOfWeekPanel(control);
                break;
            }
            case DayPanel: {
                this.updateDayPanel(control);
                break;
            }
            case TodayButton: {
                this.updateFooterButton(control);
                break;
            }
            case FooterPanel: {
                this.updateFooterPanel(control);
                break;
            }
            case HeaderPanel: {
                this.updateHeaderPanel(control);
                break;
            }
            case MonthLabel: {
                this.updateMonthLabel(control);
                break;
            }
            case MonthNext: {
                this.updateMonthNext(control);
                break;
            }
            case MonthPrev: {
                this.updateMonthPrev(control);
                break;
            }
            case YearLabel: {
                this.updateYearLabel(control);
                break;
            }
            case YearNext: {
                this.updateYearNext(control);
                break;
            }
            case YearPrev: {
                this.updateYearPrev(control);
            }
        }
    }

    protected void updateClearButton(VControl control) {
    }

    protected void updateDateNow(VControl control) {
        control.setFill(control.getDisplay().getSystemColor(15));
    }

    protected void updateDayButton(VControl control) {
        if (this.isToday(control)) {
            Color color = this.cdt.getPickerTodayColor();
            control.setForeground(color != null ? color : control.getDisplay().getSystemColor(3));
        } else if (this.isActive(control)) {
            Color color = this.cdt.getPickerForegroundColor();
            control.setForeground(color != null ? color : control.getDisplay().getSystemColor(2));
        } else {
            Color color = this.cdt.getPickerInactiveDayColor();
            control.setForeground(color != null ? color : control.getDisplay().getSystemColor(16));
        }
    }

    protected void updateDayOfWeekLabel(VControl control) {
    }

    protected void updateDayOfWeekPanel(VControl control) {
        Color color = this.cdt.getPickerBackgroundColor();
        control.setBackground(color != null ? color : control.getDisplay().getSystemColor(1));
    }

    protected void updateDayPanel(VControl control) {
        Color color = this.cdt.getPickerBackgroundColor();
        control.setBackground(color != null ? color : control.getDisplay().getSystemColor(1));
    }

    protected void updateFooterButton(VControl control) {
    }

    protected void updateFooterPanel(VControl control) {
    }

    protected void updateHeaderPanel(VControl control) {
    }

    protected void updateMonthLabel(VControl control) {
    }

    protected void updateMonthNext(VControl control) {
        control.setFill(control.getDisplay().getSystemColor(15));
    }

    protected void updateMonthPrev(VControl control) {
        control.setFill(control.getDisplay().getSystemColor(15));
    }

    protected void updateYearLabel(VControl control) {
    }

    protected void updateYearNext(VControl control) {
        control.setFill(control.getDisplay().getSystemColor(15));
    }

    protected void updateYearPrev(VControl control) {
        control.setFill(control.getDisplay().getSystemColor(15));
    }
}

