/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.core;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.sat4j.specs.ISolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ASolverFactory<T extends ISolver>
implements Serializable {
    private static final long serialVersionUID = 1L;

    public String[] solverNames() {
        Method[] solvers;
        ArrayList<String> l = new ArrayList<String>();
        Method[] methodArray = solvers = this.getClass().getDeclaredMethods();
        int n = solvers.length;
        int n2 = 0;
        while (n2 < n) {
            Method solver = methodArray[n2];
            if (solver.getParameterTypes().length == 0 && solver.getName().startsWith("new")) {
                l.add(solver.getName().substring(3));
            }
            ++n2;
        }
        String[] names = new String[l.size()];
        l.toArray(names);
        return names;
    }

    public T createSolverByName(String solvername) {
        try {
            Class[] paramtypes = new Class[]{};
            Method m = this.getClass().getMethod("new" + solvername, paramtypes);
            return (T)((ISolver)m.invoke(null, null));
        }
        catch (SecurityException e) {
            System.err.println(e.getLocalizedMessage());
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.getLocalizedMessage());
        }
        catch (NoSuchMethodException e) {
            System.err.println(e.getLocalizedMessage());
        }
        catch (IllegalAccessException e) {
            System.err.println(e.getLocalizedMessage());
        }
        catch (InvocationTargetException e) {
            System.err.println(e.getLocalizedMessage());
        }
        return null;
    }

    public abstract T defaultSolver();

    public abstract T lightSolver();
}

