/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench;

import jakarta.inject.Inject;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.PartServiceImpl;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.IPartListener;

public class ApplicationPartServiceImpl
implements EPartService {
    private static final Supplier<RuntimeException> NO_VALID_PARTSERVICE = () -> new IllegalStateException("No valid PartService can be aquired from the current context");
    private MApplication application;
    private EModelService modelService;

    @Inject
    ApplicationPartServiceImpl(MApplication application, EModelService modelService) {
        this.application = application;
        this.modelService = modelService;
    }

    private Optional<EPartService> getActiveWindowService() {
        IEclipseContext activeWindowContext = this.application.getContext().getActiveChild();
        if (activeWindowContext == null) {
            throw new IllegalStateException("Application does not have an active window");
        }
        EPartService activeWindowPartService = (EPartService)activeWindowContext.get(EPartService.class);
        if (activeWindowPartService == null) {
            throw new IllegalStateException("Active window context is invalid");
        }
        if (activeWindowPartService == this) {
            return Optional.empty();
        }
        return Optional.of(activeWindowPartService);
    }

    private Optional<EPartService> getActiveWindowService(MPart part) {
        return this.getActiveWindowService().or(() -> {
            EPartService partService;
            IEclipseContext context = part.getContext();
            if (context != null && (partService = (EPartService)context.get(EPartService.class)) instanceof PartServiceImpl) {
                return Optional.of(partService);
            }
            return Optional.empty();
        });
    }

    @Override
    public void addPartListener(IPartListener listener) {
        throw new UnsupportedOperationException("Listeners should only be attached/removed from a window's part service");
    }

    @Override
    public void removePartListener(IPartListener listener) {
        throw new UnsupportedOperationException("Listeners should only be attached/removed from a window's part service");
    }

    @Override
    public boolean isPartOrPlaceholderInPerspective(String elementId, MPerspective perspective) {
        return this.getActiveWindowService().orElseThrow(NO_VALID_PARTSERVICE).isPartOrPlaceholderInPerspective(elementId, perspective);
    }

    @Override
    public void switchPerspective(MPerspective perspective) {
        this.getActiveWindowService().ifPresentOrElse(service -> service.switchPerspective(perspective), () -> this.switchPerspectiveInternal(perspective));
    }

    @Override
    public Optional<MPerspective> switchPerspective(String perspectiveId) {
        Objects.requireNonNull(perspectiveId);
        Optional<EPartService> windowService = this.getActiveWindowService();
        if (windowService.isPresent()) {
            return windowService.get().switchPerspective(perspectiveId);
        }
        List<MPerspective> result = this.modelService.findElements((MUIElement)this.application, perspectiveId, MPerspective.class, null);
        if (!result.isEmpty()) {
            MPerspective perspective = result.get(0);
            this.switchPerspectiveInternal(perspective);
            return Optional.of(perspective);
        }
        return Optional.empty();
    }

    private void switchPerspectiveInternal(MPerspective perspective) {
        perspective.getParent().setSelectedElement((MUIElement)perspective);
        UIEvents.publishEvent("org/eclipse/e4/ui/LifeCycle/perspSwitched", (MUIElement)perspective);
    }

    @Override
    public void activate(MPart part) {
        this.getActiveWindowService(part).orElseThrow(NO_VALID_PARTSERVICE).activate(part);
    }

    @Override
    public void activate(MPart part, boolean requiresFocus) {
        this.getActiveWindowService(part).orElseThrow(NO_VALID_PARTSERVICE).activate(part, requiresFocus);
    }

    @Override
    public void requestActivation() {
        this.getActiveWindowService().orElseThrow(NO_VALID_PARTSERVICE).requestActivation();
    }

    @Override
    public void bringToTop(MPart part) {
        this.getActiveWindowService(part).orElseThrow(NO_VALID_PARTSERVICE).bringToTop(part);
    }

    @Override
    public MPart findPart(String id) {
        return this.getActiveWindowService().orElseThrow(NO_VALID_PARTSERVICE).findPart(id);
    }

    @Override
    public Collection<MPart> getParts() {
        return this.getActiveWindowService().orElseThrow(NO_VALID_PARTSERVICE).getParts();
    }

    @Override
    public MPart getActivePart() {
        return this.getActiveWindowService().orElseThrow(NO_VALID_PARTSERVICE).getActivePart();
    }

    @Override
    public boolean isPartVisible(MPart part) {
        return this.getActiveWindowService(part).orElseThrow(NO_VALID_PARTSERVICE).isPartVisible(part);
    }

    @Override
    public MPart createPart(String id) {
        return this.getActiveWindowService().orElseThrow(NO_VALID_PARTSERVICE).createPart(id);
    }

    @Override
    public MPlaceholder createSharedPart(String id) {
        return this.getActiveWindowService().orElseThrow(NO_VALID_PARTSERVICE).createSharedPart(id);
    }

    @Override
    public MPlaceholder createSharedPart(String id, boolean force) {
        return this.getActiveWindowService().orElseThrow(NO_VALID_PARTSERVICE).createSharedPart(id, force);
    }

    @Override
    public MPart showPart(String id, EPartService.PartState partState) {
        return this.getActiveWindowService().orElseThrow(NO_VALID_PARTSERVICE).showPart(id, partState);
    }

    @Override
    public MPart showPart(MPart part, EPartService.PartState partState) {
        return this.getActiveWindowService(part).orElseThrow(NO_VALID_PARTSERVICE).showPart(part, partState);
    }

    @Override
    public void hidePart(MPart part) {
        this.getActiveWindowService(part).orElseThrow(NO_VALID_PARTSERVICE).hidePart(part);
    }

    @Override
    public void hidePart(MPart part, boolean force) {
        this.getActiveWindowService(part).orElseThrow(NO_VALID_PARTSERVICE).hidePart(part, force);
    }

    @Override
    public Collection<MPart> getDirtyParts() {
        return this.getActiveWindowService().orElseThrow(NO_VALID_PARTSERVICE).getDirtyParts();
    }

    @Override
    public boolean savePart(MPart part, boolean confirm) {
        return this.getActiveWindowService(part).orElseThrow(NO_VALID_PARTSERVICE).savePart(part, confirm);
    }

    @Override
    public boolean saveAll(boolean confirm) {
        return this.getActiveWindowService().orElseThrow(NO_VALID_PARTSERVICE).saveAll(confirm);
    }
}

