/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.internal.ui;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.NoSuchAlgorithmException;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.BinaryResourceImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.BasicInternalEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xml.namespace.XMLNamespacePackage;
import org.eclipse.emf.ecore.xml.type.XMLTypeFactory;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.oomph.base.util.BaseResourceFactoryImpl;
import org.eclipse.oomph.base.util.BaseResourceImpl;
import org.eclipse.oomph.internal.ui.OomphBinaryTransfer;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.dnd.URLTransfer;
import org.xml.sax.InputSource;

public abstract class OomphTransferDelegate {
    private static final List<OomphTransferDelegate> MODIFIABLE_DELEGATES = new ArrayList<OomphTransferDelegate>();
    public static final List<? extends OomphTransferDelegate> DELEGATES = Collections.unmodifiableList(MODIFIABLE_DELEGATES);
    protected static final List<? extends Transfer> TRANSFERS = OomphTransferDelegate.asTransfers(MODIFIABLE_DELEGATES);

    static {
        OomphTransferDelegate.register(new LocalTransferDelegate());
        OomphTransferDelegate.register(new LocalSelectionTransferDelegate());
        OomphTransferDelegate.register(new OomphBinaryTransferDelegate());
        OomphTransferDelegate.register(new FileTransferDelegate());
        OomphTransferDelegate.register(new URLTransferDelegate());
        OomphTransferDelegate.register(new TextTransferDelegate());
    }

    public static Transfer[] transfers() {
        return TRANSFERS.toArray(new Transfer[TRANSFERS.size()]);
    }

    public static List<? extends Transfer> asTransfers(final List<? extends OomphTransferDelegate> delegates) {
        return new AbstractSequentialList<Transfer>(){

            @Override
            public ListIterator<Transfer> listIterator(int index) {
                return new ListIterator<Transfer>(delegates, index){
                    ListIterator<? extends OomphTransferDelegate> delegate;
                    {
                        this.delegate = list.listIterator(n);
                    }

                    @Override
                    public boolean hasNext() {
                        return this.delegate.hasNext();
                    }

                    @Override
                    public Transfer next() {
                        return this.delegate.next().getTransfer();
                    }

                    @Override
                    public boolean hasPrevious() {
                        return this.delegate.hasPrevious();
                    }

                    @Override
                    public Transfer previous() {
                        return this.delegate.previous().getTransfer();
                    }

                    @Override
                    public int nextIndex() {
                        return this.delegate.nextIndex();
                    }

                    @Override
                    public int previousIndex() {
                        return this.delegate.previousIndex();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public void set(Transfer o) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public void add(Transfer o) {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return delegates.size();
            }
        };
    }

    private static void register(OomphTransferDelegate delegate, List<OomphTransferDelegate> delegates) {
        int priority = delegate.priority();
        ListIterator<OomphTransferDelegate> it = delegates.listIterator();
        while (it.hasNext()) {
            if (it.next().priority() <= priority) continue;
            it.add(delegate);
            return;
        }
        delegates.add(delegate);
    }

    public static void register(OomphTransferDelegate delegate) {
        OomphTransferDelegate.register(delegate, MODIFIABLE_DELEGATES);
    }

    public static OomphTransferDelegate getDelegate(Transfer transfer, Collection<? extends OomphTransferDelegate> delegates) {
        for (OomphTransferDelegate oomphTransferDelegate : delegates) {
            if (oomphTransferDelegate.getTransfer() != transfer) continue;
            return oomphTransferDelegate;
        }
        return null;
    }

    public static List<? extends OomphTransferDelegate> merge(Collection<? extends OomphTransferDelegate> delegates, Collection<? extends OomphTransferDelegate> overridingDelegates) {
        return OomphTransferDelegate.merge(delegates, overridingDelegates.toArray(new OomphTransferDelegate[overridingDelegates.size()]));
    }

    public static List<? extends OomphTransferDelegate> merge(Collection<? extends OomphTransferDelegate> delegates, OomphTransferDelegate ... overridingDelegates) {
        ArrayList<OomphTransferDelegate> result = new ArrayList<OomphTransferDelegate>();
        block0: for (OomphTransferDelegate oomphTransferDelegate : delegates) {
            Transfer transfer = oomphTransferDelegate.getTransfer();
            OomphTransferDelegate[] oomphTransferDelegateArray = overridingDelegates;
            int n = overridingDelegates.length;
            int n2 = 0;
            while (n2 < n) {
                OomphTransferDelegate overridingDelegate = oomphTransferDelegateArray[n2];
                if (overridingDelegate.getTransfer() == transfer) {
                    OomphTransferDelegate.register(overridingDelegate, result);
                    continue block0;
                }
                ++n2;
            }
            OomphTransferDelegate.register(oomphTransferDelegate, result);
        }
        OomphTransferDelegate[] oomphTransferDelegateArray = overridingDelegates;
        int n = overridingDelegates.length;
        int n3 = 0;
        while (n3 < n) {
            OomphTransferDelegate oomphTransferDelegate = oomphTransferDelegateArray[n3];
            if (!result.contains(oomphTransferDelegate)) {
                OomphTransferDelegate.register(oomphTransferDelegate, result);
            }
            ++n3;
        }
        return result;
    }

    public abstract Transfer getTransfer();

    public boolean isSupportedType(TransferData transferData) {
        return this.getTransfer().isSupportedType(transferData);
    }

    public TransferData[] getSupportedTypes() {
        return this.getTransfer().getSupportedTypes();
    }

    public abstract Collection<?> getData(EditingDomain var1, TransferData var2);

    public abstract Collection<?> getValue(EditingDomain var1, Object var2);

    public abstract boolean setSelection(EditingDomain var1, ISelection var2);

    public abstract Object getData();

    public abstract void clear();

    protected int priority() {
        return 0;
    }

    public String toString() {
        return super.toString() + " " + String.valueOf(Arrays.asList(this.getTransfer().getSupportedTypes()));
    }

    private static class EclipseHelper {
        private EclipseHelper() {
        }

        public static URI getURI(Object object) {
            if (object instanceof IResource) {
                IResource resource = (IResource)object;
                return URI.createPlatformResourceURI((String)resource.getFullPath().toString(), (boolean)true);
            }
            return null;
        }
    }

    public static class FileTransferDelegate
    extends OomphTransferDelegate {
        protected final FileTransfer fileTransfer = FileTransfer.getInstance();
        protected Set<String> files;

        @Override
        public Transfer getTransfer() {
            return this.fileTransfer;
        }

        @Override
        public Collection<?> getData(EditingDomain domain, TransferData transferData) {
            return this.getValue(domain, this.fileTransfer.nativeToJava(transferData));
        }

        @Override
        public Collection<?> getValue(EditingDomain domain, Object data) {
            if (data instanceof String[]) {
                ArrayList<URI> result = new ArrayList<URI>();
                String[] stringArray = (String[])data;
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String file = stringArray[n2];
                    result.add(URI.createFileURI((String)file));
                    ++n2;
                }
                return result;
            }
            return Collections.emptyList();
        }

        @Override
        public boolean setSelection(EditingDomain domain, ISelection selection) {
            this.files = new LinkedHashSet<String>();
            if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
                Object[] objectArray = ((IStructuredSelection)selection).toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    this.gather(domain, object);
                    ++n2;
                }
            }
            return !this.files.isEmpty();
        }

        protected void gather(EditingDomain domain, Object object) {
            Object unwrappedObject = AdapterFactoryEditingDomain.unwrap((Object)object);
            if (unwrappedObject instanceof Resource) {
                Resource resource = (Resource)unwrappedObject;
                this.gather(domain, resource.getURI());
            }
        }

        protected void gather(EditingDomain domain, URI uri) {
            URI normalizedURI = domain.getResourceSet().getURIConverter().normalize(uri);
            URI resolvedURI = CommonPlugin.resolve((URI)normalizedURI);
            if (resolvedURI.isFile()) {
                this.files.add(new File(resolvedURI.toFileString()).getAbsolutePath());
            }
        }

        @Override
        public Object getData() {
            return this.files.isEmpty() ? null : this.files.toArray(new String[this.files.size()]);
        }

        @Override
        public void clear() {
            this.files = null;
        }
    }

    public static class LocalSelectionTransferDelegate
    extends SelectionTransferDelegate {
        protected final LocalSelectionTransfer localSelectionTransfer = LocalSelectionTransfer.getTransfer();

        @Override
        public Transfer getTransfer() {
            return this.localSelectionTransfer;
        }

        @Override
        public Collection<?> getData(EditingDomain domain, TransferData transferData) {
            return this.getValue(domain, this.localSelectionTransfer.nativeToJava(transferData));
        }

        @Override
        public Collection<?> getValue(EditingDomain domain, Object data) {
            if (data instanceof IStructuredSelection) {
                IStructuredSelection selection = (IStructuredSelection)data;
                return this.extractSelectedObjects(selection.toArray());
            }
            return Collections.emptyList();
        }

        @Override
        public boolean setSelection(EditingDomain domain, ISelection selection) {
            if (!selection.isEmpty()) {
                this.localSelectionTransfer.setSelection(selection);
                this.localSelectionTransfer.setSelectionSetTime(System.currentTimeMillis());
                return true;
            }
            return false;
        }

        @Override
        public Object getData() {
            return this.localSelectionTransfer.getSelection();
        }

        @Override
        public void clear() {
            this.localSelectionTransfer.setSelection(null);
        }
    }

    public static class LocalTransferDelegate
    extends SelectionTransferDelegate {
        protected final LocalTransfer localTransfer = LocalTransfer.getInstance();
        protected ISelection selection;

        @Override
        public Transfer getTransfer() {
            return this.localTransfer;
        }

        @Override
        public Collection<?> getData(EditingDomain domain, TransferData transferData) {
            return this.getValue(domain, this.localTransfer.nativeToJava(transferData));
        }

        @Override
        public Collection<?> getValue(EditingDomain domain, Object data) {
            if (data instanceof IStructuredSelection) {
                IStructuredSelection selection = (IStructuredSelection)data;
                return this.extractSelectedObjects(selection.toArray());
            }
            return Collections.emptyList();
        }

        @Override
        public boolean setSelection(EditingDomain domain, ISelection selection) {
            if (!selection.isEmpty()) {
                this.selection = selection;
                return true;
            }
            return false;
        }

        @Override
        public Object getData() {
            return this.selection;
        }

        @Override
        public void clear() {
            this.selection = null;
        }
    }

    public static class OomphBinaryTransferDelegate
    extends ResourceSetTransferDelegate {
        protected final OomphBinaryTransfer oomphBinaryTransfer = OomphBinaryTransfer.getInstance();
        protected Set<EObject> eObjects;
        protected byte[] data;

        @Override
        public Transfer getTransfer() {
            return this.oomphBinaryTransfer;
        }

        @Override
        public Collection<?> getData(EditingDomain domain, TransferData transferData) {
            return this.getValue(domain, this.oomphBinaryTransfer.nativeToJava(transferData));
        }

        @Override
        public Collection<?> getValue(EditingDomain domain, Object data) {
            if (data instanceof byte[]) {
                byte[] bytes = (byte[])data;
                try {
                    ResourceSet transferResourceSet = this.createResourceSet(domain);
                    ByteArrayInputStream in = new ByteArrayInputStream(bytes);
                    BinaryResourceImpl.EObjectInputStream eObjectInputStream = new BinaryResourceImpl.EObjectInputStream(in, null, transferResourceSet){
                        {
                            super($anonymous0, $anonymous1);
                            this.resourceSet = resourceSet;
                        }
                    };
                    BasicInternalEList ePackages = new BasicInternalEList(EPackage.class);
                    eObjectInputStream.loadEObjects((InternalEList)ePackages);
                    EPackage.Registry packageRegistry = transferResourceSet.getPackageRegistry();
                    EPackage[] ePackageArray = (EPackage[])ePackages.toArray((Object[])new EPackage[ePackages.size()]);
                    int n = ePackageArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        EPackage ePackage = ePackageArray[n2];
                        Resource resource = transferResourceSet.createResource(URI.createURI((String)"*.ecore"));
                        resource.getContents().add((Object)ePackage);
                        resource.setURI(ePackage.eResource().getURI());
                        String nsURI = ePackage.getNsURI();
                        EPackage registeredEPackage = packageRegistry.getEPackage(nsURI);
                        if (registeredEPackage == null) {
                            packageRegistry.put((Object)nsURI, (Object)ePackage);
                        } else {
                            LinkedHashMap<EObject, String> fragments = new LinkedHashMap<EObject, String>();
                            TreeIterator it = resource.getAllContents();
                            while (it.hasNext()) {
                                EObject eObject = (EObject)it.next();
                                fragments.put(eObject, resource.getURIFragment(eObject));
                            }
                            URI uri = URI.createURI((String)nsURI);
                            for (Map.Entry entry : fragments.entrySet()) {
                                ((InternalEObject)entry.getKey()).eSetProxyURI(uri.appendFragment((String)entry.getValue()));
                            }
                        }
                        ++n2;
                    }
                    BasicInternalEList eObjects = new BasicInternalEList(EObject.class);
                    eObjectInputStream.loadEObjects((InternalEList)eObjects);
                    Resource resource = transferResourceSet.createResource(URI.createURI((String)"*.xmi"));
                    resource.getContents().addAll((Collection)eObjects);
                    return eObjects;
                }
                catch (IOException ex) {
                    SWTException swtException = new SWTException(2003, ex.getMessage());
                    swtException.initCause((Throwable)ex);
                    throw swtException;
                }
            }
            return Collections.emptyList();
        }

        @Override
        public boolean setSelection(EditingDomain domain, ISelection selection) {
            if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
                this.eObjects = new LinkedHashSet<EObject>();
                Object[] objectArray = ((IStructuredSelection)selection).toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    this.gather(domain, object);
                    ++n2;
                }
            }
            return !this.eObjects.isEmpty();
        }

        protected void gather(EditingDomain domain, Object object) {
            Object unwrappedObject = AdapterFactoryEditingDomain.unwrap((Object)object);
            if (unwrappedObject instanceof EObject) {
                EObject eObject = (EObject)unwrappedObject;
                this.eObjects.add(eObject);
            } else if (unwrappedObject instanceof Resource) {
                Resource resource = (Resource)unwrappedObject;
                this.eObjects.addAll((Collection<EObject>)resource.getContents());
            }
        }

        @Override
        public Object getData() {
            if (!this.eObjects.isEmpty()) {
                UniqueEList ePackages = new UniqueEList();
                TreeIterator it = EcoreUtil.getAllContents(this.eObjects);
                while (it.hasNext()) {
                    EObject eObject = (EObject)it.next();
                    ePackages.add((Object)eObject.eClass().getEPackage());
                }
                int i = 0;
                while (i < ePackages.size()) {
                    EPackage ePackage = (EPackage)ePackages.get(i);
                    TreeIterator it2 = ePackage.eAllContents();
                    while (it2.hasNext()) {
                        EObject eObject = (EObject)it2.next();
                        for (EObject eCrossReference : eObject.eCrossReferences()) {
                            EObject rootContainer = EcoreUtil.getRootContainer((EObject)eCrossReference);
                            if (!(rootContainer instanceof EPackage)) continue;
                            ePackages.add((Object)((EPackage)rootContainer));
                        }
                    }
                    ++i;
                }
                ePackages.remove((Object)EcorePackage.eINSTANCE);
                ePackages.remove((Object)XMLTypePackage.eINSTANCE);
                ePackages.remove((Object)XMLNamespacePackage.eINSTANCE);
                class Copier
                extends ProxifyingCopier {
                    private static final long serialVersionUID = 1L;
                    private transient Map<EObject, EObject> packageCopies;

                    public Copier() {
                        super(true, true);
                    }

                    protected EClass getTarget(EClass eClass) {
                        EClass result;
                        if (this.packageCopies != null && (result = (EClass)this.packageCopies.get(eClass)) != null) {
                            return result;
                        }
                        return eClass;
                    }

                    protected EStructuralFeature getTarget(EStructuralFeature eStructuralFeature) {
                        EStructuralFeature result;
                        if (this.packageCopies != null && (result = (EStructuralFeature)this.packageCopies.get(eStructuralFeature)) != null) {
                            return result;
                        }
                        return eStructuralFeature;
                    }

                    protected void copyAttribute(EAttribute eAttribute, EObject eObject, EObject copyEObject) {
                        if (eAttribute.getEAttributeType().isSerializable()) {
                            super.copyAttribute(eAttribute, eObject, copyEObject);
                        }
                    }

                    protected void copyAttributeValue(EAttribute eAttribute, EObject eObject, Object value, EStructuralFeature.Setting setting) {
                        if (value != null) {
                            Class instanceClass2;
                            EDataType eAttributeType = eAttribute.getEAttributeType();
                            EDataType eType = (EDataType)setting.getEStructuralFeature().getEType();
                            Class instanceClass = eType.getInstanceClass();
                            if (instanceClass != (instanceClass2 = eAttributeType.getInstanceClass()) || instanceClass == null) {
                                if (eAttribute.isMany()) {
                                    ArrayList<Object> values = new ArrayList<Object>();
                                    for (Object element : (Collection)value) {
                                        values.add(EcoreUtil.createFromString((EDataType)eType, (String)EcoreUtil.convertToString((EDataType)eAttributeType, element)));
                                    }
                                    value = values;
                                } else {
                                    value = EcoreUtil.createFromString((EDataType)eType, (String)EcoreUtil.convertToString((EDataType)eAttributeType, (Object)value));
                                }
                            }
                        }
                        super.copyAttributeValue(eAttribute, eObject, (Object)value, setting);
                    }

                    public Collection<EPackage> copyEPackages(Collection<? extends EPackage> ePackages) {
                        BasicInternalEList result = new BasicInternalEList(EPackage.class, this.copyAll(ePackages));
                        this.copyReferences();
                        this.packageCopies = new HashMap<EObject, EObject>((Map<EObject, EObject>)((Object)this));
                        return result;
                    }

                    public Collection<EObject> copyEObjects(Collection<? extends EObject> eObjects) {
                        this.useOriginalReferences = false;
                        BasicInternalEList result = new BasicInternalEList(InternalEObject.class, this.copyAll(eObjects));
                        this.keySet().removeAll(this.packageCopies.keySet());
                        this.copyReferences();
                        return result;
                    }
                }
                Copier copier = new Copier();
                Collection<EPackage> ePackageCopies = copier.copyEPackages((Collection<? extends EPackage>)ePackages);
                for (EPackage ePackage : ePackageCopies) {
                    for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                        String instanceClassName = eClassifier.getInstanceClassName();
                        if (instanceClassName == null) continue;
                        if (eClassifier instanceof EDataType) {
                            eClassifier.setInstanceClass(String.class);
                            continue;
                        }
                        eClassifier.setInstanceClassName(null);
                        eClassifier.setInstanceClass(null);
                    }
                }
                Collection<EObject> eObjectCopies = copier.copyEObjects(this.eObjects);
                try {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    BinaryResourceImpl.EObjectOutputStream eObjectOutputStream = new BinaryResourceImpl.EObjectOutputStream((OutputStream)out, null, BinaryResourceImpl.BinaryIO.Version.VERSION_1_1);
                    InternalEList internalEPackages = (InternalEList)ePackageCopies;
                    eObjectOutputStream.saveEObjects(internalEPackages, BinaryResourceImpl.EObjectOutputStream.Check.CONTAINER);
                    InternalEList internalEObjects = (InternalEList)eObjectCopies;
                    eObjectOutputStream.saveEObjects(internalEObjects, BinaryResourceImpl.EObjectOutputStream.Check.CONTAINER);
                    eObjectOutputStream.flush();
                    return out.toByteArray();
                }
                catch (IOException ex) {
                    SWTException swtException = new SWTException(2003, ex.getMessage());
                    swtException.initCause((Throwable)ex);
                    throw swtException;
                }
            }
            return null;
        }

        @Override
        public void clear() {
            this.eObjects.clear();
        }
    }

    private static class ProxifyingCopier
    extends EcoreUtil.Copier {
        private static final long serialVersionUID = 1L;
        private final BaseResourceImpl.BaseHelperImpl helper = new BaseResourceImpl.BaseHelperImpl(null);
        private final transient Collection<Resource> excludedResources = new HashSet<Resource>();

        public ProxifyingCopier(boolean resolveProxies, boolean useOriginalReferences) {
            super(resolveProxies, useOriginalReferences);
        }

        public EObject get(Object key) {
            EObject eObject = (EObject)super.get(key);
            if (eObject == null && !this.useOriginalReferences) {
                URI uri;
                InternalEObject originalEObject = (InternalEObject)key;
                if (originalEObject.eIsProxy()) {
                    InternalEObject proxy = (InternalEObject)EcoreUtil.create((EClass)this.getTarget(originalEObject.eClass()));
                    proxy.eSetProxyURI(originalEObject.eProxyURI());
                    return proxy;
                }
                Resource resource = originalEObject.eResource();
                if (resource != null && !this.excludedResources.contains(resource) && !(uri = this.helper.getHREF(resource, (EObject)originalEObject)).isCurrentDocumentReference()) {
                    InternalEObject proxy = (InternalEObject)EcoreUtil.create((EClass)this.getTarget(originalEObject.eClass()));
                    proxy.eSetProxyURI(uri);
                    return proxy;
                }
            }
            return eObject;
        }

        public <T> Collection<T> copyAll(Collection<? extends T> eObjects) {
            for (T object : eObjects) {
                this.excludedResources.add(((EObject)object).eResource());
            }
            return super.copyAll(eObjects);
        }
    }

    public static abstract class ResourceSetTransferDelegate
    extends OomphTransferDelegate {
        protected static final Resource.Factory RESOURCE_FACTORY = new BaseResourceFactoryImpl();

        protected ResourceSet createResourceSet(EditingDomain domain) {
            final ResourceSet resourceSet = domain.getResourceSet();
            ResourceSetImpl result = new ResourceSetImpl(){

                protected Resource delegatedGetResource(URI uri, boolean loadOnDemand) {
                    Resource result = super.delegatedGetResource(uri, loadOnDemand);
                    if (result == null) {
                        resourceSet.getResource(uri, false);
                    }
                    return result;
                }
            };
            result.setURIConverter(resourceSet.getURIConverter());
            result.setPackageRegistry((EPackage.Registry)new EPackageRegistryImpl(resourceSet.getPackageRegistry()));
            result.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xmi", RESOURCE_FACTORY);
            return result;
        }
    }

    public static abstract class SelectionTransferDelegate
    extends OomphTransferDelegate {
        protected Collection<?> extractSelectedObjects(Object ... objects) {
            ArrayList<Object> result = new ArrayList<Object>();
            Object[] objectArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                Object filteredObject = this.filter(object);
                if (filteredObject != null) {
                    result.add(filteredObject);
                }
                ++n2;
            }
            return result;
        }

        protected Object filter(Object object) {
            URI uri;
            if (object instanceof Resource) {
                Resource resource = (Resource)object;
                return resource.getURI();
            }
            if (EMFPlugin.IS_RESOURCES_BUNDLE_AVAILABLE && (uri = EclipseHelper.getURI(object)) != null) {
                return uri;
            }
            return object;
        }
    }

    public static class TextTransferDelegate
    extends ResourceSetTransferDelegate {
        protected final TextTransfer textTransfer = TextTransfer.getInstance();
        protected Set<EObject> eObjects;
        protected List<String> text;

        @Override
        public Transfer getTransfer() {
            return this.textTransfer;
        }

        @Override
        public Collection<?> getData(EditingDomain domain, TransferData transferData) {
            return this.getValue(domain, this.textTransfer.nativeToJava(transferData));
        }

        @Override
        public Collection<?> getValue(EditingDomain domain, Object data) {
            if (data instanceof String) {
                String value = data.toString().trim();
                Collection<? extends EObject> result = this.fromString(domain, value);
                if (result != null) {
                    return result;
                }
                String[] uriStrings = value.split("\r?\n");
                LinkedHashSet<URI> uris = new LinkedHashSet<URI>();
                String[] stringArray = uriStrings;
                int n = uriStrings.length;
                int n2 = 0;
                while (n2 < n) {
                    String uriString = stringArray[n2];
                    try {
                        String trimmedURIString = uriString.trim().replace(" ", "%20");
                        URI uri = URI.createURI((String)trimmedURIString);
                        if (uri.scheme() != null && uri.scheme().length() > 1) {
                            new java.net.URI(trimmedURIString);
                            uris.add(uri);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    ++n2;
                }
                return uris;
            }
            return Collections.emptyList();
        }

        protected Collection<? extends EObject> fromString(EditingDomain domain, String value) {
            Collection<? extends EObject> eObjects;
            int end;
            int start;
            if (value != null && (start = value.indexOf("<?xml")) != -1 && (end = value.lastIndexOf(62)) != -1 && (eObjects = this.fromXML(domain, value.substring(start, end + 1))) != null) {
                return eObjects;
            }
            return null;
        }

        protected Collection<? extends EObject> fromXML(EditingDomain domain, String xml) {
            ResourceSet resourceSet = this.createResourceSet(domain);
            try {
                String name = XMLTypeFactory.eINSTANCE.convertHexBinary(IOUtil.getSHA1((String)xml));
                XMLResource resource = (XMLResource)resourceSet.createResource(URI.createURI((String)("dummy:/" + name + ".xmi")));
                resource.load(new InputSource(new StringReader(xml)), null);
                return resource.getContents();
            }
            catch (IOException iOException) {
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
            return null;
        }

        @Override
        public boolean setSelection(EditingDomain domain, ISelection selection) {
            this.eObjects = new LinkedHashSet<EObject>();
            this.text = new ArrayList<String>();
            if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
                Object[] objectArray = ((IStructuredSelection)selection).toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    this.gather(domain, object);
                    ++n2;
                }
            }
            return !this.eObjects.isEmpty() || !this.text.isEmpty();
        }

        protected void gather(EditingDomain domain, Object object) {
            Object unwrappedObject = AdapterFactoryEditingDomain.unwrap((Object)object);
            if (unwrappedObject instanceof EObject) {
                EObject eObject = (EObject)unwrappedObject;
                this.eObjects.add(eObject);
            } else if (unwrappedObject instanceof Resource) {
                Resource resource = (Resource)unwrappedObject;
                this.eObjects.addAll((Collection<EObject>)resource.getContents());
            } else if (unwrappedObject instanceof String) {
                this.text.add((String)unwrappedObject);
            }
        }

        @Override
        public Object getData() {
            if (!this.eObjects.isEmpty()) {
                XMLResource resource = (XMLResource)RESOURCE_FACTORY.createResource(URI.createURI((String)"dummy:/*.xmi"));
                ProxifyingCopier copier = new ProxifyingCopier(true, false);
                Collection<EObject> eObjectCopies = copier.copyAll(this.eObjects);
                copier.copyReferences();
                resource.getContents().addAll(eObjectCopies);
                StringWriter writer = new StringWriter();
                try {
                    resource.save((Writer)writer, null);
                    writer.flush();
                    return writer.toString();
                }
                catch (IOException iOException) {}
            } else if (!this.text.isEmpty()) {
                StringBuilder result = new StringBuilder();
                for (String value : this.text) {
                    if (result.length() > 0) {
                        result.append(System.getProperty("line.separator"));
                    }
                    result.append(value);
                }
                return result.toString();
            }
            return null;
        }

        @Override
        public void clear() {
            this.eObjects = null;
            this.text = null;
        }
    }

    public static class URLTransferDelegate
    extends OomphTransferDelegate {
        protected final URLTransfer urlTransfer = URLTransfer.getInstance();
        protected String url;

        @Override
        public Transfer getTransfer() {
            return this.urlTransfer;
        }

        @Override
        public Collection<?> getData(EditingDomain domain, TransferData transferData) {
            return this.getValue(domain, this.urlTransfer.nativeToJava(transferData));
        }

        @Override
        public Collection<?> getValue(EditingDomain domain, Object data) {
            if (data instanceof String) {
                String value = data.toString().trim();
                try {
                    return Collections.singleton(URI.createURI((String)value));
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            return Collections.emptyList();
        }

        @Override
        public boolean setSelection(EditingDomain domain, ISelection selection) {
            if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
                Object[] objectArray = ((IStructuredSelection)selection).toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    this.gather(domain, object);
                    if (this.url != null) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }

        protected void gather(EditingDomain domain, Object object) {
            Object unwrappedObject = AdapterFactoryEditingDomain.unwrap((Object)object);
            if (unwrappedObject instanceof Resource) {
                Resource resource = (Resource)unwrappedObject;
                this.gather(domain, resource.getURI());
            }
        }

        protected void gather(EditingDomain domain, URI uri) {
            URI normalizedURI = domain.getResourceSet().getURIConverter().normalize(uri);
            URI resolvedURI = CommonPlugin.resolve((URI)normalizedURI);
            this.url = resolvedURI.toString();
        }

        @Override
        public Object getData() {
            return this.url;
        }

        @Override
        public void clear() {
            this.url = null;
        }
    }
}

