/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.common.ui;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.ui.CommonUIPlugin;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class MarkerHelper {
    public String getDiagnosticSource() {
        return "org.eclipse.emf.common.ui.markers";
    }

    protected String getMarkerID() {
        return "org.eclipse.core.resources.problemmarker";
    }

    protected IFile getFile(Object datum) {
        if (datum instanceof IFileEditorInput) {
            return ((IFileEditorInput)datum).getFile();
        }
        if (datum instanceof IFile) {
            return (IFile)datum;
        }
        if (datum instanceof Diagnostic) {
            return this.getFile((Diagnostic)datum);
        }
        return null;
    }

    protected IFile getFile(Diagnostic diagnostic) {
        List data = diagnostic.getData();
        if (data != null) {
            for (Object datum : data) {
                IFile result = this.getFile(datum);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    protected IFile getFile(URI uri) {
        return uri.isPlatformResource() && uri.segmentCount() > 2 ? ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true))) : null;
    }

    public void createMarkers(final Diagnostic diagnostic) throws CoreException {
        ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                if (diagnostic.getChildren().isEmpty()) {
                    MarkerHelper.this.createMarkers((IResource)MarkerHelper.this.getFile(diagnostic), diagnostic, null);
                } else if (diagnostic.getMessage() == null) {
                    for (Diagnostic childDiagnostic : diagnostic.getChildren()) {
                        MarkerHelper.this.createMarkers(childDiagnostic);
                    }
                } else {
                    for (Diagnostic childDiagnostic : diagnostic.getChildren()) {
                        MarkerHelper.this.createMarkers((IResource)MarkerHelper.this.getFile(childDiagnostic), childDiagnostic, diagnostic);
                    }
                }
            }
        }, null);
    }

    protected void createMarkers(IResource resource, Diagnostic diagnostic, Diagnostic parentDiagnostic) throws CoreException {
        if (resource != null && resource.exists()) {
            IMarker marker = resource.createMarker(this.getMarkerID());
            int severity = diagnostic.getSeverity();
            if (severity < 2) {
                marker.setAttribute("severity", 0);
            } else if (severity < 4) {
                marker.setAttribute("severity", 1);
            } else {
                marker.setAttribute("severity", 2);
            }
            String message = this.composeMessage(diagnostic, parentDiagnostic);
            if (message != null) {
                marker.setAttribute("message", (Object)message);
            }
            this.adjustMarker(marker, diagnostic, parentDiagnostic);
        }
    }

    protected void adjustMarker(IMarker marker, Diagnostic diagnostic, Diagnostic parentDiagnostic) throws CoreException {
    }

    protected String composeMessage(Diagnostic diagnostic, Diagnostic parentDiagnostic) {
        return diagnostic.getMessage();
    }

    public boolean hasMarkers(Object object) {
        return this.hasMarkers(object, false, 0);
    }

    public boolean hasMarkers(Object object, boolean includeSubtypes, int depth) {
        return this.hasMarkers((IResource)this.getFile(object), includeSubtypes, depth);
    }

    protected boolean hasMarkers(IResource resource, boolean includeSubtypes, int depth) {
        if (resource != null && resource.exists()) {
            try {
                IMarker[] markers = resource.findMarkers(this.getMarkerID(), includeSubtypes, depth);
                return markers.length > 0;
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return false;
    }

    public void deleteMarkers(Object object) {
        this.deleteMarkers(object, false, 0);
    }

    public void deleteMarkers(Object object, boolean includeSubtypes, int depth) {
        this.deleteMarkers((IResource)this.getFile(object), includeSubtypes, depth);
    }

    protected void deleteMarkers(final IResource resource, final boolean includeSubtypes, final int depth) {
        if (resource != null && resource.exists()) {
            try {
                resource.getWorkspace().run(new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        resource.deleteMarkers(MarkerHelper.this.getMarkerID(), includeSubtypes, depth);
                    }
                }, null);
            }
            catch (CoreException e) {
                CommonUIPlugin.INSTANCE.log((Object)e);
            }
        }
    }

    public IEditorInput getEditorInput(Object object) {
        IFile file = this.getFile(object);
        if (file != null) {
            return new FileEditorInput(file);
        }
        return null;
    }

    public List<?> getTargetObjects(Object object, IMarker marker) {
        return this.getTargetObjects(object, marker, true);
    }

    public List<?> getTargetObjects(Object object, IMarker marker, boolean wrap) {
        return Collections.EMPTY_LIST;
    }

    public Diagnostic getMarkerDiagnostics(Object object, IFile file) {
        return this.getMarkerDiagnostics(object, file, true);
    }

    public Diagnostic getMarkerDiagnostics(Object object, IFile file, boolean wrap) {
        BasicDiagnostic diagnostic = new BasicDiagnostic(null, 0, this.getDiagnosticSource(), new Object[]{object});
        try {
            IMarker[] iMarkerArray = file.findMarkers(null, true, 0);
            int n = iMarkerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker iMarker = iMarkerArray[n2];
                String message = iMarker.getAttribute("message", "");
                int severity = iMarker.getAttribute("severity", 1);
                String sourceID = iMarker.getAttribute("sourceId", "");
                diagnostic.add((Diagnostic)new BasicDiagnostic(severity == 2 ? 4 : (severity == 1 ? 2 : 1), sourceID, 0, message, null));
                ++n2;
            }
            for (Diagnostic diagnostic2 : this.getIntrinsicDiagnostics(object, wrap)) {
                diagnostic.add(diagnostic2);
            }
        }
        catch (CoreException coreException) {
            CommonUIPlugin.INSTANCE.log((Object)coreException);
        }
        return diagnostic;
    }

    public List<? extends Diagnostic> getInstrinciDiagnostics(Object object, boolean wrap) {
        return Collections.emptyList();
    }

    public final List<? extends Diagnostic> getIntrinsicDiagnostics(Object object, boolean wrap) {
        return this.getInstrinciDiagnostics(object, wrap);
    }

    public void updateMarkers(final Diagnostic diagnostic) throws CoreException {
        ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                MarkerHelper.this.deleteMarkers(diagnostic);
                if (diagnostic.getSeverity() != 0) {
                    MarkerHelper.this.createMarkers(diagnostic);
                }
            }
        }, null);
    }
}

