/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui.synchronizer;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.oomph.internal.ui.UIPropertyTester;
import org.eclipse.oomph.setup.SetupTask;
import org.eclipse.oomph.setup.internal.core.SetupContext;
import org.eclipse.oomph.setup.internal.sync.DataProvider;
import org.eclipse.oomph.setup.internal.sync.LocalDataProvider;
import org.eclipse.oomph.setup.internal.sync.RemoteDataProvider;
import org.eclipse.oomph.setup.internal.sync.SetupSyncPlugin;
import org.eclipse.oomph.setup.internal.sync.Synchronization;
import org.eclipse.oomph.setup.internal.sync.Synchronizer;
import org.eclipse.oomph.setup.internal.sync.SynchronizerAdapter;
import org.eclipse.oomph.setup.internal.sync.SynchronizerJob;
import org.eclipse.oomph.setup.internal.sync.SynchronizerListener;
import org.eclipse.oomph.setup.sync.SyncAction;
import org.eclipse.oomph.setup.sync.SyncActionType;
import org.eclipse.oomph.setup.sync.SyncPolicy;
import org.eclipse.oomph.setup.ui.SetupUIPlugin;
import org.eclipse.oomph.setup.ui.synchronizer.AbstractServiceDialog;
import org.eclipse.oomph.setup.ui.synchronizer.Messages;
import org.eclipse.oomph.setup.ui.synchronizer.OAuthConstants;
import org.eclipse.oomph.setup.ui.synchronizer.SynchronizerDialog;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.LockFile;
import org.eclipse.oomph.util.OS;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.oomph.util.PropertyFile;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.userstorage.IStorage;
import org.eclipse.userstorage.IStorageService;
import org.eclipse.userstorage.StorageFactory;
import org.eclipse.userstorage.oauth.EclipseOAuthCredentialsProvider;
import org.eclipse.userstorage.oauth.OAuthParameters;
import org.eclipse.userstorage.spi.ICredentialsProvider;
import org.eclipse.userstorage.spi.StorageCache;

public final class SynchronizerManager {
    public static final File SYNC_FOLDER = SetupSyncPlugin.INSTANCE.getUserLocation().toFile();
    public static final SynchronizerManager INSTANCE = new SynchronizerManager();
    public static final boolean ENABLED = !PropertiesUtil.isProperty((String)"oomph.setup.sync.skip");
    private static final File USER_SETUP = new File(SetupContext.USER_SETUP_LOCATION_URI.toFileString());
    private static final LockFile USER_SETUP_LOCK = new LockFile(new File(USER_SETUP.getParentFile(), USER_SETUP.getName() + ".lock"));
    private static final PropertyFile CONFIG = new PropertyFile(SetupSyncPlugin.INSTANCE.getUserLocation().append("sync.properties").toFile());
    private static final String CONFIG_SYNC_ENABLED = "sync.enabled";
    private static final String CONFIG_CONNECTION_SERVICE_DISCONTINUE = "connection.service.discontinue";
    private static final String CONNECTION_SERVICE_DISCONTINUE_ISSUME = "https://github.com/eclipse-oomph/oomph/issues/123";
    private final IStorage storage;
    private final RemoteDataProvider remoteDataProvider;
    private Boolean connectionServiceDiscontinue;

    private SynchronizerManager() {
        ICredentialsProvider credentialProvider;
        RemoteDataProvider.SyncStorageCache cache = new RemoteDataProvider.SyncStorageCache(SYNC_FOLDER);
        this.storage = StorageFactory.DEFAULT.create("cNhDr0INs8T109P8h6E1r_GvU3I", (StorageCache)cache);
        if (!PropertiesUtil.isProperty((String)"oomph.setup.sync.credential.provider.skip.default") && (credentialProvider = SynchronizerManager.createCredentialProvider()) != null) {
            this.storage.setCredentialsProvider(credentialProvider);
        }
        this.remoteDataProvider = new RemoteDataProvider(this.storage);
    }

    public IStorage getStorage() {
        return this.storage;
    }

    public RemoteDataProvider getRemoteDataProvider() {
        return this.remoteDataProvider;
    }

    public boolean isSyncEnabled() {
        try {
            return Boolean.parseBoolean(CONFIG.getProperty(CONFIG_SYNC_ENABLED, "false"));
        }
        catch (Throwable ex) {
            SetupUIPlugin.INSTANCE.log(ex);
            return false;
        }
    }

    public boolean setSyncEnabled(boolean enabled) {
        boolean changed = enabled ? CONFIG.compareAndSetProperty(CONFIG_SYNC_ENABLED, "true", new String[]{"false", null}) : CONFIG.compareAndSetProperty(CONFIG_SYNC_ENABLED, "false", new String[]{"true"});
        if (changed) {
            try {
                UIPropertyTester.requestEvaluation((String)"org.eclipse.oomph.setup.ui.syncEnabled", (boolean)false);
            }
            catch (Exception ex) {
                SetupUIPlugin.INSTANCE.log(ex);
            }
        }
        return changed;
    }

    public Synchronizer createSynchronizer(File userSetup, File syncFolder) {
        LocalDataProvider localDataProvider = new LocalDataProvider(userSetup);
        Synchronizer synchronizer = new Synchronizer((DataProvider)localDataProvider, (DataProvider)this.remoteDataProvider, syncFolder);
        synchronizer.setLockFile(USER_SETUP_LOCK);
        synchronizer.addListener((SynchronizerListener)new SkipHandler());
        return synchronizer;
    }

    public SynchronizationController startSynchronization(boolean withProgressDialog, boolean withCredentialsPrompt, boolean deferLocal) {
        SynchronizationController controller = new SynchronizationController();
        if (controller.start(withProgressDialog, withCredentialsPrompt, deferLocal)) {
            return controller;
        }
        return null;
    }

    public Synchronization synchronize(boolean withProgressDialog, boolean withCredentialsPrompt, boolean deferLocal) {
        SynchronizationController synchronizationController = this.startSynchronization(withProgressDialog, withCredentialsPrompt, deferLocal);
        if (synchronizationController != null) {
            return synchronizationController.await();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Impact performSynchronization(Synchronization synchronization, boolean interactive, boolean remoteModifications) {
        try {
            SynchronizerDialog dialog;
            EMap policies = synchronization.getRemotePolicies();
            Map actions = synchronization.getActions();
            HashMap<String, SyncAction> includedActions = new HashMap<String, SyncAction>();
            Iterator it = actions.entrySet().iterator();
            block12: while (it.hasNext()) {
                Map.Entry entry = it.next();
                String syncID = (String)entry.getKey();
                SyncAction syncAction = (SyncAction)entry.getValue();
                SyncPolicy policy = (SyncPolicy)policies.get((Object)syncID);
                if (policy == SyncPolicy.EXCLUDE || policy == null && !interactive) {
                    it.remove();
                    continue;
                }
                SyncActionType type = syncAction.getComputedType();
                switch (type) {
                    case SET_LOCAL: 
                    case REMOVE_LOCAL: {
                        if (remoteModifications) break;
                        it.remove();
                        continue block12;
                    }
                    case CONFLICT: {
                        if (interactive) break;
                        it.remove();
                        continue block12;
                    }
                    case NONE: 
                    case EXCLUDE: {
                        it.remove();
                        continue block12;
                    }
                }
                if (policy != SyncPolicy.INCLUDE || type == SyncActionType.CONFLICT) continue;
                it.remove();
                includedActions.put(syncID, syncAction);
            }
            if (actions.isEmpty()) {
                if (includedActions.isEmpty()) return null;
            }
            if (!actions.isEmpty() && (dialog = new SynchronizerDialog(UIUtil.getShell(), null, synchronization)).open() != 0) {
                return null;
            }
            actions.putAll(includedActions);
            try {
                synchronization.commit();
            }
            catch (DataProvider.NotCurrentException ex) {
                SetupUIPlugin.INSTANCE.log(ex, 1);
            }
            catch (IOException ex) {
                SetupUIPlugin.INSTANCE.log(ex, 2);
            }
            SkipHandler skipHandler = SynchronizerManager.getSkipHandler(synchronization);
            return skipHandler;
        }
        finally {
            synchronization.dispose();
        }
    }

    public Impact performFullSynchronization() {
        this.offerFirstTimeConnect(UIUtil.getShell());
        Synchronization synchronization = this.synchronize(true, true, false);
        if (synchronization != null) {
            return this.performSynchronization(synchronization, true, true);
        }
        return null;
    }

    public void warnServiceDiscontinue(final Shell shell, final IStorageService service) {
        String property;
        if (this.connectionServiceDiscontinue == null && (property = CONFIG.getProperty(CONFIG_CONNECTION_SERVICE_DISCONTINUE, null)) != null) {
            try {
                Date previousReminder = (Date)EcoreFactory.eINSTANCE.createFromString(EcorePackage.Literals.EDATE, property);
                long previousReminderTime = previousReminder.getTime();
                long oneWeekAgo = System.currentTimeMillis() - Duration.ofDays(7L).toMillis();
                if (previousReminderTime > oneWeekAgo) {
                    this.connectionServiceDiscontinue = true;
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        if (Boolean.TRUE.equals(this.connectionServiceDiscontinue)) {
            return;
        }
        shell.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                new ConnectionServiceDiscontinueDialog(shell, service, dialog -> {
                    Boolean answer = dialog.getAnswer();
                    if (answer != null) {
                        CONFIG.setProperty(SynchronizerManager.CONFIG_CONNECTION_SERVICE_DISCONTINUE, SynchronizerManager.getDate());
                        SynchronizerManager.this.connectionServiceDiscontinue = true;
                        SynchronizerManager.this.setSyncEnabled(answer);
                    }
                }).open();
            }
        });
    }

    public boolean offerFirstTimeConnect(Shell shell) {
        return false;
    }

    private static SkipHandler getSkipHandler(Synchronization synchronization) {
        SynchronizerListener[] synchronizerListenerArray = synchronization.getSynchronizer().getListeners();
        int n = synchronizerListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            SynchronizerListener listener = synchronizerListenerArray[n2];
            if (listener instanceof SkipHandler) {
                return (SkipHandler)listener;
            }
            ++n2;
        }
        return null;
    }

    private static ICredentialsProvider createCredentialProvider() {
        return new EclipseOAuthCredentialsProvider((OAuthParameters)new OAuthConstants());
    }

    private static String getDate() {
        return EcoreFactory.eINSTANCE.convertToString(EcorePackage.Literals.EDATE, (Object)new Date());
    }

    public static void log(Throwable throwable) {
        IStorage storage = INSTANCE.getStorage();
        IStorageService service = storage.getService();
        String serviceLabel = service == null ? "Unknown" : service.getServiceLabel();
        SetupUIPlugin.INSTANCE.log((IStatus)new Status(2, SetupUIPlugin.PLUGIN_ID, "Window -> Preferences -> Oomph -> Setup Tasks -> Preference Synchronizer -> 'Synchronize with " + serviceLabel + "' is enabled and the synchronization has failed for the following reason:", throwable));
    }

    public static final class Availability {
        public static final boolean AVAILABLE;

        static {
            boolean available;
            try {
                available = INSTANCE != null;
            }
            catch (NoClassDefFoundError error) {
                available = false;
            }
            AVAILABLE = available;
        }

        private Availability() {
        }
    }

    private static class ConnectionServiceDiscontinueDialog
    extends AbstractServiceDialog {
        private Boolean answer = false;
        private final Consumer<ConnectionServiceDiscontinueDialog> handler;

        public ConnectionServiceDiscontinueDialog(Shell parentShell, IStorageService service, Consumer<ConnectionServiceDiscontinueDialog> handler) {
            super(parentShell, service);
            this.setBlockOnOpen(false);
            this.setShellStyle(0x860 | ConnectionServiceDiscontinueDialog.getDefaultOrientation());
            this.handler = handler;
        }

        protected IDialogSettings getDialogBoundsSettings() {
            return null;
        }

        public Boolean getAnswer() {
            return this.answer;
        }

        @Override
        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
        }

        @Override
        protected void createUI(Composite parent, String serviceLabel, String shortLabel) {
            this.setMessage(NLS.bind((String)Messages.SynchronizerManager_ServiceDiscontinue_title, (Object)serviceLabel));
            Label label = new Label(parent, 0);
            label.setText(Messages.SynchronizerManager_ServiceDiscontinueFindOutMore_label);
            Link link = new Link(parent, 0);
            link.setText("<a>https://github.com/eclipse-oomph/oomph/issues/123</a>");
            link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    OS.INSTANCE.openSystemBrowser(SynchronizerManager.CONNECTION_SERVICE_DISCONTINUE_ISSUME);
                }
            });
            new Label(parent, 0);
            Button noButton = new Button(parent, 16);
            noButton.setText(NLS.bind((String)Messages.SynchronizerManager_ServiceDisable_label, (Object)shortLabel));
            noButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    answer = false;
                }
            });
            Button yesButton = new Button(parent, 16);
            yesButton.setText(NLS.bind((String)Messages.SynchronizerManager_ServiceContinue_label, (Object)shortLabel));
            yesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    answer = true;
                }
            });
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
            this.createButton(parent, 1, Messages.OptInDialog_askMeLaterButton_text, false);
        }

        protected void cancelPressed() {
            this.answer = null;
            super.cancelPressed();
            this.handler.accept(this);
        }

        protected void okPressed() {
            super.okPressed();
            this.handler.accept(this);
        }
    }

    public static interface Impact {
        public boolean hasLocalImpact();

        public boolean hasRemoteImpact();
    }

    private static final class SkipHandler
    extends SynchronizerAdapter
    implements Impact {
        private static final String CONFIG_SKIPPED_LOCAL = "skipped.local";
        private static final String CONFIG_SKIPPED_REMOTE = "skipped.remote";
        private static final String ID_SEPARATOR = " ";
        private final Set<DataProvider.Location> skippedLocations = new HashSet<DataProvider.Location>();
        private final Set<String> skippedLocal = new HashSet<String>();
        private final Set<String> skippedRemote = new HashSet<String>();
        private final Set<String> computedLocal = new HashSet<String>();
        private final Set<String> computedRemote = new HashSet<String>();
        private boolean localImpact;
        private boolean remoteImpact;

        @Override
        public boolean hasLocalImpact() {
            return this.localImpact;
        }

        @Override
        public boolean hasRemoteImpact() {
            return this.remoteImpact;
        }

        public void tasksCollected(Synchronization synchronization, DataProvider.Location location, Map<String, SetupTask> oldTasks, Map<String, SetupTask> newTasks) {
            Set<String> skippedIDs = this.getSkippedIDs(location);
            oldTasks.keySet().removeAll(skippedIDs);
        }

        public void actionsComputed(Synchronization synchronization, Map<String, SyncAction> actions) {
            this.computedLocal.clear();
            this.computedRemote.clear();
            SkipHandler.analyzeImpact(actions, this.computedLocal, this.computedRemote);
        }

        public void commitFinished(Synchronization synchronization, Throwable t) {
            if (t != null) {
                return;
            }
            HashSet<String> committedLocal = new HashSet<String>();
            HashSet<String> committedRemote = new HashSet<String>();
            Map actions = synchronization.getActions();
            SkipHandler.analyzeImpact(actions, committedLocal, committedRemote);
            this.localImpact = !committedRemote.isEmpty();
            this.remoteImpact = !committedLocal.isEmpty();
            this.computedLocal.removeAll(committedLocal);
            this.computedLocal.removeAll(committedRemote);
            this.computedRemote.removeAll(committedLocal);
            this.computedRemote.removeAll(committedRemote);
            this.setSkippedIDs(DataProvider.Location.LOCAL, this.computedLocal);
            this.setSkippedIDs(DataProvider.Location.REMOTE, this.computedRemote);
        }

        private Set<String> getSkippedIDs(DataProvider.Location location) {
            String key;
            String property;
            Set skippedIDs = (Set)location.pick(this.skippedLocal, this.skippedRemote);
            if (this.skippedLocations.add(location) && (property = CONFIG.getProperty(key = (String)location.pick((Object)CONFIG_SKIPPED_LOCAL, (Object)CONFIG_SKIPPED_REMOTE), null)) != null) {
                StringTokenizer tokenizer = new StringTokenizer(property, ID_SEPARATOR);
                while (tokenizer.hasMoreTokens()) {
                    String id = tokenizer.nextToken();
                    skippedIDs.add(id);
                }
            }
            return skippedIDs;
        }

        private void setSkippedIDs(DataProvider.Location location, Set<String> skippedIDs) {
            String key = (String)location.pick((Object)CONFIG_SKIPPED_LOCAL, (Object)CONFIG_SKIPPED_REMOTE);
            if (skippedIDs.isEmpty()) {
                CONFIG.removeProperty(key);
            } else {
                ArrayList<String> list = new ArrayList<String>(skippedIDs);
                Collections.sort(list);
                StringBuilder builder = new StringBuilder();
                for (String id : list) {
                    if (builder.length() != 0) {
                        builder.append(ID_SEPARATOR);
                    }
                    builder.append(id);
                }
                CONFIG.setProperty(key, builder.toString());
            }
        }

        private static void analyzeImpact(Map<String, SyncAction> actions, Set<String> local, Set<String> remote) {
            for (Map.Entry<String, SyncAction> entry : actions.entrySet()) {
                String id = entry.getKey();
                SyncAction action = entry.getValue();
                SyncActionType effectiveType = action.getEffectiveType();
                switch (effectiveType) {
                    case SET_LOCAL: 
                    case REMOVE_LOCAL: {
                        local.add(id);
                        break;
                    }
                    case SET_REMOTE: 
                    case REMOVE_REMOTE: {
                        remote.add(id);
                        break;
                    }
                    case CONFLICT: {
                        local.add(id);
                        remote.add(id);
                    }
                }
            }
        }
    }

    public static final class SynchronizationController {
        private boolean withProgressDialog;
        private SynchronizerJob synchronizerJob;

        public boolean start(boolean withProgressDialog, boolean withCredentialsPrompt, boolean deferLocal) {
            this.withProgressDialog = withProgressDialog;
            if (ENABLED && this.synchronizerJob == null && INSTANCE.isSyncEnabled()) {
                IStorageService service = INSTANCE.getStorage().getService();
                if (service == null) {
                    return false;
                }
                Synchronizer synchronizer = INSTANCE.createSynchronizer(USER_SETUP, SYNC_FOLDER);
                this.synchronizerJob = new SynchronizerJob(synchronizer, deferLocal);
                this.synchronizerJob.setService(service);
                if (!withCredentialsPrompt) {
                    this.synchronizerJob.setCredentialsProvider(ICredentialsProvider.CANCEL);
                }
                INSTANCE.warnServiceDiscontinue(UIUtil.getShell(), service);
                this.synchronizerJob.schedule();
            }
            return this.synchronizerJob != null;
        }

        public void stop() {
            if (!ENABLED) {
                return;
            }
            if (this.synchronizerJob != null) {
                this.synchronizerJob.stopSynchronization();
                this.synchronizerJob = null;
            }
        }

        public Synchronization await() {
            if (!ENABLED) {
                return null;
            }
            if (this.synchronizerJob != null) {
                Synchronization[] result;
                block12: {
                    result = new Synchronization[]{this.synchronizerJob.getSynchronization()};
                    if (result[0] == null) {
                        block10: {
                            Throwable exception;
                            block11: {
                                final AtomicBoolean canceled = new AtomicBoolean();
                                IStorageService service = this.synchronizerJob.getService();
                                final String serviceLabel = service.getServiceLabel();
                                if (this.withProgressDialog) {
                                    final Semaphore authenticationSemaphore = service.getAuthenticationSemaphore();
                                    authenticationSemaphore.acquire();
                                    UIUtil.syncExec((Runnable)new Runnable(){

                                        @Override
                                        public void run() {
                                            try {
                                                Shell shell = UIUtil.getShell();
                                                ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell);
                                                dialog.run(true, true, new IRunnableWithProgress(){

                                                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                                        authenticationSemaphore.release();
                                                        result[0] = this.await(serviceLabel, monitor);
                                                    }
                                                });
                                            }
                                            catch (InvocationTargetException ex) {
                                                SetupUIPlugin.INSTANCE.log(ex);
                                            }
                                            catch (InterruptedException ex) {
                                                canceled.set(true);
                                            }
                                        }
                                    });
                                } else {
                                    NullProgressMonitor monitor = new NullProgressMonitor();
                                    Job watchDog = new Job(Messages.SynchronizerManager_watchDogJob_name){

                                        protected IStatus run(IProgressMonitor monitor) {
                                            try {
                                                Thread.sleep(10000L);
                                            }
                                            catch (Throwable throwable) {
                                                // empty catch block
                                            }
                                            monitor.setCanceled(true);
                                            return Status.OK_STATUS;
                                        }
                                    };
                                    watchDog.setSystem(true);
                                    watchDog.schedule();
                                    result[0] = this.await(serviceLabel, (IProgressMonitor)monitor);
                                }
                                if (result[0] != null || canceled.get()) break block10;
                                exception = this.synchronizerJob.getException();
                                if (exception != null && !(exception instanceof OperationCanceledException)) break block11;
                                this.synchronizerJob = null;
                                return null;
                            }
                            try {
                                try {
                                    SynchronizerManager.log(exception);
                                }
                                catch (Throwable ex) {
                                    SetupUIPlugin.INSTANCE.log(ex);
                                    this.synchronizerJob = null;
                                    break block12;
                                }
                            }
                            catch (Throwable throwable) {
                                this.synchronizerJob = null;
                                throw throwable;
                            }
                        }
                        this.synchronizerJob = null;
                    }
                }
                return result[0];
            }
            return null;
        }

        private Synchronization await(String serviceLabel, IProgressMonitor monitor) {
            monitor.beginTask(NLS.bind((String)Messages.SynchronizerManager_requestDataTask_name, (Object)serviceLabel), -1);
            try {
                Synchronization synchronization = this.synchronizerJob.awaitSynchronization(monitor);
                return synchronization;
            }
            finally {
                monitor.done();
            }
        }
    }
}

