/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.core.impl.sac;

import java.util.Set;
import org.eclipse.e4.ui.css.core.impl.sac.ExtendedCondition;
import org.w3c.css.sac.LangCondition;
import org.w3c.dom.Element;

public class CSSLangConditionImpl
implements LangCondition,
ExtendedCondition {
    protected String lang;
    protected String langHyphen;

    public CSSLangConditionImpl(String lang) {
        this.lang = lang.toLowerCase();
        this.langHyphen = lang + "-";
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        CSSLangConditionImpl c = (CSSLangConditionImpl)obj;
        return c.lang.equals(this.lang);
    }

    public short getConditionType() {
        return 6;
    }

    public String getLang() {
        return this.lang;
    }

    @Override
    public int getSpecificity() {
        return 256;
    }

    @Override
    public boolean match(Element e, String pseudoE) {
        String s = e.getAttribute("lang").toLowerCase();
        if (s.equals(this.lang) || s.startsWith(this.langHyphen)) {
            return true;
        }
        return s.equals(this.lang) || s.startsWith(this.langHyphen);
    }

    @Override
    public void fillAttributeSet(Set<String> attrSet) {
        attrSet.add("lang");
    }

    public String toString() {
        return ":lang(" + this.lang + ")";
    }
}

