/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text;

import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.SWT;

public class SurroundWithBracketsStrategy
implements IAutoEditStrategy {
    private ISourceViewer sourceViewer;
    private final Map<String, String> bracketsMap = Map.of("(", ")", "[", "]", "{", "}", "<", ">", "\"", "\"", "'", "'", "`", "`");

    public SurroundWithBracketsStrategy(ISourceViewer sourceViewer) {
        this.sourceViewer = sourceViewer;
    }

    @Override
    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        if (command.text != null && this.bracketsMap.containsKey(command.text)) {
            try {
                ITextSelection selection = command.fSelection;
                if (selection != null && selection.getLength() > 0) {
                    String selectedText = document.get(selection.getOffset(), selection.getLength());
                    String closingBracket = this.bracketsMap.get(command.text);
                    command.text = command.text + selectedText + closingBracket;
                    command.offset = selection.getOffset();
                    command.length = selection.getLength();
                    command.caretOffset = command.offset + command.text.length() - closingBracket.length();
                    command.shiftsCaret = false;
                    this.sourceViewer.getTextWidget().getDisplay().asyncExec(() -> this.sourceViewer.setSelectedRange(documentCommand.offset + 1, selectedText.length()));
                }
            }
            catch (BadLocationException e) {
                SWT.error((int)5);
            }
        }
    }
}

