/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.util.Arrays;
import java.util.LinkedList;
import org.eclipse.core.resources.FileInfoMatcherDescription;
import org.eclipse.core.resources.IFilterMatcherDescriptor;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceFilterDescription;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.ide.dialogs.UIResourceFilterDescription;
import org.eclipse.ui.internal.ide.dialogs.FilterTypeUtil;
import org.eclipse.ui.internal.ide.misc.FileInfoAttributesMatcher;
import org.eclipse.ui.internal.ide.misc.StringFileInfoMatcher;

class FilterCopy
extends UIResourceFilterDescription {
    Object arguments = null;
    String id = null;
    IPath path = null;
    IProject project = null;
    int type = 0;
    FilterCopy parent = null;
    LinkedList<FilterCopy> children = null;
    UIResourceFilterDescription original = null;
    int serialNumber = ++lastSerialNumber;
    private static int lastSerialNumber = 0;

    public FilterCopy(UIResourceFilterDescription filter) {
        this.internalCopy(filter);
        this.original = filter;
    }

    protected FilterCopy convertLegacyMatchers(FilterCopy copy) {
        if (copy.getId().equals("org.eclipse.core.resources.regexFilterMatcher") || copy.getId().equals(StringFileInfoMatcher.ID)) {
            String pattern = (String)copy.getArguments();
            FileInfoAttributesMatcher.Argument argument = new FileInfoAttributesMatcher.Argument();
            argument.key = FileInfoAttributesMatcher.KEY_NAME;
            argument.operator = FileInfoAttributesMatcher.OPERATOR_MATCHES;
            argument.pattern = pattern;
            argument.regularExpression = copy.getId().equals("org.eclipse.core.resources.regexFilterMatcher");
            String encodedArgument = FileInfoAttributesMatcher.encodeArguments(argument);
            FilterTypeUtil.setValue(copy, FilterTypeUtil.ID, FileInfoAttributesMatcher.ID);
            FilterTypeUtil.setValue(copy, FilterTypeUtil.ARGUMENTS, encodedArgument);
        }
        return copy;
    }

    public void removeAll() {
        this.initializeChildren();
        for (FilterCopy child : this.children) {
            if (child.parent != this) continue;
            child.parent = null;
        }
        this.children.clear();
        this.serializeChildren();
    }

    public void setParent(FilterCopy parent) {
        this.parent = parent;
    }

    public boolean canAcceptDrop() {
        int limit = this.getChildrenLimit();
        if (limit > 0) {
            FilterCopy[] tmp = this.getChildren();
            return tmp == null || tmp.length < limit;
        }
        return false;
    }

    public boolean hasParent(FilterCopy filterCopy) {
        FilterCopy filter = this;
        do {
            if (!filter.equals(filterCopy)) continue;
            return true;
        } while ((filter = filter.getParent()) != null);
        return false;
    }

    public FilterCopy getParent() {
        return this.parent;
    }

    public void copy(UIResourceFilterDescription filter) {
        this.internalCopy(filter);
        this.argumentsChanged();
    }

    private void internalCopy(UIResourceFilterDescription filter) {
        this.children = null;
        this.id = filter.getFileInfoMatcherDescription().getId();
        this.path = filter.getPath();
        this.project = filter.getProject();
        this.type = filter.getType();
        this.arguments = filter.getFileInfoMatcherDescription().getArguments();
        if (this.arguments instanceof FileInfoMatcherDescription[]) {
            FileInfoMatcherDescription[] descs = (FileInfoMatcherDescription[])this.arguments;
            FilterCopy[] tmp = new FilterCopy[descs.length];
            int i = 0;
            while (i < tmp.length) {
                tmp[i] = new FilterCopy(this, descs[i]);
                ++i;
            }
            this.arguments = tmp;
        }
    }

    public boolean hasChanged() {
        if (this.original != null) {
            return !(this.arguments == null ? this.original.getFileInfoMatcherDescription().getArguments() == null : this.arguments.equals(this.original.getFileInfoMatcherDescription().getArguments())) || !this.id.equals(this.original.getFileInfoMatcherDescription().getId()) || this.type != this.original.getType();
        }
        return true;
    }

    public FilterCopy() {
        this.path = null;
        this.project = null;
        this.type = 5;
        this.id = FilterTypeUtil.getDefaultFilterID();
    }

    public FilterCopy(FilterCopy parent, FileInfoMatcherDescription description) {
        this.children = null;
        this.id = description.getId();
        this.path = parent.getPath();
        this.project = parent.getProject();
        this.type = parent.getType();
        this.arguments = description.getArguments();
        if (this.arguments instanceof FileInfoMatcherDescription[]) {
            FileInfoMatcherDescription[] descs = (FileInfoMatcherDescription[])this.arguments;
            FilterCopy[] tmp = new FilterCopy[descs.length];
            int i = 0;
            while (i < tmp.length) {
                tmp[i] = new FilterCopy(parent, descs[i]);
                ++i;
            }
            this.arguments = tmp;
        }
    }

    public Object getArguments() {
        return this.arguments;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public IPath getPath() {
        return this.path;
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    @Override
    public int getType() {
        return this.type;
    }

    public void setArguments(Object arguments) {
        this.arguments = arguments;
        this.argumentsChanged();
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setPath(IPath path) {
        this.path = path;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public void setType(int type) {
        this.type = type;
    }

    public boolean hasStringArguments() {
        IFilterMatcherDescriptor descriptor = FilterTypeUtil.getDescriptor(this.id);
        if (descriptor != null) {
            return descriptor.getArgumentType().equals("string");
        }
        return false;
    }

    public int getChildrenLimit() {
        IFilterMatcherDescriptor descriptor = FilterTypeUtil.getDescriptor(this.id);
        if (descriptor != null) {
            if (descriptor.getArgumentType().equals("filterMatcher")) {
                return 1;
            }
            if (descriptor.getArgumentType().equals("filterMatchers")) {
                return Integer.MAX_VALUE;
            }
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (!(o instanceof FilterCopy)) {
            return false;
        }
        FilterCopy filter = (FilterCopy)o;
        return this.serialNumber == filter.serialNumber;
    }

    public int hashCode() {
        return this.serialNumber;
    }

    public int getSerialNumber() {
        return this.serialNumber;
    }

    public FilterCopy findBySerialNumber(int number) {
        LinkedList<FilterCopy> pending = new LinkedList<FilterCopy>();
        pending.add(this);
        while (!pending.isEmpty()) {
            FilterCopy filter = (FilterCopy)pending.getFirst();
            pending.removeFirst();
            if (filter.serialNumber == number) {
                return filter;
            }
            FilterCopy[] tmp = filter.getChildren();
            if (tmp == null) continue;
            pending.addAll(Arrays.asList(tmp));
        }
        return null;
    }

    public FilterCopy[] getChildren() {
        if (this.getChildrenLimit() > 0) {
            this.initializeChildren();
            return this.children.toArray(new FilterCopy[0]);
        }
        return null;
    }

    protected void initializeChildren() {
        if (this.children == null && this.getChildrenLimit() > 0) {
            FilterCopy[] filters;
            Object object;
            this.children = new LinkedList();
            Object object2 = this.getArguments();
            if (object2 instanceof IResourceFilterDescription[]) {
                IResourceFilterDescription[] filters2;
                IResourceFilterDescription[] iResourceFilterDescriptionArray = filters2 = (IResourceFilterDescription[])object2;
                int n = filters2.length;
                int n2 = 0;
                while (n2 < n) {
                    IResourceFilterDescription filter = iResourceFilterDescriptionArray[n2];
                    FilterCopy child = new FilterCopy(UIResourceFilterDescription.wrap(filter));
                    child.parent = this;
                    this.children.add(child);
                    ++n2;
                }
            }
            if ((object = this.getArguments()) instanceof FilterCopy[] && (filters = (FilterCopy[])object) != null) {
                FilterCopy[] filterCopyArray = filters;
                int n = filters.length;
                int n3 = 0;
                while (n3 < n) {
                    FilterCopy filter;
                    FilterCopy child = filter = filterCopyArray[n3];
                    child.parent = this;
                    this.children.add(child);
                    ++n3;
                }
            }
        }
    }

    protected void addChild(FilterCopy child) {
        this.initializeChildren();
        if (child.getParent() != null) {
            child.getParent().removeChild(child);
        }
        this.children.add(child);
        child.parent = this;
        this.serializeChildren();
    }

    protected void removeChild(FilterCopy child) {
        this.initializeChildren();
        this.children.remove(child);
        if (child.parent == this) {
            child.parent = null;
        }
        this.serializeChildren();
    }

    protected void serializeChildren() {
        this.initializeChildren();
        this.argumentsChanged();
    }

    protected void argumentsChanged() {
        this.initializeChildren();
        if (this.children != null) {
            this.arguments = this.children.toArray(new FilterCopy[0]);
        }
        FilterCopy up = this.parent;
        while (up != null) {
            up.serializeChildren();
            up = up.parent;
        }
    }

    public boolean isUnderAGroupFilter() {
        return this.parent != null && this.parent.getChildrenLimit() > 0 && this.parent.getParent() != null;
    }

    @Override
    public FileInfoMatcherDescription getFileInfoMatcherDescription() {
        FileInfoMatcherDescription[] arg = this.getArguments();
        if (arg instanceof FilterCopy[]) {
            FilterCopy[] filterCopies = (FilterCopy[])arg;
            FileInfoMatcherDescription[] descriptions = new FileInfoMatcherDescription[filterCopies.length];
            int i = 0;
            while (i < descriptions.length) {
                descriptions[i] = filterCopies[i].getFileInfoMatcherDescription();
                ++i;
            }
            arg = descriptions;
        }
        return new FileInfoMatcherDescription(this.getId(), (Object)arg);
    }
}

