/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public abstract class SelectionListenerAction
extends BaseSelectionListenerAction {
    private boolean selectionDirty = true;
    private List<IResource> resources;
    private List<Object> nonResources;

    protected SelectionListenerAction(String text) {
        super(text);
    }

    protected void clearCache() {
        this.selectionDirty = true;
        this.resources = null;
        this.nonResources = null;
    }

    private final void computeResources() {
        this.resources = null;
        this.nonResources = null;
        IStructuredSelection structuredSelection = this.getStructuredSelection();
        ArrayList<IResource> resourcesTmp = new ArrayList<IResource>(structuredSelection.size());
        ArrayList<Object> nonResourcesTmp = new ArrayList<Object>();
        for (Object next : structuredSelection) {
            IResource resource = (IResource)Adapters.adapt(next, IResource.class);
            if (resource != null) {
                resourcesTmp.add(resource);
                continue;
            }
            boolean resourcesFoundForThisSelection = false;
            ResourceMapping mapping = (ResourceMapping)Adapters.adapt(next, ResourceMapping.class);
            if (mapping != null) {
                ResourceTraversal[] traversals = null;
                try {
                    traversals = mapping.getTraversals(ResourceMappingContext.LOCAL_CONTEXT, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException exception) {
                    IDEWorkbenchPlugin.log(exception.getLocalizedMessage(), exception.getStatus());
                }
                if (traversals != null) {
                    ResourceTraversal[] resourceTraversalArray = traversals;
                    int n = traversals.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ResourceTraversal traversal = resourceTraversalArray[n2];
                        IResource[] traversalResources = traversal.getResources();
                        if (traversalResources != null) {
                            resourcesFoundForThisSelection = true;
                            resourcesTmp.addAll(Arrays.asList(traversalResources));
                        }
                        ++n2;
                    }
                }
            }
            if (resourcesFoundForThisSelection) continue;
            nonResourcesTmp.add(next);
        }
        this.resources = resourcesTmp.isEmpty() ? null : resourcesTmp;
        this.nonResources = nonResourcesTmp.isEmpty() ? null : nonResourcesTmp;
    }

    protected List<?> getSelectedNonResources() {
        List<Object> list;
        if (this.selectionDirty) {
            this.computeResources();
            this.selectionDirty = false;
        }
        if ((list = this.nonResources) == null) {
            return Collections.emptyList();
        }
        return list;
    }

    protected List<? extends IResource> getSelectedResources() {
        List<IResource> list;
        if (this.selectionDirty) {
            this.computeResources();
            this.selectionDirty = false;
        }
        if ((list = this.resources) == null) {
            return Collections.emptyList();
        }
        return list;
    }

    protected boolean resourceIsType(IResource resource, int resourceMask) {
        return (resource.getType() & resourceMask) != 0;
    }

    protected boolean selectionIsOfType(int resourceMask) {
        if (this.getSelectedNonResources().size() > 0) {
            return false;
        }
        for (IResource iResource : this.getSelectedResources()) {
            if (this.resourceIsType(iResource, resourceMask)) continue;
            return false;
        }
        return true;
    }
}

