/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.resource;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Optional;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.pde.api.tools.annotations.NoInstantiate;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

@NoInstantiate
public final class ResourceLocator {
    public static Optional<URL> locate(String bundleSymbolicName, String filePath) {
        URL url;
        IPath uriPath = IPath.fromOSString((String)"/plugin").append(bundleSymbolicName).append(filePath);
        try {
            URI uri = new URI("platform", null, uriPath.toString(), null);
            url = uri.toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            return Optional.empty();
        }
        URL fullPathString = FileLocator.find((URL)url);
        if (fullPathString == null) {
            try {
                url = new URL(filePath);
            }
            catch (MalformedURLException e) {
                return Optional.empty();
            }
        }
        return Optional.ofNullable(url);
    }

    public static Optional<URL> locate(Class<?> classFromBundle, String filePath) {
        return Optional.ofNullable(FileLocator.find((Bundle)FrameworkUtil.getBundle(classFromBundle), (IPath)IPath.fromOSString((String)filePath)));
    }

    public static Optional<ImageDescriptor> imageDescriptorFromBundle(String bundleSymbolicName, String imageFilePath) {
        Optional<URL> locate = ResourceLocator.locate(bundleSymbolicName, imageFilePath);
        return locate.map(ImageDescriptor::createFromURL);
    }

    public static Optional<ImageDescriptor> imageDescriptorFromBundle(Class<?> classFromBundle, String imageFilePath) {
        Optional<URL> locate = ResourceLocator.locate(classFromBundle, imageFilePath);
        return locate.map(ImageDescriptor::createFromURL);
    }
}

