/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui.wizards;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.oomph.base.Annotation;
import org.eclipse.oomph.base.util.BaseUtil;
import org.eclipse.oomph.internal.setup.SetupPrompter;
import org.eclipse.oomph.internal.ui.AccessUtil;
import org.eclipse.oomph.preferences.util.PreferencesUtil;
import org.eclipse.oomph.setup.Installation;
import org.eclipse.oomph.setup.SetupTaskContext;
import org.eclipse.oomph.setup.Trigger;
import org.eclipse.oomph.setup.User;
import org.eclipse.oomph.setup.VariableChoice;
import org.eclipse.oomph.setup.VariableTask;
import org.eclipse.oomph.setup.VariableType;
import org.eclipse.oomph.setup.Workspace;
import org.eclipse.oomph.setup.internal.core.SetupContext;
import org.eclipse.oomph.setup.internal.core.SetupTaskPerformer;
import org.eclipse.oomph.setup.internal.core.util.Authenticator;
import org.eclipse.oomph.setup.internal.core.util.SetupCoreUtil;
import org.eclipse.oomph.setup.ui.PropertyField;
import org.eclipse.oomph.setup.ui.SetupUIPlugin;
import org.eclipse.oomph.setup.ui.wizards.Messages;
import org.eclipse.oomph.setup.ui.wizards.SetupWizard;
import org.eclipse.oomph.setup.ui.wizards.SetupWizardPage;
import org.eclipse.oomph.setup.util.StringExpander;
import org.eclipse.oomph.ui.ButtonBar;
import org.eclipse.oomph.ui.ErrorDialog;
import org.eclipse.oomph.ui.UICallback;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.CollectionUtil;
import org.eclipse.oomph.util.OS;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.oomph.util.UserCallback;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class VariablePage
extends SetupWizardPage
implements SetupPrompter {
    private static final String BASIC_DESCRIPTION = Messages.VariablePage_description_basic;
    private static final String AUGMENTED_DESCRIPTION = BASIC_DESCRIPTION + "  " + Messages.VariablePage_description_addition;
    private static final URI INSTALLATION_ID_URI = URI.createURI((String)"#~installation.id");
    private static final URI WORKSPACE_ID_URI = URI.createURI((String)"#~workspace.id");
    private Composite composite;
    private ScrolledComposite scrolledComposite;
    private final FieldHolderManager manager = new FieldHolderManager();
    private final Set<String> unusedVariables = new HashSet<String>();
    private boolean prompted;
    private boolean fullPrompt;
    private boolean updating;
    private Set<SetupTaskPerformer> incompletePerformers = new LinkedHashSet<SetupTaskPerformer>();
    private Set<SetupTaskPerformer> allPromptedPerfomers = new LinkedHashSet<SetupTaskPerformer>();
    private SetupTaskPerformer performer;
    private Control focusControl;
    private SetupContext originalContext;
    private boolean save = true;
    private boolean defaultsSet;
    private UserCallback userCallback;
    private final Validator validator = new Validator();
    private FocusListener focusListener = new FocusAdapter(){

        public void focusGained(FocusEvent e) {
            VariablePage.this.focusControl = (Control)e.widget;
        }
    };
    private SetupWizardPage.PerformerCreationJob performerCreationJob;
    private long delay;

    public VariablePage() {
        super("VariablePage");
        this.setTitle(Messages.VariablePage_title);
        this.setDescription(BASIC_DESCRIPTION);
    }

    @Override
    protected Control createUI(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        mainComposite.setLayout((Layout)UIUtil.createGridLayout((int)1));
        mainComposite.setLayoutData((Object)new GridData(1808));
        GridLayout outerLayout = (GridLayout)parent.getParent().getLayout();
        outerLayout.marginLeft = outerLayout.marginWidth;
        outerLayout.marginWidth = 0;
        this.scrolledComposite = new ScrolledComposite(mainComposite, 512);
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        this.scrolledComposite.setShowFocusedControl(true);
        this.scrolledComposite.setLayoutData((Object)new GridData(1808));
        GridLayout layout = UIUtil.createGridLayout((int)3);
        layout.horizontalSpacing = 10;
        layout.verticalSpacing = 10;
        layout.marginRight = outerLayout.marginLeft;
        this.composite = new Composite((Composite)this.scrolledComposite, 0);
        this.composite.setLayout((Layout)layout);
        this.scrolledComposite.setContent((Control)this.composite);
        this.composite.setLayoutData((Object)new GridData(1808));
        ControlAdapter resizeListener = new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                Point size = VariablePage.this.composite.computeSize(VariablePage.this.scrolledComposite.getClientArea().width, -1);
                VariablePage.this.scrolledComposite.setMinSize(size);
            }
        };
        this.scrolledComposite.addControlListener((ControlListener)resizeListener);
        this.composite.addControlListener((ControlListener)resizeListener);
        this.composite.notifyListeners(11, new Event());
        return mainComposite;
    }

    @Override
    protected void createCheckButtons(ButtonBar buttonBar) {
        final Button fullPromptButton = buttonBar.addCheckButton(Messages.VariablePage_fullPromptButton_text, "", false, "fullPrompt");
        this.fullPrompt = fullPromptButton.getSelection();
        fullPromptButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VariablePage.this.fullPrompt = fullPromptButton.getSelection();
                VariablePage.this.validator.schedule(false);
            }
        });
        AccessUtil.setKey((Widget)fullPromptButton, (Object)"showAll");
    }

    private synchronized boolean updateFields() {
        this.unusedVariables.clear();
        for (FieldHolder fieldHolder : this.manager) {
            fieldHolder.clear();
        }
        LinkedHashSet<SetupTaskPerformer> performers = new LinkedHashSet<SetupTaskPerformer>();
        if (this.incompletePerformers.isEmpty()) {
            if (this.performer != null) {
                performers.add(this.performer);
            }
            performers.addAll(this.allPromptedPerfomers);
        } else {
            performers.addAll(this.incompletePerformers);
            performers.addAll(this.allPromptedPerfomers);
        }
        HashSet usedVariables = new HashSet();
        for (FieldHolder fieldHolder : this.manager) {
            String value = fieldHolder.getValue();
            if (StringUtil.isEmpty((String)value)) continue;
            usedVariables.addAll(SetupTaskPerformer.getVariables((String)value));
        }
        for (SetupTaskPerformer setupTaskPerformer : performers) {
            Iterator<FieldHolder> variables = setupTaskPerformer.getUnresolvedVariables();
            Iterator iterator = variables.iterator();
            while (iterator.hasNext()) {
                VariableTask variable = (VariableTask)iterator.next();
                VariableTask ruleVariable = setupTaskPerformer.getRuleVariable(variable);
                if (ruleVariable == null) {
                    String name;
                    if (variable.getAnnotation("http://www.eclipse.org/oomph/setup/UndeclaredVariable") != null && !usedVariables.contains(name = variable.getName())) {
                        Trigger trigger = this.getTrigger();
                        boolean isUsedInActualTriggeredTask = false;
                        for (Iterator setupTask : setupTaskPerformer.getTriggeredSetupTasks()) {
                            if (!setupTask.getTriggers().contains(trigger) || !SetupTaskPerformer.isVariableUsed((String)name, (EObject)setupTask, (boolean)true)) continue;
                            isUsedInActualTriggeredTask = true;
                            break;
                        }
                        if (!isUsedInActualTriggeredTask) {
                            this.unusedVariables.add(name);
                            continue;
                        }
                    }
                    this.manager.getFieldHolder(variable, true, false);
                    continue;
                }
                FieldHolder fieldHolder = this.manager.getFieldHolder(ruleVariable, true, false);
                fieldHolder.add(variable);
                this.manager.associate(variable, fieldHolder);
            }
        }
        boolean setDefault = false;
        for (FieldHolder fieldHolder : this.manager) {
            if (!StringUtil.isEmpty((String)fieldHolder.getValue())) continue;
            Object initialValue = null;
            String initialDefaultValue = null;
            for (VariableTask variable : fieldHolder.getVariables()) {
                String defaultValue;
                String value;
                if (initialValue == null && !StringUtil.isEmpty((String)(value = variable.getValue()))) {
                    initialValue = value;
                    for (VariableChoice choice : variable.getChoices()) {
                        String choiceValue;
                        Annotation annotation = choice.getAnnotation("http://www.eclipse.org/oomph/setup/MatchChoice");
                        if (annotation == null || (choiceValue = choice.getValue()) == null) continue;
                        StringBuffer result = new StringBuffer("\\Q");
                        Matcher matcher = StringExpander.STRING_EXPANSION_PATTERN.matcher(choiceValue);
                        while (matcher.find()) {
                            matcher.appendReplacement(result, "\\\\E.*\\\\Q");
                        }
                        matcher.appendTail(result);
                        try {
                            Pattern pattern = Pattern.compile(result.toString());
                            if (!pattern.matcher(value).matches()) continue;
                            initialValue = choiceValue;
                            setDefault = true;
                            break;
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
                if (initialDefaultValue != null || StringUtil.isEmpty((String)(defaultValue = variable.getDefaultValue()))) continue;
                initialDefaultValue = defaultValue;
            }
            if (!StringUtil.isEmpty(initialValue)) {
                fieldHolder.setValue((String)initialValue);
                continue;
            }
            if (!StringUtil.isEmpty(initialDefaultValue)) {
                setDefault = true;
                fieldHolder.setValue(initialDefaultValue);
                continue;
            }
            String defaultValue = fieldHolder.getDefaultValue();
            if (StringUtil.isEmpty((String)defaultValue)) continue;
            setDefault = true;
            fieldHolder.setValue(defaultValue);
        }
        try {
            for (FieldHolder fieldHolder : this.manager) {
                this.updating = true;
                fieldHolder.update();
            }
        }
        finally {
            this.updating = false;
        }
        for (FieldHolder fieldHolder : this.manager) {
            fieldHolder.recordInitialValue();
        }
        HashSet<URI> uris = new HashSet<URI>();
        if (this.performer != null) {
            for (VariableTask variable : this.performer.getUnresolvedVariables()) {
                uris.add(this.manager.getURI(variable));
                VariableTask ruleVariable = this.performer.getRuleVariable(variable);
                if (ruleVariable == null) continue;
                uris.add(this.manager.getURI(ruleVariable));
            }
        }
        this.manager.cleanup(uris);
        ScrolledComposite parent = (ScrolledComposite)this.composite.getParent();
        Point origin = parent.getOrigin();
        parent.setRedraw(false);
        ArrayList<SetupTaskPerformer> allPerformers = new ArrayList<SetupTaskPerformer>(this.allPromptedPerfomers);
        if (this.performer != null) {
            allPerformers.add(0, this.performer);
        }
        this.manager.reorder(allPerformers);
        parent.pack();
        parent.getParent().layout();
        parent.setOrigin(origin);
        parent.setRedraw(true);
        FieldHolder firstField = null;
        FieldHolder firstEmptyField = null;
        for (FieldHolder fieldHolder : this.manager) {
            if (fieldHolder.isDisposed()) continue;
            if (firstField == null) {
                firstField = fieldHolder;
            }
            if (firstEmptyField != null || !StringUtil.isEmpty((String)fieldHolder.getValue())) continue;
            firstEmptyField = fieldHolder;
        }
        if (this.focusControl != null && !this.focusControl.isDisposed()) {
            this.focusControl.setFocus();
            parent.showControl(this.focusControl);
        } else {
            FieldHolder field = firstEmptyField;
            if (field == null) {
                field = firstField;
            }
            if (field != null) {
                field.setFocus();
                parent.showControl(field.getControl());
            }
        }
        for (FieldHolder fieldHolder : this.manager) {
            EAttribute eAttribute;
            if (fieldHolder.isDisposed()) continue;
            Control control = fieldHolder.getControl();
            PropertyField field = fieldHolder.field;
            Label label = field.getLabel();
            Control helper = field.getHelper();
            Iterator<VariableTask> iterator = fieldHolder.getVariables().iterator();
            if (!iterator.hasNext()) continue;
            VariableTask variable = iterator.next();
            Object name = variable.getName();
            if (((String)name).startsWith("@<id>") && (eAttribute = SetupTaskPerformer.getAttributeRuleVariableData((VariableTask)variable)) != null) {
                EClass eContainingClass = eAttribute.getEContainingClass();
                name = eContainingClass.getEPackage().getName() + "." + eContainingClass.getName() + "." + eAttribute.getName();
            }
            AccessUtil.setKey((Widget)label, (Object)((String)name + ".label"));
            AccessUtil.setKey((Widget)control, (Object)((String)name + ".control"));
            AccessUtil.setKey((Widget)helper, (Object)((String)name + ".helper"));
        }
        if (setDefault) {
            this.defaultsSet = true;
        }
        boolean hasFilterProperties = false;
        for (FieldHolder fieldHolder : this.manager) {
            if (!fieldHolder.isFilterProperty()) continue;
            hasFilterProperties = true;
            break;
        }
        this.setDescription(hasFilterProperties ? AUGMENTED_DESCRIPTION : BASIC_DESCRIPTION);
        return this.isPageComplete() ? setDefault : firstEmptyField == null || setDefault;
    }

    private void validate() {
        try {
            this.performer = null;
            this.incompletePerformers.clear();
            this.allPromptedPerfomers.clear();
            this.setButtonState(15, false);
            this.performerCreationJob = new SetupWizardPage.PerformerCreationJob(this, Messages.VariablePage_setupTaskAnalysis_title){

                @Override
                protected SetupTaskPerformer createPerformer() throws Exception {
                    return VariablePage.this.createPerformer(VariablePage.this, VariablePage.this.fullPrompt);
                }

                @Override
                protected Dialog createDialog() {
                    return this.createDialog(VariablePage.this.getShell(), Messages.VariablePage_setupTaskAnalysis_title, null, NLS.bind((String)Messages.VariablePage_setupTaskAnalysis_message, (Object)((System.currentTimeMillis() - this.getStart()) / 1000L)), 2, new String[]{IDialogConstants.OK_LABEL}, 0);
                }

                @Override
                protected void handleDialogResult(int result) {
                    if (result == 0) {
                        this.setDelay(Integer.MAX_VALUE);
                    } else {
                        this.setDelay(2L * this.getDelay());
                    }
                }
            };
            if (this.delay != 0L) {
                this.performerCreationJob.setDelay(this.delay);
            }
            this.performerCreationJob.create();
            this.delay = this.performerCreationJob.getDelay();
            Throwable throwable = this.performerCreationJob.getThrowable();
            if (throwable != null) {
                if (throwable instanceof OperationCanceledException) {
                    this.performerCreationJob = null;
                    return;
                }
                throw throwable;
            }
            this.performer = this.performerCreationJob.getPerformer();
            UIUtil.asyncExec((Control)this.getControl(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    VariablePage.this.performerCreationJob = null;
                    if (VariablePage.this.updateFields()) {
                        VariablePage.this.validate();
                    }
                }
            });
            if (this.performer == null) {
                this.setPageComplete(false);
            } else {
                this.setPageComplete(true);
                if (!this.prompted) {
                    this.prompted = true;
                    this.gotoNextPage();
                }
            }
        }
        catch (Throwable t) {
            this.performerCreationJob = null;
            SetupUIPlugin.INSTANCE.log(t);
            ErrorDialog.open((Throwable)t);
        }
    }

    private void clearSpecialFieldHolders() {
        this.clearSpecialFieldHolders(INSTALLATION_ID_URI);
        this.clearSpecialFieldHolders(WORKSPACE_ID_URI);
    }

    private void clearSpecialFieldHolders(URI uri) {
        FieldHolder fieldHolder;
        FieldHolderRecord fieldHolderRecord = this.manager.getFieldHolderRecord(uri);
        if (fieldHolderRecord != null && (fieldHolder = fieldHolderRecord.getFieldHolder()) != null && !fieldHolder.isDirty()) {
            fieldHolder.clearValue();
        }
    }

    @Override
    public void enterPage(boolean forward) {
        if (forward) {
            if (this.userCallback == null) {
                Shell shell = this.getShell();
                this.userCallback = new UICallback(shell, shell.getText());
            }
            this.clearSpecialFieldHolders();
        }
        this.performer = this.getWizard().getPerformer();
        if (this.performer != null && forward) {
            this.performer.setPrompter((SetupPrompter)this);
            this.setPageComplete(true);
            this.gotoNextPage();
        } else {
            SetupWizard.IndexLoader indexLoader;
            if (!forward) {
                this.getWizard().setSetupContext(this.originalContext);
                this.originalContext = null;
            }
            if ((indexLoader = this.getWizard().getIndexLoader()) != null) {
                indexLoader.awaitIndexLoad();
            }
            this.setPageComplete(false);
            this.validate();
            if (forward && this.getPreviousPage() == null) {
                UIUtil.asyncExec((Control)this.getControl(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (VariablePage.this.isPageComplete() && !VariablePage.this.defaultsSet) {
                            VariablePage.this.gotoNextPage();
                        }
                    }
                });
            }
        }
    }

    @Override
    public void leavePage(boolean forward) {
        if (forward) {
            this.originalContext = this.getWizard().getSetupContext();
            List unresolvedVariables = this.performer.getUnresolvedVariables();
            for (FieldHolder fieldHolder : this.manager) {
                unresolvedVariables.addAll(fieldHolder.getVariables());
            }
            ResourceSet resourceSet = SetupCoreUtil.createResourceSet();
            User user = this.getUser();
            User copiedUser = (User)EcoreUtil.copy((EObject)user);
            URI userResourceURI = user.eResource().getURI();
            Resource userResource = resourceSet.createResource(userResourceURI);
            userResource.getContents().add((Object)copiedUser);
            Installation installation = this.performer.getInstallation();
            Resource installationResource = installation.eResource();
            URI installationResourceURI = installationResource.getURI();
            installationResource.setURI(URI.createFileURI((String)new File(this.performer.getProductConfigurationLocation(), "org.eclipse.oomph.setup/installation.setup").toString()));
            Workspace workspace = this.performer.getWorkspace();
            Resource workspaceResource = null;
            URI workspaceResourceURI = null;
            if (workspace != null) {
                workspaceResource = workspace.eResource();
                workspaceResourceURI = workspaceResource.getURI();
                workspaceResource.setURI(URI.createFileURI((String)new File(this.performer.getWorkspaceLocation(), ".metadata/.plugins/org.eclipse.oomph.setup/workspace.setup").toString()));
            }
            Installation copiedInstallation = (Installation)EcoreUtil.copy((EObject)installation);
            URI copiedInstallationResourceURI = installation.eResource().getURI();
            Resource copiedInstallationResource = resourceSet.createResource(copiedInstallationResourceURI);
            copiedInstallationResource.getContents().add((Object)copiedInstallation);
            Workspace copiedWorkspace = (Workspace)EcoreUtil.copy((EObject)workspace);
            if (workspace != null) {
                URI copiedWorkspaceResourceURI = workspace.eResource().getURI();
                Resource copiedWorkspaceResource = resourceSet.createResource(copiedWorkspaceResourceURI);
                copiedWorkspaceResource.getContents().add((Object)copiedWorkspace);
            }
            this.performer.recordVariables(copiedInstallation, copiedWorkspace, copiedUser);
            unresolvedVariables.clear();
            this.getWizard().setSetupContext(SetupContext.create((Installation)copiedInstallation, (Workspace)copiedWorkspace, (User)copiedUser));
            this.setPerformer(this.performer);
            if (this.save) {
                BaseUtil.saveEObject((EObject)copiedUser);
                this.performer.savePasswords();
            }
            installationResource.setURI(installationResourceURI);
            if (workspaceResource != null) {
                workspaceResource.setURI(workspaceResourceURI);
            }
        } else {
            this.originalContext = null;
            this.setPerformer(null);
            this.validator.cancel();
        }
    }

    public synchronized String getValue(VariableTask variable) {
        String value;
        FieldHolder fieldHolder = this.manager.getFieldHolder(variable, false, true);
        if (fieldHolder != null && (this.updating || fieldHolder.isDirty()) && !"".equals(value = fieldHolder.getValue())) {
            return value;
        }
        if (this.updating && this.performer != null && (value = this.performer.getMap().get(variable.getName())) != null) {
            return value.toString();
        }
        return null;
    }

    public OS getOS() {
        return this.getWizard().getOS();
    }

    public String getVMPath() {
        return this.getWizard().getVMPath();
    }

    public synchronized boolean promptVariables(List<? extends SetupTaskContext> contexts) {
        this.prompted = true;
        List<? extends SetupTaskContext> performers = contexts;
        this.allPromptedPerfomers.addAll(performers);
        for (SetupTaskPerformer setupTaskPerformer : performers) {
            boolean resolvedAll = true;
            List unresolvedVariables = setupTaskPerformer.getUnresolvedVariables();
            for (VariableTask variable : unresolvedVariables) {
                FieldHolder fieldHolder = this.manager.getFieldHolder(variable, false, true);
                if (fieldHolder != null) {
                    String value = fieldHolder.getValue();
                    if (!"".equals(value)) {
                        variable.setValue(value);
                        continue;
                    }
                    resolvedAll = false;
                    continue;
                }
                if (this.unusedVariables.contains(variable.getName())) {
                    variable.setValue(" ");
                    continue;
                }
                resolvedAll = false;
            }
            if (resolvedAll) continue;
            this.incompletePerformers.add(setupTaskPerformer);
        }
        boolean bl = this.incompletePerformers.isEmpty();
        return bl;
    }

    public UserCallback getUserCallback() {
        return this.userCallback;
    }

    private final class FieldHolder
    implements PropertyField.ValueListener {
        private final Set<VariableTask> variables = new LinkedHashSet<VariableTask>();
        private final List<String> choiceLabels = new ArrayList<String>();
        private PropertyField field;
        private String initialValue;
        private boolean filterProperty;

        public FieldHolder(VariableTask variable) {
            this.init(variable);
            this.variables.add(variable);
        }

        public OS getOS() {
            return VariablePage.this.getWizard().getOS();
        }

        protected void init(VariableTask variable) {
            this.field = PropertyField.createField(variable);
            this.field.setOS(this.getOS());
            this.field.fill(VariablePage.this.composite);
            this.field.addValueListener(this);
            this.field.getControl().addFocusListener(VariablePage.this.focusListener);
            this.choiceLabels.addAll(this.getChoiceLabels(variable));
        }

        protected List<String> getChoiceLabels(VariableTask variable) {
            ArrayList<String> result = new ArrayList<String>();
            for (VariableChoice choice : variable.getChoices()) {
                String label = choice.getLabel();
                result.add(label);
            }
            return result;
        }

        public boolean isDisposed() {
            return this.field == null;
        }

        private Control getControl() {
            if (this.field == null) {
                return null;
            }
            Control control = this.field.getControl();
            Composite parent = control.getParent();
            if (parent == VariablePage.this.composite) {
                return control;
            }
            return null;
        }

        public void setFocus() {
            if (this.field == null) {
                throw new IllegalStateException("Can't set the value of a disposed field");
            }
            this.field.setFocus();
        }

        public String getValue() {
            return this.field == null ? this.initialValue : this.field.getValue();
        }

        public String getDefaultValue() {
            return this.field == null ? null : this.field.getDefaultValue();
        }

        public void clearValue() {
            this.initialValue = "";
            if (this.field != null) {
                this.field.setValue("", false, false);
            }
        }

        public void setValue(String value) {
            if (this.field == null) {
                throw new IllegalStateException("Can't set the value of a disposed field");
            }
            this.initialValue = null;
            this.field.setValue(value, false);
        }

        public Set<VariableTask> getVariables() {
            return Collections.unmodifiableSet(this.variables);
        }

        public void clear() {
            this.variables.clear();
            if (this.field instanceof PropertyField.AuthenticatedField) {
                PropertyField.AuthenticatedField authenticatedField = (PropertyField.AuthenticatedField)this.field;
                authenticatedField.clear();
            }
        }

        public void add(VariableTask variable) {
            if (this.variables.add(variable)) {
                String value;
                if (!this.isDirty() && !variable.getChoices().isEmpty() && variable.getType() == VariableType.JRE ? this.choiceLabels.isEmpty() : this.variables.size() == 1 && !this.getChoiceLabels(variable).isEmpty() && !this.choiceLabels.equals(this.getChoiceLabels(variable))) {
                    this.dispose();
                    this.initialValue = null;
                    this.choiceLabels.clear();
                    this.init(variable);
                    if (variable.getType() != VariableType.JRE) {
                        variable.setValue(((VariableChoice)variable.getChoices().get(0)).getValue());
                    }
                }
                if (!"".equals(value = this.field.getValue())) {
                    variable.setValue(value);
                }
            }
        }

        public void setFilterProperty(boolean filterProperty) {
            this.filterProperty = filterProperty;
            if (this.field != null) {
                this.field.setBold(filterProperty);
            }
        }

        public boolean isFilterProperty() {
            return this.filterProperty;
        }

        public void update() {
            if (this.field instanceof PropertyField.AuthenticatedField) {
                PropertyField.AuthenticatedField authenticatedField = (PropertyField.AuthenticatedField)this.field;
                String value = this.field.getValue();
                LinkedHashSet allAuthenticators = new LinkedHashSet();
                for (VariableTask variable : this.variables) {
                    Set authenticators;
                    if (!StringUtil.isEmpty((String)value)) {
                        variable.setValue(value);
                    }
                    if ((authenticators = SetupTaskPerformer.getAuthenticators((VariableTask)variable)) == null) continue;
                    allAuthenticators.addAll(authenticators);
                }
                if (!allAuthenticators.isEmpty()) {
                    Iterator it = allAuthenticators.iterator();
                    while (it.hasNext()) {
                        Authenticator authenticator = (Authenticator)it.next();
                        if (!authenticator.isFiltered()) continue;
                        it.remove();
                    }
                    authenticatedField.addAll(allAuthenticators);
                    if (allAuthenticators.isEmpty()) {
                        this.dispose(PreferencesUtil.encrypt((String)" "));
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void valueChanged(String oldValue, String newValue) throws Exception {
            VariablePage variablePage = VariablePage.this;
            synchronized (variablePage) {
                for (VariableTask variable : this.variables) {
                    variable.setValue(newValue);
                }
            }
            VariablePage.this.validator.schedule(true);
        }

        public void recordInitialValue() {
            if (this.initialValue == null && this.field != null) {
                this.initialValue = this.field.getValue();
            }
        }

        public boolean isDirty() {
            return this.field != null && this.initialValue != null && !this.initialValue.equals(this.field.getValue());
        }

        public void dispose(String value) {
            if (this.field != null) {
                this.field.dispose();
                this.field = null;
            }
            if (StringUtil.isEmpty((String)this.initialValue)) {
                this.initialValue = value;
            }
        }

        public void dispose() {
            if (this.field != null) {
                this.field.dispose();
                this.field = null;
            }
        }

        public String toString() {
            return this.field == null ? "<disposed>" : this.field.toString();
        }
    }

    private class FieldHolderManager
    implements Iterable<FieldHolder> {
        private final EList<FieldHolderRecord> fields = new BasicEList();

        private FieldHolderManager() {
        }

        @Override
        public Iterator<FieldHolder> iterator() {
            final Iterator iterator = this.fields.iterator();
            return new Iterator<FieldHolder>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public FieldHolder next() {
                    return ((FieldHolderRecord)iterator.next()).getFieldHolder();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public void reorder(List<SetupTaskPerformer> allPerformers) {
            int size;
            ArrayList<Control> controls = new ArrayList<Control>();
            LinkedHashMap ruleUses = new LinkedHashMap();
            block0: for (FieldHolderRecord fieldHolderRecord : this.fields) {
                FieldHolder fieldHolder = fieldHolderRecord.getFieldHolder();
                Control control = fieldHolder.getControl();
                if (control == null) continue;
                controls.add(control);
                for (VariableTask variable : fieldHolder.getVariables()) {
                    EAttribute eAttribute = SetupTaskPerformer.getAttributeRuleVariableData((VariableTask)variable);
                    if (eAttribute == null) continue;
                    CollectionUtil.addAll(ruleUses, (Object)fieldHolderRecord, Collections.emptySet());
                    continue block0;
                }
                for (VariableTask variable : fieldHolder.getVariables()) {
                    VariableTask dependantVariable = SetupTaskPerformer.getRuleVariableData((VariableTask)variable);
                    if (dependantVariable == null) continue;
                    for (SetupTaskPerformer performer : allPerformers) {
                        FieldHolderRecord dependantFieldHolderRecord;
                        VariableTask ruleVariable = performer.getRuleVariable(dependantVariable);
                        if (ruleVariable == null || (dependantFieldHolderRecord = this.getFieldHolderRecord(this.getURI(ruleVariable))) == null) continue;
                        CollectionUtil.add(ruleUses, (Object)dependantFieldHolderRecord, (Object)fieldHolderRecord);
                        continue block0;
                    }
                }
            }
            int fieldsSize = this.fields.size();
            if (fieldsSize > 1) {
                int index = 0;
                int maxPosition = fieldsSize - 1;
                for (Map.Entry entry : ruleUses.entrySet()) {
                    FieldHolderRecord fieldHolderRecord = (FieldHolderRecord)entry.getKey();
                    this.fields.move(index++, (Object)fieldHolderRecord);
                    Set fieldHolderRecords = (Set)entry.getValue();
                    Iterator<Object> iterator = fieldHolderRecords.iterator();
                    while (iterator.hasNext()) {
                        FieldHolderRecord dependantFieldHolderRecord = (FieldHolderRecord)iterator.next();
                        this.fields.move(Math.min(index++, maxPosition), (Object)dependantFieldHolderRecord);
                    }
                }
                int i = 0;
                while (i < this.fields.size()) {
                    FieldHolderRecord fieldHolderRecord = (FieldHolderRecord)this.fields.get(i);
                    for (VariableTask variable : fieldHolderRecord.getFieldHolder().getVariables()) {
                        boolean isFilterProperty = false;
                        for (SetupTaskPerformer performer : allPerformers) {
                            if (!performer.isFilterProperty(variable)) continue;
                            isFilterProperty = true;
                            break;
                        }
                        fieldHolderRecord.getFieldHolder().setFilterProperty(isFilterProperty);
                    }
                    ++i;
                }
            }
            if ((size = controls.size()) > 1) {
                List<Control> children = Arrays.asList(VariablePage.this.composite.getChildren());
                int controlOffset = 0;
                for (Control child : children) {
                    if (controls.contains(child)) break;
                    ++controlOffset;
                }
                Control target = children.get(2);
                int count = 0;
                for (FieldHolder fieldHolder : this) {
                    Control control = fieldHolder.getControl();
                    if (control == null) continue;
                    int index = children.indexOf(control) - controlOffset;
                    Control newTarget = null;
                    int j = 2;
                    while (j >= 0) {
                        Control child = children.get(index + j);
                        if (newTarget == null) {
                            newTarget = child;
                            if (index == count) break;
                        }
                        child.moveBelow(target);
                        --j;
                    }
                    target = newTarget;
                    count += 3;
                }
            }
        }

        public void cleanup(Set<URI> uris) {
            block0: for (FieldHolderRecord fieldHolderRecord : this.fields) {
                for (URI uri : fieldHolderRecord.getVariableURIs()) {
                    if (uris.contains(uri)) continue block0;
                }
                FieldHolder fieldHolder = fieldHolderRecord.getFieldHolder();
                if (!fieldHolder.getVariables().isEmpty() || fieldHolder.isDirty()) continue;
                fieldHolder.dispose();
            }
        }

        public URI getURI(VariableTask variable) {
            EObject eObject;
            String name = variable.getName();
            if (variable.getAnnotation("http://www.eclipse.org/oomph/setup/GlobalVariable") != null) {
                return URI.createURI((String)("#" + name));
            }
            Resource resource = variable.eResource();
            URI uri = resource == null ? URI.createURI((String)"#") : ((eObject = (EObject)resource.getContents().get(0)) instanceof Installation || eObject instanceof Workspace ? URI.createURI((String)resource.getURI().lastSegment()).appendFragment(resource.getURIFragment((EObject)variable)) : EcoreUtil.getURI((EObject)variable));
            uri = uri.appendFragment(uri.fragment() + "~" + name);
            return uri;
        }

        private FieldHolderRecord getFieldHolderRecord(URI uri) {
            for (FieldHolderRecord fieldHolderRecord : this.fields) {
                if (!fieldHolderRecord.getVariableURIs().contains(uri)) continue;
                return fieldHolderRecord;
            }
            return null;
        }

        public void associate(VariableTask variable, FieldHolder fieldHolder) {
            URI uri = this.getURI(variable);
            for (FieldHolderRecord fieldHolderRecord : this.fields) {
                if (fieldHolderRecord.getFieldHolder() != fieldHolder) continue;
                fieldHolderRecord.getVariableURIs().add(uri);
                break;
            }
        }

        public FieldHolder getFieldHolder(VariableTask variable, boolean demandCreate, boolean includeDisposed) {
            URI uri = this.getURI(variable);
            FieldHolderRecord fieldHolderRecord = this.getFieldHolderRecord(uri);
            FieldHolder fieldHolder = null;
            if (fieldHolderRecord == null) {
                if (!demandCreate) {
                    return null;
                }
                fieldHolderRecord = new FieldHolderRecord();
                fieldHolderRecord.getVariableURIs().add(uri);
                this.fields.add((Object)fieldHolderRecord);
            } else {
                fieldHolder = fieldHolderRecord.getFieldHolder();
                if (fieldHolder.isDisposed()) {
                    if (includeDisposed) {
                        return fieldHolder;
                    }
                    if (!demandCreate) {
                        return null;
                    }
                    fieldHolder = null;
                }
            }
            if (fieldHolder == null) {
                fieldHolder = new FieldHolder(variable);
                fieldHolderRecord.setFieldHolder(fieldHolder);
            } else if (!VariablePage.this.updating) {
                fieldHolder.add(variable);
            }
            return fieldHolder;
        }

        public String toString() {
            return this.fields.toString();
        }
    }

    private static class FieldHolderRecord {
        private FieldHolder fieldHolder;
        private final Set<URI> variableURIs = new HashSet<URI>();

        public FieldHolder getFieldHolder() {
            return this.fieldHolder;
        }

        public void setFieldHolder(FieldHolder fieldHolder) {
            this.fieldHolder = fieldHolder;
        }

        public Set<URI> getVariableURIs() {
            return this.variableURIs;
        }

        public String toString() {
            return this.variableURIs.toString();
        }
    }

    private class Validator
    implements Runnable {
        private boolean canceled;
        private boolean dispatched;
        private boolean redispatch;
        private boolean clearSpecialFieldHolders;

        private Validator() {
        }

        @Override
        public void run() {
            if (!this.canceled && !VariablePage.this.getShell().isDisposed()) {
                this.dispatched = false;
                if (this.redispatch || VariablePage.this.performerCreationJob != null) {
                    if (VariablePage.this.performerCreationJob != null) {
                        VariablePage.this.performerCreationJob.cancel();
                    }
                    this.schedule(this.clearSpecialFieldHolders);
                } else {
                    if (this.clearSpecialFieldHolders) {
                        VariablePage.this.clearSpecialFieldHolders();
                        this.clearSpecialFieldHolders = false;
                    }
                    VariablePage.this.validate();
                }
            }
        }

        public void schedule(boolean clearSpecialFieldHolders) {
            this.canceled = false;
            if (clearSpecialFieldHolders) {
                this.clearSpecialFieldHolders = true;
            }
            if (this.dispatched) {
                this.redispatch = true;
            } else {
                this.dispatched = true;
                this.redispatch = false;
                UIUtil.timerExec((int)350, (Runnable)this);
            }
        }

        public void cancel() {
            this.canceled = true;
            this.dispatched = false;
            this.redispatch = false;
            this.clearSpecialFieldHolders = false;
            if (VariablePage.this.performerCreationJob != null) {
                VariablePage.this.performerCreationJob.cancel();
            }
        }
    }
}

