/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.jarprocessor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.eclipse.equinox.internal.p2.jarprocessor.Utils;
import org.eclipse.internal.provisional.equinox.p2.jarprocessor.JarProcessor;
import org.eclipse.internal.provisional.equinox.p2.jarprocessor.JarProcessorExecutor;

public class ZipProcessor {
    private JarProcessorExecutor executor = null;
    private JarProcessorExecutor.Options options = null;
    private String workingDirectory = null;
    private Properties properties = null;
    private Set<String> signExclusions = null;

    public void setExecutor(JarProcessorExecutor executor) {
        this.executor = executor;
    }

    public void setOptions(JarProcessorExecutor.Options options) {
        this.options = options;
    }

    public void setWorkingDirectory(String dir) {
        this.workingDirectory = dir;
    }

    public String getWorkingDirectory() {
        if (this.workingDirectory == null) {
            this.workingDirectory = ".";
        }
        return this.workingDirectory;
    }

    public void processZip(File zipFile) throws ZipException, IOException {
        if (this.options.verbose) {
            System.out.println("Processing " + zipFile.getPath());
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (ZipFile zip = new ZipFile(zipFile);){
            File outputFile;
            File tempDir;
            block39: {
                this.initialize(zip);
                String extension = ".jar";
                tempDir = new File(this.getWorkingDirectory(), "temp_" + zipFile.getName());
                JarProcessor processor = new JarProcessor();
                processor.setVerbose(this.options.verbose);
                processor.setProcessAll(this.options.processAll);
                processor.setWorkingDirectory(tempDir.getCanonicalPath());
                outputFile = new File(this.getWorkingDirectory(), zipFile.getName() + ".temp");
                File parent = outputFile.getParentFile();
                if (!parent.exists()) {
                    parent.mkdirs();
                }
                Throwable throwable2 = null;
                Object var11_14 = null;
                try (ZipOutputStream zipOut = new ZipOutputStream(new FileOutputStream(outputFile));){
                    Enumeration<? extends ZipEntry> entries = zip.entries();
                    if (!entries.hasMoreElements()) break block39;
                    ZipEntry entry = entries.nextElement();
                    while (entry != null) {
                        String name = entry.getName();
                        InputStream entryStream = zip.getInputStream(entry);
                        boolean sign = this.options.signCommand != null && !this.signExclusions.contains(name);
                        File extractedFile = null;
                        if (entry.getName().endsWith(extension) && sign) {
                            extractedFile = ZipProcessor.createSubPathFile(tempDir, name);
                            parent = extractedFile.getParentFile();
                            if (!parent.exists()) {
                                parent.mkdirs();
                            }
                            if (this.options.verbose) {
                                System.out.println("Extracting " + entry.getName());
                            }
                            FileOutputStream extracted = new FileOutputStream(extractedFile);
                            Utils.transferStreams(entryStream, extracted, true);
                            entryStream = null;
                            boolean skip = Utils.shouldSkipJar(extractedFile, this.options.processAll, this.options.verbose);
                            if (skip) {
                                entryStream = new FileInputStream(extractedFile);
                                if (this.options.verbose) {
                                    System.out.println(entry.getName() + " is not marked, skipping.");
                                }
                            } else {
                                block40: {
                                    if (sign) {
                                        processor.clearProcessSteps();
                                        if (sign) {
                                            this.executor.addSignStep(processor, this.properties, this.options);
                                        }
                                        extractedFile = processor.processJar(extractedFile);
                                    }
                                    if (extractedFile.exists()) {
                                        try {
                                            entryStream = new FileInputStream(extractedFile);
                                        }
                                        catch (IOException e) {
                                            if (!this.options.verbose) break block40;
                                            e.printStackTrace();
                                            System.out.println("Warning: Problem reading " + extractedFile.getPath() + ".");
                                        }
                                    }
                                }
                                if (this.options.verbose && entryStream != null) {
                                    System.out.println("Adding " + name + " to " + outputFile.getPath());
                                }
                            }
                        }
                        if (entryStream != null) {
                            block41: {
                                ZipEntry newEntry = new ZipEntry(name);
                                try {
                                    zipOut.putNextEntry(newEntry);
                                    Utils.transferStreams(entryStream, zipOut, false);
                                    zipOut.closeEntry();
                                }
                                catch (ZipException e) {
                                    if (!this.options.verbose) break block41;
                                    System.out.println("Warning: " + name + " already exists in " + outputFile.getName() + ".  Skipping.");
                                }
                            }
                            entryStream.close();
                        }
                        if (extractedFile != null) {
                            Utils.clear(extractedFile);
                        }
                        if (this.options.verbose) {
                            System.out.println();
                            System.out.println("Processing " + zipFile.getPath());
                        }
                        ZipEntry zipEntry = entry = entries.hasMoreElements() ? entries.nextElement() : null;
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            File finalFile = new File(this.getWorkingDirectory(), zipFile.getName());
            if (finalFile.exists()) {
                finalFile.delete();
            }
            outputFile.renameTo(finalFile);
            Utils.clear(tempDir);
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    public static File createSubPathFile(File root, String subPath) throws IOException {
        String rootCanonical;
        File result = new File(root, subPath);
        String resultCanonical = result.getCanonicalPath();
        if (!resultCanonical.startsWith((rootCanonical = root.getCanonicalPath()) + File.separator) && !resultCanonical.equals(rootCanonical)) {
            throw new IOException("Invalid path: " + subPath);
        }
        return result;
    }

    private void initialize(ZipFile zip) {
        block13: {
            ZipEntry entry = zip.getEntry("pack.properties");
            this.properties = new Properties();
            if (entry != null) {
                try {
                    Throwable throwable = null;
                    Object var4_6 = null;
                    try (InputStream stream = zip.getInputStream(entry);){
                        this.properties.load(stream);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    if (!this.options.verbose) break block13;
                    e.printStackTrace();
                }
            }
        }
        this.signExclusions = Utils.getSignExclusions(this.properties);
        if (this.executor == null) {
            this.executor = new JarProcessorExecutor();
        }
    }
}

