/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.reconciler;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.DirtyRegionQueue;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.ReconcilerJob;

public abstract class AbstractReconciler
implements IReconciler {
    DirtyRegionQueue fDirtyRegionQueue;
    private ReconcilerJob fThread;
    private Listener fListener;
    int fDelay = 500;
    volatile boolean waitFinish;
    private boolean fIsIncrementalReconciler = true;
    private IProgressMonitor fProgressMonitor = new NullProgressMonitor();
    private boolean fIsAllowedToModifyDocument = true;
    private IDocument fDocument;
    private ITextViewer fViewer;

    protected abstract void process(DirtyRegion var1);

    protected abstract void reconcilerDocumentChanged(IDocument var1);

    protected AbstractReconciler() {
    }

    public void setDelay(int delay) {
        this.fDelay = delay;
    }

    public void setIsIncrementalReconciler(boolean isIncremental) {
        this.fIsIncrementalReconciler = isIncremental;
    }

    public void setIsAllowedToModifyDocument(boolean isAllowedToModify) {
        this.fIsAllowedToModifyDocument = isAllowedToModify;
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        Assert.isLegal((monitor != null ? 1 : 0) != 0);
        this.fProgressMonitor = monitor;
    }

    protected boolean isIncrementalReconciler() {
        return this.fIsIncrementalReconciler;
    }

    protected IDocument getDocument() {
        return this.fDocument;
    }

    protected ITextViewer getTextViewer() {
        return this.fViewer;
    }

    protected IProgressMonitor getProgressMonitor() {
        return this.fProgressMonitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void install(ITextViewer textViewer) {
        Assert.isNotNull((Object)textViewer);
        this.fViewer = textViewer;
        AbstractReconciler abstractReconciler = this;
        synchronized (abstractReconciler) {
            if (this.fThread != null) {
                return;
            }
            this.fThread = new ReconcilerJob(this.getClass().getName(), this);
        }
        this.fDirtyRegionQueue = new DirtyRegionQueue();
        this.fListener = new Listener();
        this.fViewer.addTextInputListener(this.fListener);
        IDocument document = textViewer.getDocument();
        if (document != null) {
            this.fListener.inputDocumentAboutToBeChanged(this.fDocument, document);
            this.fListener.inputDocumentChanged(this.fDocument, document);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uninstall() {
        if (this.fListener != null) {
            this.fViewer.removeTextInputListener(this.fListener);
            if (this.fDocument != null) {
                this.fListener.inputDocumentAboutToBeChanged(this.fDocument, null);
                this.fListener.inputDocumentChanged(this.fDocument, null);
            }
            this.fListener = null;
            AbstractReconciler abstractReconciler = this;
            synchronized (abstractReconciler) {
                ReconcilerJob bt = this.fThread;
                this.fThread = null;
                bt.doCancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDirtyRegion(DocumentEvent e) {
        DirtyRegionQueue dirtyRegionQueue = this.fDirtyRegionQueue;
        synchronized (dirtyRegionQueue) {
            if (e.getLength() == 0 && e.getText() != null) {
                this.fDirtyRegionQueue.addDirtyRegion(new DirtyRegion(e.getOffset(), e.getText().length(), "__insert", e.getText()));
            } else if (e.getText() == null || e.getText().isEmpty()) {
                this.fDirtyRegionQueue.addDirtyRegion(new DirtyRegion(e.getOffset(), e.getLength(), "__remove", null));
            } else {
                this.fDirtyRegionQueue.addDirtyRegion(new DirtyRegion(e.getOffset(), e.getLength(), "__remove", null));
                this.fDirtyRegionQueue.addDirtyRegion(new DirtyRegion(e.getOffset(), e.getText().length(), "__insert", e.getText()));
            }
        }
    }

    protected void aboutToBeReconciled() {
    }

    protected void aboutToWork() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalWaitForFinish() {
        DirtyRegionQueue dirtyRegionQueue = this.fDirtyRegionQueue;
        synchronized (dirtyRegionQueue) {
            this.waitFinish = true;
            this.fDirtyRegionQueue.notifyAll();
        }
    }

    void informNotFinished() {
        this.waitFinish = false;
        this.aboutToWork();
    }

    private void aboutToBeReconciledInternal() {
        this.aboutToBeReconciled();
        this.informNotFinished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delay() {
        DirtyRegionQueue dirtyRegionQueue = this.fDirtyRegionQueue;
        synchronized (dirtyRegionQueue) {
            if (this.waitFinish) {
                return;
            }
            try {
                this.fDirtyRegionQueue.wait(this.fDelay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected void initialProcess() {
    }

    protected void forceReconciling() {
        if (this.fDocument != null) {
            if (!this.fThread.isDirty() && this.fThread.isAlive()) {
                this.aboutToBeReconciledInternal();
            }
            if (this.fThread.isActive()) {
                this.fProgressMonitor.setCanceled(true);
            }
            if (this.fIsIncrementalReconciler) {
                DocumentEvent e = new DocumentEvent(this.fDocument, 0, this.fDocument.getLength(), this.fDocument.get());
                this.createDirtyRegion(e);
            }
            this.startReconciling();
        }
    }

    protected synchronized void startReconciling() {
        if (this.fThread == null) {
            return;
        }
        if (!this.fThread.isAlive()) {
            this.fThread.start();
        } else {
            this.fThread.reset();
        }
    }

    protected void reconcilerReset() {
    }

    protected synchronized boolean isRunningInReconcilerThread() {
        if (this.fThread == null) {
            return false;
        }
        return Job.getJobManager().currentJob() == this.fThread;
    }

    class Listener
    implements IDocumentListener,
    ITextInputListener {
        Listener() {
        }

        public void documentAboutToBeChanged(DocumentEvent e) {
        }

        public void documentChanged(DocumentEvent e) {
            if (AbstractReconciler.this.fThread.isActive() || !AbstractReconciler.this.fThread.isDirty() && AbstractReconciler.this.fThread.isAlive()) {
                if (!AbstractReconciler.this.fIsAllowedToModifyDocument && AbstractReconciler.this.isRunningInReconcilerThread()) {
                    throw new UnsupportedOperationException("The reconciler thread is not allowed to modify the document");
                }
                AbstractReconciler.this.aboutToBeReconciledInternal();
            }
            if (AbstractReconciler.this.fThread.isActive() || AbstractReconciler.this.fThread.isDirty() && AbstractReconciler.this.fThread.isAlive()) {
                AbstractReconciler.this.fProgressMonitor.setCanceled(true);
            }
            if (AbstractReconciler.this.fIsIncrementalReconciler) {
                AbstractReconciler.this.createDirtyRegion(e);
            }
            AbstractReconciler.this.fThread.reset();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
            if (oldInput == AbstractReconciler.this.fDocument) {
                if (AbstractReconciler.this.fDocument != null) {
                    AbstractReconciler.this.fDocument.removeDocumentListener((IDocumentListener)this);
                }
                if (AbstractReconciler.this.fIsIncrementalReconciler) {
                    DirtyRegionQueue dirtyRegionQueue = AbstractReconciler.this.fDirtyRegionQueue;
                    synchronized (dirtyRegionQueue) {
                        AbstractReconciler.this.fDirtyRegionQueue.purgeQueue();
                    }
                    if (AbstractReconciler.this.fDocument != null && AbstractReconciler.this.fDocument.getLength() > 0 && AbstractReconciler.this.fThread.isDirty() && AbstractReconciler.this.fThread.isAlive()) {
                        DocumentEvent e = new DocumentEvent(AbstractReconciler.this.fDocument, 0, AbstractReconciler.this.fDocument.getLength(), "");
                        AbstractReconciler.this.createDirtyRegion(e);
                        AbstractReconciler.this.fThread.reset();
                        AbstractReconciler.this.fThread.suspendCallerWhileDirty();
                    }
                }
                AbstractReconciler.this.fDocument = null;
            }
        }

        @Override
        public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
            AbstractReconciler.this.fDocument = newInput;
            if (AbstractReconciler.this.fDocument == null) {
                return;
            }
            AbstractReconciler.this.reconcilerDocumentChanged(AbstractReconciler.this.fDocument);
            AbstractReconciler.this.fDocument.addDocumentListener((IDocumentListener)this);
            if (!AbstractReconciler.this.fThread.isDirty()) {
                AbstractReconciler.this.aboutToBeReconciledInternal();
            }
            AbstractReconciler.this.startReconciling();
        }
    }
}

