/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.emf.xpath.internal.java;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionException;
import javax.xml.xpath.XPathNodes;
import org.eclipse.e4.emf.xpath.XPathContext;
import org.eclipse.e4.emf.xpath.XPathContextFactory;
import org.eclipse.e4.emf.xpath.XPathNotFoundException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.xmi.DOMHandler;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.impl.DefaultDOMHandlerImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIHelperImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLSaveImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JavaXPathContextFactoryImpl<T>
extends XPathContextFactory<T> {
    private static final XPathFactory XPATH_FACTORY = XPathFactory.newInstance();

    @Override
    public XPathContext newContext(T contextBean) {
        return this.newContext(null, contextBean);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public XPathContext newContext(XPathContext parentContext, T contextBean) {
        DOMMapping domMapping;
        XPath xpath;
        if (!(contextBean instanceof EObject)) {
            throw new IllegalArgumentException();
        }
        EObject eObject = (EObject)contextBean;
        Element rootElement = null;
        if (parentContext != null) {
            EObjectContext parent = (EObjectContext)parentContext;
            xpath = parent.xpath;
            rootElement = parent.domMapping.getElement(contextBean);
        } else {
            xpath = XPATH_FACTORY.newXPath();
        }
        if (rootElement != null) {
            domMapping = ((EObjectContext)parentContext).domMapping;
        } else {
            void rootObject;
            DocumentBuilder documentBuilder;
            try {
                documentBuilder = DocumentBuilderFactory.newDefaultInstance().newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new IllegalStateException(e);
            }
            Document document = documentBuilder.newDocument();
            domMapping = new DOMMapping();
            rootElement = JavaXPathContextFactoryImpl.createElement((EObject)rootObject, document, domMapping);
            xpath.setNamespaceContext(JavaXPathContextFactoryImpl.createNamespaceContext(rootElement));
        }
        return new EObjectContext(rootElement, domMapping, xpath);
    }

    private static Element createElement(EObject eObject, Document document, DOMMapping domMapper) {
        new XMLSaveImpl(Map.of(), (XMLHelper)new XMIHelperImpl(), "UTF-8").save(null, document, Map.of("ROOT_OBJECTS", List.of(eObject)), (DOMHandler)domMapper);
        return document.getDocumentElement();
    }

    private static NamespaceContext createNamespaceContext(Element element) {
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:ecore", "http://www.eclipse.org/emf/2002/Ecore");
        NamedNodeMap attributes = element.getAttributes();
        final Map<String, String> xmlnsPrefixMap = IntStream.range(0, attributes.getLength()).mapToObj(attributes::item).map(Attr.class::cast).filter(a -> "xmlns".equals(a.getPrefix())).collect(Collectors.toMap(Node::getLocalName, Attr::getValue));
        final HashMap xmlnsPrefixMapInverse = new HashMap();
        xmlnsPrefixMap.forEach((prefix, namespace) -> {
            String string = xmlnsPrefixMapInverse.put(namespace, prefix);
        });
        return new NamespaceContext(){

            @Override
            public String getNamespaceURI(String prefix) {
                return (String)xmlnsPrefixMap.get(prefix);
            }

            @Override
            public String getPrefix(String namespaceURI) {
                return (String)xmlnsPrefixMapInverse.get(namespaceURI);
            }

            @Override
            public Iterator<String> getPrefixes(String namespaceURI) {
                String prefix = this.getPrefix(namespaceURI);
                return prefix == null ? Collections.emptyIterator() : List.of(prefix).iterator();
            }
        };
    }

    private static Optional<Object> reconstructReferenceList(EObject first, String xpath, Iterator<Object> iterator) {
        EReference containment = first.eContainmentFeature();
        if (containment != null && containment.isMany() && xpath.endsWith("/" + containment.getName())) {
            EObject container = first.eContainer();
            ArrayList<EObject> featureList = new ArrayList<EObject>();
            featureList.add(first);
            while (iterator.hasNext()) {
                EObject next = (EObject)iterator.next();
                if (next.eContainer() != container || next.eContainmentFeature() != containment) break;
                featureList.add(next);
            }
            return Optional.of(featureList);
        }
        return Optional.empty();
    }

    private static class DOMMapping
    extends DefaultDOMHandlerImpl {
        private DOMMapping() {
        }

        public Element getElement(Object object) {
            for (Map.Entry entry : this.nodeToObject.entrySet()) {
                if (!Objects.equals(entry.getValue(), object)) continue;
                return (Element)entry.getKey();
            }
            return null;
        }
    }

    private static class EObjectContext
    implements XPathContext {
        private final XPath xpath;
        private final Element rootElement;
        private final DOMMapping domMapping;

        private EObjectContext(Element rootElement, DOMMapping domMapping, XPath xpath) {
            this.rootElement = rootElement;
            this.domMapping = domMapping;
            this.xpath = xpath;
            this.xpath.setXPathFunctionResolver(this::resolveEMFFunctions);
        }

        /*
         * WARNING - void declaration
         */
        public <R> Stream<R> stream(String path, Class<R> resultType) {
            void pathNodes;
            XPathNodes result;
            Class type = XPathNodes.class;
            if (resultType == Boolean.class || resultType == String.class || Number.class.isAssignableFrom(resultType)) {
                type = resultType;
            }
            Object pathEnhanced = path;
            if (path.equals("/")) {
                pathEnhanced = "/" + this.rootElement.getTagName();
            } else if (path.startsWith("/") && !path.startsWith("//")) {
                pathEnhanced = "/" + this.rootElement.getTagName() + path;
            }
            pathEnhanced = ((String)pathEnhanced).replace("..[", "parent::node()[").replace(".[", "self::node()[");
            try {
                result = this.xpath.evaluateExpression((String)pathEnhanced, this.rootElement, type);
            }
            catch (XPathExpressionException e) {
                throw new IllegalArgumentException("Illegal xpath: " + path, e);
            }
            if (!(result instanceof XPathNodes)) {
                return Stream.of(resultType.cast(result));
            }
            XPathNodes e = result;
            return StreamSupport.stream(pathNodes.spliterator(), false).map(node -> {
                if (node instanceof Element || node instanceof Document) {
                    return (EObject)this.domMapping.getValue((Node)node);
                }
                if (node instanceof Attr) {
                    Attr attribute = (Attr)node;
                    return attribute.getValue();
                }
                return node;
            }).peek(Objects::requireNonNull).filter(resultType::isInstance).map(resultType::cast);
        }

        public <R> Iterator<R> iterate(String xpath) {
            return this.stream(xpath, (Class<R>)Object.class).iterator();
        }

        public <R> R getValue(String xpath, Class<R> requiredType) {
            return requiredType.cast(this.getValue(xpath));
        }

        @Override
        public Object getValue(String xpath) {
            Iterator<Object> iterator = this.iterate(xpath);
            if (!iterator.hasNext()) {
                throw new XPathNotFoundException("No value for xpath: " + xpath);
            }
            Object first = iterator.next();
            if (first instanceof EObject) {
                EObject firstEObject = (EObject)first;
                return JavaXPathContextFactoryImpl.reconstructReferenceList(firstEObject, xpath, iterator).orElse(first);
            }
            return first;
        }

        private XPathFunction resolveEMFFunctions(QName functionName, int arity) {
            if (arity == 1 && "http://www.eclipse.org/emf/2002/Ecore".equals(functionName.getNamespaceURI()) && "eClassName".equals(functionName.getLocalPart())) {
                return args -> {
                    Node item = EObjectContext.getSingleNodeArgument(args);
                    EObject eObject = (EObject)this.domMapping.getValue(item);
                    return eObject == null ? null : eObject.eClass().getName();
                };
            }
            return null;
        }

        private static Node getSingleNodeArgument(List<?> args) throws XPathFunctionException {
            if (args != null && args.size() == 1) {
                NodeList nodeList;
                Object argument = args.get(0);
                if (argument instanceof NodeList && (nodeList = (NodeList)argument).getLength() == 1) {
                    return nodeList.item(0);
                }
                if (argument instanceof Node) {
                    Node node = (Node)argument;
                    return node;
                }
            }
            throw new XPathFunctionException("Not a single node list: " + String.valueOf(args));
        }
    }
}

