/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.beans;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.databinding.beans.IBeanMapProperty;
import org.eclipse.core.databinding.beans.typed.PojoProperties;
import org.eclipse.core.databinding.property.map.DelegatingMapProperty;
import org.eclipse.core.databinding.property.map.IMapProperty;
import org.eclipse.core.internal.databinding.beans.BeanPropertyHelper;

public class AnonymousPojoMapProperty<S, K, V>
extends DelegatingMapProperty<S, K, V> {
    private final String propertyName;
    private Map<Class<S>, IMapProperty<S, K, V>> delegates;

    public AnonymousPojoMapProperty(String propertyName, Class<K> keyType, Class<V> valueType) {
        super(keyType, valueType);
        this.propertyName = propertyName;
        this.delegates = new HashMap<Class<S>, IMapProperty<S, K, V>>();
    }

    protected IMapProperty<S, K, V> doGetDelegate(S source) {
        IBeanMapProperty delegate;
        Class<?> beanClass = source.getClass();
        if (this.delegates.containsKey(beanClass)) {
            return this.delegates.get(beanClass);
        }
        try {
            delegate = PojoProperties.map(beanClass, this.propertyName, (Class)this.getKeyType(), (Class)this.getValueType());
        }
        catch (IllegalArgumentException noSuchProperty) {
            delegate = null;
        }
        this.delegates.put(beanClass, delegate);
        return delegate;
    }

    public String toString() {
        String s = "?." + this.propertyName + "{:}";
        Class keyType = (Class)this.getKeyType();
        Class valueType = (Class)this.getValueType();
        if (keyType != null || valueType != null) {
            s = s + "<" + BeanPropertyHelper.shortClassName(keyType) + ", " + BeanPropertyHelper.shortClassName(valueType) + ">";
        }
        return s;
    }
}

