/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.observable.sideeffect;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.internal.databinding.observable.sideeffect.SideEffect;

public interface ISideEffect {
    public void dispose();

    public boolean isDisposed();

    public void pause();

    public void resume();

    public void resumeAndRunIfDirty();

    public void runIfDirty();

    public void addDisposeListener(Consumer<ISideEffect> var1);

    public void removeDisposeListener(Consumer<ISideEffect> var1);

    public static ISideEffect createPaused(Runnable runnable) {
        return new SideEffect(runnable);
    }

    public static ISideEffect createPaused(Realm realm, Runnable runnable) {
        return new SideEffect(realm, runnable);
    }

    public static ISideEffect create(Runnable runnable) {
        IObservable[] dependencies = ObservableTracker.runAndMonitor(runnable, null, null);
        if (dependencies.length == 0) {
            return SideEffect.NULL_SIDE_EFFECT;
        }
        return new SideEffect(runnable, dependencies);
    }

    public static <T> ISideEffect create(Supplier<T> supplier, Consumer<T> consumer) {
        return ISideEffect.create(SideEffect.makeRunnable(supplier, consumer));
    }

    public static <T> ISideEffect createResumed(Supplier<T> supplier, Consumer<T> consumer) {
        ISideEffect result = ISideEffect.createPaused(SideEffect.makeRunnable(supplier, consumer));
        result.resume();
        return result;
    }

    public static <T> ISideEffect consumeOnceAsync(Supplier<T> supplier, Consumer<T> consumer) {
        ISideEffect[] result = new ISideEffect[1];
        Runnable theRunnable = () -> {
            Object value = supplier.get();
            if (value != null) {
                ObservableTracker.setIgnore(true);
                try {
                    consumer.accept(value);
                }
                finally {
                    ObservableTracker.setIgnore(false);
                }
                result[0].dispose();
            }
        };
        result[0] = ISideEffect.createPaused(theRunnable);
        result[0].resume();
        return result[0];
    }
}

