/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.properties;

import java.util.HashSet;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.ISaveablesLifecycleListener;
import org.eclipse.ui.ISecondarySaveableSource;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.SaveablesLifecycleEvent;
import org.eclipse.ui.internal.DefaultSaveable;
import org.eclipse.ui.internal.SaveablesList;
import org.eclipse.ui.internal.views.properties.PropertiesMessages;
import org.eclipse.ui.part.IContributedContentsView;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.MessagePage;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageBookView;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.PinPropertySheetAction;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.eclipse.ui.views.properties.PropertyShowInContext;

public class PropertySheet
extends PageBookView
implements ISelectionListener,
IShowInTarget,
IShowInSource,
IRegistryEventListener,
ISecondarySaveableSource {
    public static final String HELP_CONTEXT_PROPERTY_SHEET_VIEW = "org.eclipse.ui.property_sheet_view_context";
    private static final String EXT_POINT = "org.eclipse.ui.propertiesView";
    private final String defaultText = PropertiesMessages.PropertyViewer_noProperties;
    private ISelection bootstrapSelection;
    private ISelection currentSelection;
    private IWorkbenchPart currentPart;
    private IAction pinPropertySheetAction = new PinPropertySheetAction();
    private HashSet<String> ignoredViews;
    private boolean wasHidden = true;
    private boolean selectionUpdatePending;
    private final SaveablesTracker saveablesTracker;
    private boolean needsUpdate = false;

    public PropertySheet() {
        RegistryFactory.getRegistry().addListener((IRegistryEventListener)this, EXT_POINT);
        this.saveablesTracker = new SaveablesTracker();
    }

    protected IPage createDefaultPage(PageBook book) {
        MessagePage page = new MessagePage();
        this.initPage((IPageBookViewPage)page);
        page.createControl((Composite)book);
        page.setMessage(this.defaultText);
        return page;
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.pinPropertySheetAction.addPropertyChangeListener(event -> {
            if ("checked".equals(event.getProperty())) {
                this.updateContentDescription();
                if (!this.isPinned()) {
                    this.selectionChanged(this.currentPart, this.currentSelection);
                }
            }
        });
        IMenuManager menuManager = this.getViewSite().getActionBars().getMenuManager();
        menuManager.add((IContributionItem)new Separator("additions"));
        menuManager.add(this.pinPropertySheetAction);
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        menuManager.add((IContributionItem)new Separator("additions"));
        toolBarManager.add(this.pinPropertySheetAction);
        ISaveablesLifecycleListener saveables = (ISaveablesLifecycleListener)this.getSite().getService(ISaveablesLifecycleListener.class);
        if (saveables instanceof SaveablesList) {
            ((SaveablesList)saveables).addModelLifecycleListener((ISaveablesLifecycleListener)this.saveablesTracker);
        }
        this.getSite().getPage().getWorkbenchWindow().getWorkbench().getHelpSystem().setHelp((Control)this.getPageBook(), HELP_CONTEXT_PROPERTY_SHEET_VIEW);
    }

    public void dispose() {
        IWorkbenchPartSite site = this.getSite();
        IWorkbenchPage page = site.getPage();
        ISaveablesLifecycleListener saveables = (ISaveablesLifecycleListener)site.getService(ISaveablesLifecycleListener.class);
        page.removePostSelectionListener((ISelectionListener)this);
        RegistryFactory.getRegistry().removeListener((IRegistryEventListener)this);
        if (saveables instanceof SaveablesList) {
            ((SaveablesList)saveables).removeModelLifecycleListener((ISaveablesLifecycleListener)this.saveablesTracker);
        }
        this.currentPart = null;
        this.currentSelection = null;
        this.pinPropertySheetAction = null;
        super.dispose();
    }

    protected PageBookView.PageRec doCreatePage(IWorkbenchPart part) {
        if (part instanceof PropertySheet) {
            return null;
        }
        IPropertySheetPage page = (IPropertySheetPage)Adapters.adapt((Object)part, IPropertySheetPage.class);
        if (page != null) {
            if (page instanceof IPageBookViewPage) {
                this.initPage((IPageBookViewPage)page);
            }
            page.createControl((Composite)this.getPageBook());
            return new PageBookView.PageRec(part, (IPage)page);
        }
        IContributedContentsView view = (IContributedContentsView)Adapters.adapt((Object)part, IContributedContentsView.class);
        if (view != null && view.getContributingPart() == null) {
            return null;
        }
        IPage dPage = this.createPropertySheetPage(this.getPageBook());
        return new PageBookView.PageRec(part, dPage);
    }

    protected IPage createPropertySheetPage(PageBook book) {
        IPropertySheetPage page = (IPropertySheetPage)Platform.getAdapterManager().getAdapter((Object)this, IPropertySheetPage.class);
        if (page == null) {
            page = new PropertySheetPage();
        }
        if (page instanceof IPageBookViewPage) {
            this.initPage((IPageBookViewPage)page);
        }
        page.createControl((Composite)book);
        return page;
    }

    protected void doDestroyPage(IWorkbenchPart part, PageBookView.PageRec rec) {
        IPropertySheetPage page = (IPropertySheetPage)rec.page;
        page.dispose();
        rec.dispose();
    }

    protected IWorkbenchPart getBootstrapPart() {
        IViewReference[] viewrefs;
        ISelection selection;
        IWorkbenchPage page = this.getSite().getPage();
        if (page == null) {
            return null;
        }
        ISelection originalSel = page.getSelection();
        IWorkbenchPart activePart = page.getActivePart();
        if (activePart != null && activePart != this) {
            this.bootstrapSelection = originalSel;
            return activePart;
        }
        if (originalSel == null || originalSel.isEmpty()) {
            return null;
        }
        IEditorPart activeEditor = page.getActiveEditor();
        if (activeEditor != null && this.isImportant((IWorkbenchPart)activeEditor) && activeEditor.getSite().getSelectionProvider() != null && originalSel.equals(selection = activeEditor.getSite().getSelectionProvider().getSelection())) {
            this.bootstrapSelection = originalSel;
            return activeEditor;
        }
        IViewReference[] iViewReferenceArray = viewrefs = page.getViewReferences();
        int n = viewrefs.length;
        int n2 = 0;
        while (n2 < n) {
            ISelection selection2;
            IViewReference ref = iViewReferenceArray[n2];
            IWorkbenchPart part = ref.getPart(false);
            if (part != null && part != this && page.isPartVisible(part) && this.isImportant(part) && part.getSite().getSelectionProvider() != null && originalSel.equals(selection2 = part.getSite().getSelectionProvider().getSelection())) {
                this.bootstrapSelection = originalSel;
                return part;
            }
            ++n2;
        }
        return null;
    }

    public void init(IViewSite site) throws PartInitException {
        site.getPage().addPostSelectionListener((ISelectionListener)this);
        super.init(site);
    }

    public void saveState(IMemento memento) {
        IViewSite viewSite = this.getViewSite();
        String secondaryId = viewSite.getSecondaryId();
        if (secondaryId == null) {
            super.saveState(memento);
        } else if (viewSite.getWorkbenchWindow().isClosing()) {
            viewSite.getPage().hideView((IViewPart)this);
        }
    }

    protected boolean isImportant(IWorkbenchPart part) {
        if (part == null) {
            return false;
        }
        IWorkbenchPartSite site = part.getSite();
        if (site == null) {
            return false;
        }
        String partID = site.getId();
        boolean isPropertyView = this.getSite().getId().equals(partID);
        return !this.isPinned() && !isPropertyView && !this.isViewIgnored(partID);
    }

    public void partClosed(IWorkbenchPart part) {
        if (part.equals(this.currentPart)) {
            if (this.isPinned()) {
                this.pinPropertySheetAction.setChecked(false);
            }
            this.currentSelection = null;
            this.currentPart = null;
        }
        super.partClosed(part);
    }

    protected void partVisible(IWorkbenchPart part) {
        super.partVisible(part);
        if (part == this) {
            this.wasHidden = false;
            if (this.selectionUpdatePending) {
                this.showSelectionAndDescription();
            }
        }
    }

    protected void partHidden(IWorkbenchPart part) {
        if (part == this) {
            this.wasHidden = true;
        }
    }

    public void partActivated(IWorkbenchPart part) {
        IWorkbenchPartSite site;
        IWorkbenchPage page;
        IViewPart[] stack;
        if (part == this) {
            this.wasHidden = false;
            super.partActivated(part);
            if (this.selectionUpdatePending) {
                this.showSelectionAndDescription();
            }
            return;
        }
        if (!this.isImportant(part)) {
            return;
        }
        IContributedContentsView view = (IContributedContentsView)Adapters.adapt((Object)part, IContributedContentsView.class);
        IWorkbenchPart source = null;
        if (view != null) {
            source = view.getContributingPart();
        }
        if (source != null && !this.isImportant(source)) {
            return;
        }
        if (source == null) {
            source = part;
        }
        if (this.wasHidden && (stack = (page = (site = this.getSite()).getPage()).getViewStack((IViewPart)this)) != null) {
            IViewPart[] iViewPartArray = stack;
            int n = stack.length;
            int n2 = 0;
            while (n2 < n) {
                IViewPart vPart = iViewPartArray[n2];
                if (vPart == source) {
                    return;
                }
                ++n2;
            }
        }
        super.partActivated(source);
        if (this.currentPart == null && this.bootstrapSelection != null) {
            this.currentSelection = this.bootstrapSelection;
            this.bootstrapSelection = null;
            this.selectionUpdatePending = true;
        } else {
            this.currentSelection = null;
        }
        this.currentPart = part;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection sel) {
        if (part == null || !part.equals(this.currentPart)) {
            return;
        }
        if (this.isPinned()) {
            this.currentPart = part;
            this.currentSelection = sel;
            this.needsUpdate = true;
            return;
        }
        if (sel == null || this.isPinned() || !this.needsUpdate && sel.equals(this.currentSelection)) {
            return;
        }
        this.currentSelection = sel;
        this.needsUpdate = false;
        if (this.wasHidden) {
            this.selectionUpdatePending = true;
            return;
        }
        this.showSelectionAndDescription();
    }

    private void updateContentDescription() {
        if (this.isPinned() && this.currentPart != null) {
            this.setContentDescription(NLS.bind((String)PropertiesMessages.Selection_description, (Object)this.currentPart.getTitle()));
        } else {
            this.setContentDescription("");
        }
        this.firePropertyChange(257);
    }

    private void showSelectionAndDescription() {
        this.selectionUpdatePending = false;
        if (this.currentPart == null || this.currentSelection == null) {
            return;
        }
        IPage page = this.getCurrentPage();
        if (page instanceof ISelectionListener) {
            ((ISelectionListener)page).selectionChanged(this.currentPart, this.currentSelection);
        }
        this.updateContentDescription();
    }

    public boolean isDirtyStateSupported() {
        if (this.currentPart == null) {
            return false;
        }
        ISecondarySaveableSource source = (ISecondarySaveableSource)this.getAdapter(ISecondarySaveableSource.class);
        if (source != null && source != this) {
            return source.isDirtyStateSupported();
        }
        source = (ISecondarySaveableSource)Adapters.adapt((Object)this.currentPart, ISecondarySaveableSource.class);
        if (source != null && source != this) {
            return source.isDirtyStateSupported();
        }
        return false;
    }

    protected <T> T getViewAdapter(Class<T> key) {
        if (ISaveablePart.class.equals(key)) {
            return key.cast(this.getSaveablePart());
        }
        return (T)super.getViewAdapter(key);
    }

    protected ISaveablePart getSaveablePart() {
        IWorkbenchPart part = this.getCurrentContributingPart();
        if (part instanceof ISaveablePart) {
            return (ISaveablePart)part;
        }
        return null;
    }

    public boolean isPinned() {
        return this.pinPropertySheetAction != null && this.pinPropertySheetAction.isChecked();
    }

    public ShowInContext getShowInContext() {
        return new PropertyShowInContext(this.currentPart, this.currentSelection);
    }

    public boolean show(ShowInContext aContext) {
        PropertyShowInContext context;
        IWorkbenchPart part;
        if (!this.isPinned() && aContext instanceof PropertyShowInContext && (part = (context = (PropertyShowInContext)aContext).getPart()) != null) {
            this.partActivated(part);
            this.selectionChanged(part, context.getSelection());
            return true;
        }
        return false;
    }

    public void setPinned(boolean pinned) {
        this.pinPropertySheetAction.setChecked(pinned);
        this.updateContentDescription();
    }

    private HashSet<String> getIgnoredViews() {
        if (this.ignoredViews == null) {
            this.ignoredViews = new HashSet();
            IExtensionRegistry registry = RegistryFactory.getRegistry();
            IExtensionPoint ep = registry.getExtensionPoint(EXT_POINT);
            if (ep != null) {
                IExtension[] extensions;
                IExtension[] iExtensionArray = extensions = ep.getExtensions();
                int n = extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement[] elements;
                    IExtension extension = iExtensionArray[n2];
                    IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                    int n3 = elements.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String id;
                        IConfigurationElement element = iConfigurationElementArray[n4];
                        if ("excludeSources".equalsIgnoreCase(element.getName()) && (id = element.getAttribute("id")) != null) {
                            this.ignoredViews.add(id);
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
        }
        return this.ignoredViews;
    }

    private boolean isViewIgnored(String partID) {
        return this.getIgnoredViews().contains(partID);
    }

    public void added(IExtension[] extensions) {
        this.ignoredViews = null;
    }

    public void added(IExtensionPoint[] extensionPoints) {
        this.ignoredViews = null;
    }

    public void removed(IExtension[] extensions) {
        this.ignoredViews = null;
    }

    public void removed(IExtensionPoint[] extensionPoints) {
        this.ignoredViews = null;
    }

    class SaveablesTracker
    implements ISaveablesLifecycleListener {
        SaveablesTracker() {
        }

        public void handleLifecycleEvent(SaveablesLifecycleEvent event) {
            if (PropertySheet.this.currentPart == null || event.getEventType() != 4 || !PropertySheet.this.isDirtyStateSupported()) {
                return;
            }
            Saveable[] saveables = event.getSaveables();
            if (saveables == null) {
                return;
            }
            Saveable[] saveableArray = saveables;
            int n = saveables.length;
            int n2 = 0;
            while (n2 < n) {
                Saveable saveable = saveableArray[n2];
                if (new DefaultSaveable((IWorkbenchPart)PropertySheet.this).equals((Object)saveable)) {
                    return;
                }
                ++n2;
            }
            if (event.getSource() instanceof SaveablesList) {
                SaveablesList saveablesList = (SaveablesList)event.getSource();
                Saveable[] saveableArray2 = saveables;
                int n3 = saveables.length;
                n = 0;
                while (n < n3) {
                    IWorkbenchPart[] parts;
                    Saveable saveable = saveableArray2[n];
                    IWorkbenchPart[] iWorkbenchPartArray = parts = saveablesList.getPartsForSaveable(saveable);
                    int n4 = parts.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        IWorkbenchPart part = iWorkbenchPartArray[n5];
                        if (PropertySheet.this.currentPart == part) {
                            PropertySheet.this.firePropertyChange(257);
                            return;
                        }
                        ++n5;
                    }
                    ++n;
                }
            }
        }
    }
}

