/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.ui.internal.WorkbenchMessages;

public class CheckedTreeSelectionDialog
extends SelectionStatusDialog {
    private CheckboxTreeViewer fViewer;
    private final ILabelProvider fLabelProvider;
    private final ITreeContentProvider fContentProvider;
    private ISelectionStatusValidator fValidator = null;
    private ViewerComparator fComparator;
    private String fEmptyListMessage = WorkbenchMessages.CheckedTreeSelectionDialog_nothing_available;
    private IStatus fCurrStatus = new Status(0, "org.eclipse.ui", 0, "", null);
    private List<ViewerFilter> fFilters;
    private Object fInput;
    private boolean fIsEmpty;
    private int fWidth = 60;
    private int fHeight = 18;
    private boolean fContainerMode;
    private Object[] fExpandedElements;
    private int fStyle = 2048;
    private final boolean fAllowEmptyTree;

    public CheckedTreeSelectionDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
        this(parent, labelProvider, contentProvider, 2048);
    }

    public CheckedTreeSelectionDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider, boolean allowEmptyTree) {
        this(parent, labelProvider, contentProvider, 2048, allowEmptyTree);
    }

    public CheckedTreeSelectionDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider, int style) {
        this(parent, labelProvider, contentProvider, style, false);
    }

    public CheckedTreeSelectionDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider, int style, boolean allowEmptyTree) {
        super(parent);
        this.fLabelProvider = labelProvider;
        this.fContentProvider = contentProvider;
        this.setResult(new ArrayList(0));
        this.setStatusLineAboveButtons(true);
        this.fContainerMode = false;
        this.fExpandedElements = null;
        this.fStyle = style;
        this.fAllowEmptyTree = allowEmptyTree;
    }

    public void setContainerMode(boolean containerMode) {
        this.fContainerMode = containerMode;
    }

    public void setInitialSelection(Object selection) {
        this.setInitialSelections(selection);
    }

    public void setEmptyListMessage(String message) {
        this.fEmptyListMessage = message;
    }

    @Deprecated
    public void setSorter(ViewerSorter sorter) {
        this.fComparator = sorter;
    }

    public void setStyle(int style) {
        this.fStyle = style;
    }

    public void setComparator(ViewerComparator comparator) {
        this.fComparator = comparator;
    }

    public void addFilter(ViewerFilter filter) {
        if (this.fFilters == null) {
            this.fFilters = new ArrayList<ViewerFilter>(4);
        }
        this.fFilters.add(filter);
    }

    public void setValidator(ISelectionStatusValidator validator) {
        this.fValidator = validator;
    }

    public void setInput(Object input) {
        this.fInput = input;
    }

    public void setExpandedElements(Object[] elements) {
        this.fExpandedElements = elements;
    }

    public void setSize(int width, int height) {
        this.fWidth = width;
        this.fHeight = height;
    }

    protected void updateOKStatus() {
        if (!this.fIsEmpty) {
            if (this.fValidator != null) {
                this.fCurrStatus = this.fValidator.validate(this.fViewer.getCheckedElements());
                this.updateStatus(this.fCurrStatus);
            } else if (!this.fCurrStatus.isOK()) {
                this.fCurrStatus = new Status(0, "org.eclipse.ui", 0, "", null);
            }
        } else if (this.fAllowEmptyTree) {
            if (!this.fCurrStatus.isOK()) {
                this.fCurrStatus = new Status(0, "org.eclipse.ui", 0, "", null);
            }
        } else {
            this.fCurrStatus = new Status(4, "org.eclipse.ui", 0, this.fEmptyListMessage, null);
        }
        this.updateStatus(this.fCurrStatus);
    }

    public int open() {
        this.fIsEmpty = this.evaluateIfTreeEmpty(this.fInput);
        super.open();
        return this.getReturnCode();
    }

    private void access$superCreate() {
        super.create();
    }

    protected void cancelPressed() {
        this.setResult(null);
        super.cancelPressed();
    }

    @Override
    protected void computeResult() {
        this.setResult(Arrays.asList(this.fViewer.getCheckedElements()));
    }

    @Override
    public void create() {
        BusyIndicator.showWhile(null, () -> {
            this.access$superCreate();
            this.fViewer.setCheckedElements(this.getInitialElementSelections().toArray());
            if (this.fExpandedElements != null) {
                this.fViewer.setExpandedElements(this.fExpandedElements);
            }
            this.updateOKStatus();
        });
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Label messageLabel = this.createMessageArea(composite);
        CheckboxTreeViewer treeViewer = this.createTreeViewer(composite);
        Composite buttonComposite = this.createSelectionButtons(composite);
        GridData data = new GridData(1808);
        data.widthHint = this.convertWidthInCharsToPixels(this.fWidth);
        data.heightHint = this.convertHeightInCharsToPixels(this.fHeight);
        Tree treeWidget = treeViewer.getTree();
        treeWidget.setLayoutData((Object)data);
        treeWidget.setFont(parent.getFont());
        if (this.fIsEmpty) {
            messageLabel.setEnabled(false);
            treeWidget.setEnabled(false);
            buttonComposite.setEnabled(false);
        }
        return composite;
    }

    protected CheckboxTreeViewer createTreeViewer(Composite parent) {
        this.fViewer = this.fContainerMode ? new ContainerCheckedTreeViewer(parent, this.fStyle) : new CheckboxTreeViewer(parent, this.fStyle);
        this.fViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fViewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
        this.fViewer.addCheckStateListener(event -> this.updateOKStatus());
        this.fViewer.setComparator(this.fComparator);
        if (this.fFilters != null) {
            int i = 0;
            while (i != this.fFilters.size()) {
                this.fViewer.addFilter(this.fFilters.get(i));
                ++i;
            }
        }
        this.fViewer.setInput(this.fInput);
        return this.fViewer;
    }

    protected CheckboxTreeViewer getTreeViewer() {
        return this.fViewer;
    }

    protected Composite createSelectionButtons(Composite composite) {
        Composite buttonComposite = new Composite(composite, 131072);
        GridLayout layout = new GridLayout();
        layout.numColumns = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setFont(composite.getFont());
        GridData data = new GridData(640);
        data.grabExcessHorizontalSpace = true;
        buttonComposite.setLayoutData((Object)data);
        Button selectButton = this.createButton(buttonComposite, 18, WorkbenchMessages.CheckedTreeSelectionDialog_select_all, false);
        SelectionListener listener = SelectionListener.widgetSelectedAdapter(e -> {
            Object[] viewerElements;
            Object[] objectArray = viewerElements = this.fContentProvider.getElements(this.fInput);
            int n = viewerElements.length;
            int n2 = 0;
            while (n2 < n) {
                Object viewerElement = objectArray[n2];
                this.fViewer.setSubtreeChecked(viewerElement, true);
                ++n2;
            }
            this.updateOKStatus();
        });
        selectButton.addSelectionListener(listener);
        Button deselectButton = this.createButton(buttonComposite, 19, WorkbenchMessages.CheckedTreeSelectionDialog_deselect_all, false);
        listener = SelectionListener.widgetSelectedAdapter(e -> {
            this.fViewer.setCheckedElements(new Object[0]);
            this.updateOKStatus();
        });
        deselectButton.addSelectionListener(listener);
        return buttonComposite;
    }

    private boolean evaluateIfTreeEmpty(Object input) {
        Object[] elements = this.fContentProvider.getElements(input);
        if (elements.length > 0 && this.fFilters != null) {
            for (ViewerFilter curr : this.fFilters) {
                elements = curr.filter((Viewer)this.fViewer, input, elements);
            }
        }
        return elements.length == 0;
    }
}

