/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.extractor.lib;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.oomph.extractor.lib.BINDescriptor;
import org.eclipse.oomph.extractor.lib.BINMarker;
import org.eclipse.oomph.extractor.lib.IO;

public final class BINExtractor
extends IO {
    private static final String NL = System.getProperty("line.separator");
    private static final String UTF_8 = "UTF-8";

    public static void main(String[] args) throws Exception {
        BINDescriptor descriptor;
        String executable = args[0];
        String targetFolder = args[1];
        String javaHome = null;
        boolean export = false;
        File markerFile = null;
        File extractorFile = null;
        File libdataFile = null;
        File descriptorFile = null;
        File zipFile = null;
        if (args.length > 2) {
            if ("-export".equals(args[2])) {
                export = true;
                markerFile = new File(args[3]);
                extractorFile = new File(args[4]);
                libdataFile = new File(args[5]);
                descriptorFile = new File(args[6]);
                zipFile = new File(targetFolder);
            } else {
                javaHome = args[2];
            }
        }
        FileInputStream in = new FileInputStream(executable);
        try {
            BufferedInputStream stream = new BufferedInputStream(in);
            byte[] pattern = BINMarker.getBytes();
            if (export) {
                BINExtractor.copy((InputStream)new ByteArrayInputStream(pattern), markerFile);
            }
            IO.KMPInputStream kmpStream = new IO.KMPInputStream(stream, pattern);
            int[] failure = kmpStream.getFailure();
            if (export) {
                BINExtractor.copy((InputStream)kmpStream, extractorFile);
            } else {
                BINExtractor.drain(kmpStream);
            }
            kmpStream = new IO.KMPInputStream(stream, pattern, failure);
            if (export) {
                BINExtractor.copy((InputStream)kmpStream, libdataFile);
            } else {
                BINExtractor.drain(kmpStream);
            }
            kmpStream = new IO.KMPInputStream(stream, pattern, failure);
            descriptor = new BINDescriptor(kmpStream);
            if (export) {
                descriptor.write(descriptorFile);
            }
            kmpStream = new IO.KMPInputStream(stream, pattern, failure);
            if (export) {
                BINExtractor.copy((InputStream)kmpStream, zipFile);
            } else {
                BINExtractor.unzip(kmpStream, targetFolder);
            }
        }
        finally {
            BINExtractor.close(in);
        }
        if (!export) {
            if (javaHome != null) {
                BINExtractor.adjustIni(String.valueOf(targetFolder) + File.separator + descriptor.getIniPath(), javaHome);
            }
            String launcher = String.valueOf(targetFolder) + File.separator + descriptor.getLauncherPath();
            Runtime.getRuntime().exec(launcher);
        }
    }

    private static void copy(InputStream source, File targetFile) throws IOException {
        File parentFile = targetFile.getParentFile();
        if (parentFile != null) {
            parentFile.mkdirs();
        }
        FileOutputStream target = new FileOutputStream(targetFile);
        try {
            BINExtractor.copy(source, target);
        }
        finally {
            BINExtractor.close(target);
        }
    }

    private static void adjustIni(String iniPath, String javaHome) throws IOException {
        File file = new File(iniPath);
        Vector<String> lines = new Vector<String>();
        if (file.exists()) {
            String line;
            FileInputStream in = new FileInputStream(file);
            InputStreamReader reader = new InputStreamReader((InputStream)in, UTF_8);
            BufferedReader bufferedReader = new BufferedReader(reader);
            while ((line = bufferedReader.readLine()) != null) {
                lines.add(line);
            }
            bufferedReader.close();
            ((Reader)reader).close();
            ((InputStream)in).close();
        }
        String value = BINExtractor.getVMPath(javaHome);
        String option = "-vm";
        int optionIndex = lines.indexOf(option);
        if (optionIndex != -1) {
            lines.set(optionIndex + 1, value);
        } else {
            int vmargsIndex = lines.indexOf("-vmargs");
            if (vmargsIndex == -1) {
                vmargsIndex = lines.size();
            }
            lines.add(vmargsIndex, option);
            lines.add(vmargsIndex + 1, value);
        }
        FileOutputStream out = new FileOutputStream(file);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, UTF_8);
        BufferedWriter bufferedWriter = new BufferedWriter(writer);
        Enumeration it = lines.elements();
        while (it.hasMoreElements()) {
            bufferedWriter.write((String)it.nextElement());
            bufferedWriter.write(NL);
        }
        bufferedWriter.close();
        ((Writer)writer).close();
        ((OutputStream)out).close();
    }

    private static String getVMPath(String javaHome) {
        if (javaHome.endsWith(".exe")) {
            return new File(javaHome).getParent();
        }
        return String.valueOf(javaHome) + File.separator + "bin";
    }
}

