/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.observable.map;

import java.util.AbstractSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.DisposeEvent;
import org.eclipse.core.databinding.observable.IDisposeListener;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.StaleEvent;
import org.eclipse.core.databinding.observable.map.AbstractObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.core.databinding.observable.set.SetChangeEvent;
import org.eclipse.core.internal.databinding.identity.IdentitySet;

public abstract class ComputedObservableMap<K, V>
extends AbstractObservableMap<K, V> {
    private IObservableSet<K> keySet;
    private Set<K> knownKeys;
    private Object valueType;
    private ISetChangeListener<K> setChangeListener = new ISetChangeListener<K>(){

        @Override
        public void handleSetChange(SetChangeEvent<? extends K> event) {
            HashSet addedKeys = new HashSet(event.diff.getAdditions());
            HashSet removedKeys = new HashSet(event.diff.getRemovals());
            HashMap oldValues = new HashMap();
            HashMap newValues = new HashMap();
            for (Object removedKey : removedKeys) {
                Object oldValue = null;
                if (removedKey != null) {
                    oldValue = ComputedObservableMap.this.doGet(removedKey);
                    ComputedObservableMap.this.unhookListener(removedKey);
                    ComputedObservableMap.this.knownKeys.remove(removedKey);
                }
                oldValues.put(removedKey, oldValue);
            }
            for (Object addedKey : addedKeys) {
                Object newValue = null;
                if (addedKey != null) {
                    newValue = ComputedObservableMap.this.doGet(addedKey);
                    ComputedObservableMap.this.hookListener(addedKey);
                    ComputedObservableMap.this.knownKeys.add(addedKey);
                }
                newValues.put(addedKey, newValue);
            }
            Set changedKeys = Collections.emptySet();
            ComputedObservableMap.this.fireMapChange(Diffs.createMapDiff(addedKeys, removedKeys, changedKeys, oldValues, newValues));
        }
    };
    private IStaleListener staleListener = new IStaleListener(){

        @Override
        public void handleStale(StaleEvent staleEvent) {
            ComputedObservableMap.this.fireStale();
        }
    };
    private Set<Map.Entry<K, V>> entrySet = new EntrySet();

    public ComputedObservableMap(IObservableSet<K> keySet) {
        this(keySet, null);
    }

    public ComputedObservableMap(IObservableSet<K> keySet, Object valueType) {
        super(keySet.getRealm());
        this.keySet = keySet;
        this.valueType = valueType;
        keySet.addDisposeListener(new IDisposeListener(){

            @Override
            public void handleDispose(DisposeEvent disposeEvent) {
                ComputedObservableMap.this.dispose();
            }
        });
    }

    @Deprecated
    protected void init() {
    }

    @Override
    protected void firstListenerAdded() {
        this.getRealm().exec(new Runnable(){

            @Override
            public void run() {
                ComputedObservableMap.this.hookListeners();
            }
        });
    }

    @Override
    protected void lastListenerRemoved() {
        this.unhookListeners();
    }

    private void hookListeners() {
        if (this.keySet != null) {
            this.knownKeys = new IdentitySet<K>();
            this.keySet.addSetChangeListener(this.setChangeListener);
            this.keySet.addStaleListener(this.staleListener);
            for (K key : this.keySet) {
                this.hookListener(key);
                this.knownKeys.add(key);
            }
        }
    }

    private void unhookListeners() {
        if (this.keySet != null) {
            this.keySet.removeSetChangeListener(this.setChangeListener);
            this.keySet.removeStaleListener(this.staleListener);
        }
        if (this.knownKeys != null) {
            Set<K> immutableKnownKeys = Collections.unmodifiableSet(this.knownKeys);
            for (K key : immutableKnownKeys) {
                this.unhookListener(key);
            }
            this.knownKeys.clear();
            this.knownKeys = null;
        }
    }

    protected final void fireSingleChange(K key, V oldValue, V newValue) {
        this.fireMapChange(Diffs.createMapDiffSingleChange(key, oldValue, newValue));
    }

    @Override
    public Object getKeyType() {
        return this.keySet.getElementType();
    }

    @Override
    public Object getValueType() {
        return this.valueType;
    }

    @Override
    public V remove(Object key) {
        this.checkRealm();
        V oldValue = this.get(key);
        this.keySet().remove(key);
        return oldValue;
    }

    @Override
    public boolean containsKey(Object key) {
        this.getterCalled();
        return this.keySet().contains(key);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.entrySet;
    }

    @Override
    public Set<K> keySet() {
        return this.keySet;
    }

    @Override
    public final V get(Object key) {
        this.getterCalled();
        if (!this.keySet.contains(key)) {
            return null;
        }
        return this.doGet(key);
    }

    private void getterCalled() {
        ObservableTracker.getterCalled(this);
    }

    @Override
    public final V put(K key, V value) {
        this.checkRealm();
        if (!this.keySet.contains(key)) {
            return null;
        }
        return this.doPut(key, value);
    }

    protected abstract void unhookListener(K var1);

    protected abstract void hookListener(K var1);

    protected abstract V doGet(K var1);

    protected abstract V doPut(K var1, V var2);

    @Override
    public boolean isStale() {
        return super.isStale() || this.keySet.isStale();
    }

    @Override
    public synchronized void dispose() {
        this.unhookListeners();
        this.entrySet = null;
        this.keySet = null;
        this.setChangeListener = null;
        super.dispose();
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            final Iterator keyIterator = ComputedObservableMap.this.keySet.iterator();
            return new Iterator<Map.Entry<K, V>>(){

                @Override
                public boolean hasNext() {
                    return keyIterator.hasNext();
                }

                @Override
                public Map.Entry<K, V> next() {
                    final Object key = keyIterator.next();
                    return new Map.Entry<K, V>(){

                        @Override
                        public K getKey() {
                            ComputedObservableMap.this.getterCalled();
                            return key;
                        }

                        @Override
                        public V getValue() {
                            return ComputedObservableMap.this.get(this.getKey());
                        }

                        @Override
                        public V setValue(V value) {
                            return ComputedObservableMap.this.put(this.getKey(), value);
                        }
                    };
                }

                @Override
                public void remove() {
                    keyIterator.remove();
                }
            };
        }

        @Override
        public int size() {
            return ComputedObservableMap.this.keySet.size();
        }
    }
}

