/*
 * Decompiled with CFR 0.152.
 */
package jakarta.jms;

import jakarta.jms.InvalidDestinationException;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.Queue;
import jakarta.jms.QueueReceiver;
import jakarta.jms.QueueSender;
import jakarta.jms.QueueSession;
import jakarta.jms.TemporaryQueue;

public class QueueRequestor {
    QueueSession session;
    TemporaryQueue tempQueue;
    QueueSender sender;
    QueueReceiver receiver;

    public QueueRequestor(QueueSession session, Queue queue) throws JMSException {
        if (queue == null) {
            throw new InvalidDestinationException("queue==null");
        }
        this.session = session;
        this.tempQueue = session.createTemporaryQueue();
        this.sender = session.createSender(queue);
        this.receiver = session.createReceiver(this.tempQueue);
    }

    public Message request(Message message) throws JMSException {
        message.setJMSReplyTo(this.tempQueue);
        this.sender.send(message);
        return this.receiver.receive();
    }

    public void close() throws JMSException {
        this.session.close();
        this.tempQueue.delete();
    }
}

