/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.console;

import com.sun.messaging.jmq.admin.apps.console.AGraphics;
import com.sun.messaging.jmq.admin.apps.console.BrokerAdminCObj;
import com.sun.messaging.jmq.admin.apps.console.BrokerDestListCObj;
import com.sun.messaging.jmq.admin.apps.console.BrokerServiceCObj;
import com.sun.messaging.jmq.admin.apps.console.BrokerServiceListCObj;
import com.sun.messaging.jmq.admin.apps.console.ConsoleObj;
import com.sun.messaging.jmq.admin.apps.console.ConsoleUtils;
import com.sun.messaging.jmq.admin.bkrutil.BrokerAdmin;
import com.sun.messaging.jmq.admin.resources.AdminConsoleResources;
import com.sun.messaging.jmq.admin.util.Globals;
import com.sun.messaging.jmq.util.admin.ServiceInfo;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.tree.TreeNode;

public class BrokerCObj
extends BrokerAdminCObj {
    private static final long serialVersionUID = 4185955196463409915L;
    private BrokerServiceListCObj bSvcListCObj;
    private BrokerDestListCObj bDestListCObj;
    private transient BrokerAdmin ba;
    private Properties bkrProps;
    private static AdminConsoleResources acr = Globals.getAdminConsoleResources();

    public BrokerCObj(BrokerAdmin ba) {
        this.ba = ba;
        this.bSvcListCObj = new BrokerServiceListCObj(this);
        this.bDestListCObj = new BrokerDestListCObj(this);
        this.insert(this.bSvcListCObj, 0);
        this.insert(this.bDestListCObj, 1);
    }

    public BrokerAdmin getBrokerAdmin() {
        return this.ba;
    }

    public Properties getBrokerProps() {
        return this.bkrProps;
    }

    public BrokerDestListCObj getBrokerDestListCObj() {
        return this.bDestListCObj;
    }

    public BrokerServiceListCObj getBrokerServiceListCObj() {
        return this.bSvcListCObj;
    }

    public void setBrokerProps(Properties bkrProps) {
        this.bkrProps = bkrProps;
    }

    @Override
    public String getExplorerLabel() {
        if (this.ba != null) {
            return this.ba.getKey();
        }
        return acr.getString(acr.getString("A1094"));
    }

    @Override
    public String getExplorerToolTip() {
        return null;
    }

    @Override
    public ImageIcon getExplorerIcon() {
        if (this.ba.isConnected()) {
            return AGraphics.adminImages[9];
        }
        return AGraphics.adminImages[19];
    }

    @Override
    public String getActionLabel(int actionFlag, boolean forMenu) {
        if (forMenu) {
            switch (actionFlag) {
                case 1024: {
                    return acr.getString("A1026");
                }
                case 2048: {
                    return acr.getString("A1029");
                }
                case 256: {
                    return acr.getString("A1031");
                }
                case 512: {
                    return acr.getString("A1034");
                }
                case 64: {
                    return acr.getString("A1036");
                }
                case 128: {
                    return acr.getString("A1037");
                }
                case 65536: {
                    return acr.getString("A1505");
                }
                case 2: {
                    return acr.getString("A1018");
                }
                case 32: {
                    return acr.getString("A1005");
                }
            }
        } else {
            switch (actionFlag) {
                case 1024: {
                    return acr.getString("A1141");
                }
                case 2048: {
                    return acr.getString("A1144");
                }
                case 256: {
                    return acr.getString("A1146");
                }
                case 512: {
                    return acr.getString("A1149");
                }
                case 64: {
                    return acr.getString("A1151");
                }
                case 128: {
                    return acr.getString("A1152");
                }
                case 65536: {
                    return acr.getString("A1159");
                }
                case 2: {
                    return acr.getString("A1133");
                }
                case 32: {
                    return acr.getString("A1122");
                }
            }
        }
        return null;
    }

    @Override
    public ImageIcon getActionIcon(int actionFlag) {
        switch (actionFlag) {
            case 1024: {
                return AGraphics.adminImages[32];
            }
            case 2048: {
                return AGraphics.adminImages[34];
            }
        }
        return null;
    }

    @Override
    public int getExplorerPopupMenuItemMask() {
        return 69602;
    }

    @Override
    public int getActiveActions() {
        int mask = 0;
        if (this.ba.isConnected()) {
            if (this.isPausable()) {
                mask |= 0x100;
            }
            if (this.isResumable()) {
                mask |= 0x200;
            }
            mask |= 0x148E2;
        } else {
            mask = 1058;
        }
        return mask;
    }

    @Override
    public String getInspectorPanelClassName() {
        return ConsoleUtils.getPackageName(this) + ".BrokerInspector";
    }

    @Override
    public String getInspectorPanelId() {
        return "Broker";
    }

    @Override
    public String getInspectorPanelHeader() {
        return this.getInspectorPanelId();
    }

    private boolean isPausable() {
        boolean answer = false;
        Enumeration<TreeNode> e = this.bSvcListCObj.children();
        while (e.hasMoreElements()) {
            ServiceInfo svcInfo;
            ConsoleObj node = (ConsoleObj)e.nextElement();
            if (!(node instanceof BrokerServiceCObj) || (svcInfo = ((BrokerServiceCObj)node).getServiceInfo()) == null || svcInfo.type == 1 || svcInfo.state != 3) continue;
            answer = true;
            break;
        }
        return answer;
    }

    private boolean isResumable() {
        boolean answer = false;
        Enumeration<TreeNode> e = this.bSvcListCObj.children();
        while (e.hasMoreElements()) {
            ServiceInfo svcInfo;
            ConsoleObj node = (ConsoleObj)e.nextElement();
            if (!(node instanceof BrokerServiceCObj) || (svcInfo = ((BrokerServiceCObj)node).getServiceInfo()) == null || svcInfo.type == 1 || svcInfo.state != 4) continue;
            answer = true;
            break;
        }
        return answer;
    }
}

