/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.reporting;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ItemKind implements Enumerator
{
    CONTEXT(0, "Context", "Context"),
    TESTCASE(1, "Testcase", "Testcase"),
    ECL_COMMAND(2, "EclCommand", "EclCommand"),
    SCRIPT(3, "Script", "Script"),
    TEST_SUITE(4, "TestSuite", "TestSuite"),
    VERIFICATION(5, "Verification", "Verification");

    public static final int CONTEXT_VALUE = 0;
    public static final int TESTCASE_VALUE = 1;
    public static final int ECL_COMMAND_VALUE = 2;
    public static final int SCRIPT_VALUE = 3;
    public static final int TEST_SUITE_VALUE = 4;
    public static final int VERIFICATION_VALUE = 5;
    private static final ItemKind[] VALUES_ARRAY;
    public static final List<ItemKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ItemKind[]{CONTEXT, TESTCASE, ECL_COMMAND, SCRIPT, TEST_SUITE, VERIFICATION};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ItemKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ItemKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ItemKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ItemKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ItemKind get(int value) {
        switch (value) {
            case 0: {
                return CONTEXT;
            }
            case 1: {
                return TESTCASE;
            }
            case 2: {
                return ECL_COMMAND;
            }
            case 3: {
                return SCRIPT;
            }
            case 4: {
                return TEST_SUITE;
            }
            case 5: {
                return VERIFICATION;
            }
        }
        return null;
    }

    private ItemKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

