/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.ecl.parser.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.rcptt.core.ecl.model.ArgDecl;
import org.eclipse.rcptt.core.ecl.model.IDeclContainer;
import org.eclipse.rcptt.core.ecl.model.ProcDecl;
import org.eclipse.rcptt.core.ecl.model.VarDecl;
import org.eclipse.rcptt.core.ecl.parser.ast.Arg;
import org.eclipse.rcptt.core.ecl.parser.ast.Command;
import org.eclipse.rcptt.core.ecl.parser.ast.Id;
import org.eclipse.rcptt.core.ecl.parser.ast.Node;
import org.eclipse.rcptt.core.ecl.parser.ast.Script;
import org.eclipse.rcptt.core.ecl.parser.model.NodePath;
import org.eclipse.rcptt.core.ecl.parser.model.PathBuilder;
import org.eclipse.rcptt.core.ecl.parser.model.Proposal;

public class Completer {
    private static final Suggestion fail = new Suggestion(false, null, null);

    public static List<Proposal> proposals(Script script, int offset, IDeclContainer container) {
        ArrayList<Proposal> result = new ArrayList<Proposal>();
        NodePath path = PathBuilder.path(script, offset, true);
        Suggestion isCommandName = Completer.isCommandName(path);
        if (isCommandName.isTrue) {
            return Completer.filter(Completer.topLevelProposals(container), isCommandName.prefix);
        }
        Suggestion isCommandArg = Completer.isCommandArg(path);
        if (isCommandArg.isTrue) {
            return Completer.filter(Completer.join(Completer.argNameProposals(isCommandArg.command, container), Completer.varValueProposals(container)), isCommandArg.prefix);
        }
        if (path.endsWith(Script.class)) {
            return Completer.topLevelProposals(container);
        }
        return result;
    }

    private static Suggestion isCommandArg(NodePath path) {
        if (path.endsWith(Command.class, Arg.class, Id.class)) {
            return Completer.pass(path.lastOf(Id.class).text, path.lastOf(Command.class));
        }
        if (path.endsWith(Command.class)) {
            return Completer.pass("", path.lastOf(Command.class));
        }
        int offset = Completer.rollbackToNonSpace(path);
        if (offset == 0) {
            return fail;
        }
        NodePath lastCharPath = PathBuilder.path(path.script, offset);
        if (lastCharPath.lastNode() == path.lastNode()) {
            return fail;
        }
        Command command = lastCharPath.lastOf(Command.class);
        if (command == null) {
            return fail;
        }
        return Completer.pass(command);
    }

    private static int rollbackToNonSpace(NodePath path) {
        String text = path.script.text;
        int offset = path.offset;
        while (Completer.spaceOrTabOrEOF(text, offset) && offset > 0) {
            --offset;
        }
        return offset;
    }

    private static boolean spaceOrTabOrEOF(String text, int offset) {
        return offset >= 0 && (text.length() <= offset || text.charAt(offset) == ' ' || text.charAt(offset) == '\t');
    }

    private static Suggestion isCommandName(NodePath path) {
        Node last = path.lastNode();
        Command lastCommand = path.lastOf(Command.class);
        if (!(last instanceof Id)) {
            return fail;
        }
        if (lastCommand == null) {
            return fail;
        }
        if (!lastCommand.name.containsOrEnds(path.offset)) {
            return fail;
        }
        return Completer.pass(Completer.upto(lastCommand.name, path.offset));
    }

    private static String upto(Id id, int offset) {
        return id.text.substring(0, offset - id.begin);
    }

    private static List<Proposal> filter(List<Proposal> proposals, String prefix) {
        if (prefix == null) {
            return proposals;
        }
        prefix = prefix.toLowerCase();
        ArrayList<Proposal> result = new ArrayList<Proposal>();
        for (Proposal p : proposals) {
            if (!p.startsWith(prefix)) continue;
            result.add(p);
            p.prefixLength = prefix.length();
        }
        return result;
    }

    private static List<Proposal> topLevelProposals(IDeclContainer cont) {
        return Completer.join(Completer.varValueProposals(cont), Completer.commandNameProposals(cont));
    }

    private static List<Proposal> argNameProposals(Command command, IDeclContainer cont) {
        ArrayList<Proposal> result = new ArrayList<Proposal>();
        ProcDecl proc = cont.resolveProc(command.name.text);
        if (proc == null) {
            return result;
        }
        HashSet<String> usedArgs = new HashSet<String>();
        for (Arg arg : command.args) {
            if (arg.name == null) continue;
            usedArgs.add(arg.name.text.substring(1));
        }
        ArgDecl[] argDeclArray = proc.getArgs();
        int n = argDeclArray.length;
        int n2 = 0;
        while (n2 < n) {
            ArgDecl argDecl = argDeclArray[n2];
            if (!usedArgs.contains(argDecl.name)) {
                result.add(new Proposal.ArgNameProposal(argDecl));
            }
            ++n2;
        }
        return result;
    }

    private static List<Proposal> commandNameProposals(IDeclContainer cont) {
        ArrayList<Proposal> result = new ArrayList<Proposal>();
        ProcDecl[] procDeclArray = cont.getProcs();
        int n = procDeclArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProcDecl proc = procDeclArray[n2];
            result.add(new Proposal.ProcNameProposal(proc));
            ++n2;
        }
        return result;
    }

    private static List<Proposal> varValueProposals(IDeclContainer cont) {
        ArrayList<Proposal> result = new ArrayList<Proposal>();
        VarDecl[] varDeclArray = cont.getVars();
        int n = varDeclArray.length;
        int n2 = 0;
        while (n2 < n) {
            VarDecl var = varDeclArray[n2];
            result.add(new Proposal.VarValueProposal(var));
            ++n2;
        }
        return result;
    }

    private static List<Proposal> join(List<Proposal> ... proposals) {
        ArrayList<Proposal> result = new ArrayList<Proposal>();
        List<Proposal>[] listArray = proposals;
        int n = proposals.length;
        int n2 = 0;
        while (n2 < n) {
            List<Proposal> list = listArray[n2];
            result.addAll(list);
            ++n2;
        }
        return result;
    }

    private static Suggestion pass(String prefix) {
        return new Suggestion(true, prefix, null);
    }

    private static Suggestion pass(Command command) {
        return new Suggestion(true, null, command);
    }

    private static Suggestion pass(String prefix, Command command) {
        return new Suggestion(true, prefix, command);
    }

    private static class Suggestion {
        final boolean isTrue;
        final String prefix;
        final Command command;

        public Suggestion(boolean isTrue, String prefix, Command command) {
            this.isTrue = isTrue;
            this.prefix = prefix;
            this.command = command;
        }
    }
}

