/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.controls;

import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.rcptt.ui.controls.IEmbeddedComposite;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class SectionWithToolbar {
    private final IEmbeddedComposite composite;
    private final int style;

    public SectionWithToolbar(IEmbeddedComposite composite, int style) {
        this.composite = composite;
        this.style = style;
    }

    public Section create(Composite parent, FormToolkit toolkit) {
        boolean twistie = (this.style & 2) != 0;
        boolean expanded = !twistie || (this.style & 0x40) != 0;
        final Section section = toolkit.createSection(parent, this.style | 0x4000);
        section.setText(this.composite.getName());
        GridDataFactory.fillDefaults().grab(true, expanded).applyTo((Control)section);
        Composite c = toolkit.createComposite((Composite)section);
        GridLayoutFactory.fillDefaults().extendedMargins(0, 0, 0, 5).applyTo(c);
        this.composite.createControl(c);
        Composite forToolbar = new Composite((Composite)section, 0);
        FillLayout fl = new FillLayout();
        forToolbar.setLayout((Layout)fl);
        if (Platform.getOS().equals("linux")) {
            fl.marginHeight = -2;
        }
        if (Platform.getOS().equals("macosx")) {
            fl.marginHeight = -2;
        }
        this.composite.createToolBar(forToolbar);
        section.setClient((Control)c);
        section.setTextClient((Control)forToolbar);
        if (twistie) {
            this.composite.setVisible(expanded);
            this.composite.observeVisible().addChangeListener(new IChangeListener(){

                public void handleChange(ChangeEvent event) {
                    GridDataFactory.fillDefaults().grab(true, SectionWithToolbar.this.composite.getVisible()).applyTo((Control)section);
                    section.setExpanded(SectionWithToolbar.this.composite.getVisible());
                }
            });
            section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                public void expansionStateChanged(ExpansionEvent e) {
                    SectionWithToolbar.this.composite.setVisible(section.isExpanded());
                }
            });
        }
        return section;
    }
}

