/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.report;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.reporting.core.IReportRenderer;

public class WorkspaceContentFactory
implements IReportRenderer.IContentFactory {
    private IPath root;

    public WorkspaceContentFactory(IPath folder) {
        this.root = folder;
    }

    public IReportRenderer.IContentFactory createFolder(String name) {
        return new WorkspaceContentFactory(this.root.append(name));
    }

    public OutputStream createFileStream(final String fname) throws CoreException {
        try {
            final File tmpFile = File.createTempFile("q7_workspace_report_temp", "tmp");
            return new BufferedOutputStream(new FileOutputStream(tmpFile)){

                @Override
                public void close() throws IOException {
                    super.close();
                    IFile file = WorkspaceContentFactory.this.getFile(fname);
                    if (file.exists()) {
                        try {
                            file.setContents((InputStream)new BufferedInputStream(new FileInputStream(tmpFile)), true, true, (IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (CoreException e) {
                            Q7UIPlugin.log(e);
                        }
                    } else {
                        try {
                            file.create((InputStream)new BufferedInputStream(new FileInputStream(tmpFile)), true, (IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (CoreException e) {
                            Q7UIPlugin.log(e);
                        }
                    }
                    tmpFile.delete();
                }
            };
        }
        catch (IOException e1) {
            Q7UIPlugin.log(e1.getMessage(), e1);
            throw new CoreException(Q7UIPlugin.createStatus(e1.getMessage(), e1));
        }
    }

    public boolean isFileExist(String fname) {
        return this.getFile(fname).exists();
    }

    private IFile getFile(String fname) {
        this.getRootFolder();
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(this.root.append(fname));
        return file;
    }

    private IContainer getRootFolder() {
        IFolder folder = null;
        if (this.root.segmentCount() > 1) {
            folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(this.root);
        } else if (this.root.segmentCount() == 1) {
            folder = ResourcesPlugin.getWorkspace().getRoot().getProject(this.root.segment(0));
        }
        if (folder != null) {
            this.checkCreateFolders((IContainer)folder);
        }
        return folder;
    }

    private void checkCreateFolders(IContainer folder) {
        if (!folder.exists()) {
            IContainer parent = folder.getParent();
            if (parent instanceof IFolder) {
                this.checkCreateFolders((IContainer)((IFolder)parent));
            }
            if (folder instanceof IFolder) {
                try {
                    ((IFolder)folder).create(true, true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    Q7UIPlugin.log(e);
                }
            }
        }
    }

    public List<String> matchFiles(final String fname) {
        final HashSet<String> result = new HashSet<String>();
        if (this.isFileExist(fname)) {
            result.add(fname);
        }
        try {
            this.getRootFolder().accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    String name = resource.getFullPath().removeFirstSegments(WorkspaceContentFactory.this.root.segmentCount()).toString();
                    if (Pattern.matches(fname, name)) {
                        result.add(name);
                    }
                    return true;
                }
            });
        }
        catch (Exception e) {
            RcpttPlugin.log((Throwable)e);
        }
        return new ArrayList<String>(result);
    }

    public void removeFileOrFolder(String name) throws CoreException {
        IResource member = this.getRootFolder().findMember(name);
        if (member.exists()) {
            member.delete(true, null);
        }
    }
}

