/*******************************************************************************
 * Copyright (c) 2009, 2019 Xored Software Inc and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-v20.html
 *
 * Contributors:
 * 	Xored Software Inc - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.rcptt.tesla.recording.core.ecl.rap.parser;

import java.util.List;

import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.core.Pipeline;
import org.eclipse.rcptt.ecl.core.util.ScriptletFactory;
import org.eclipse.rcptt.tesla.core.protocol.ProtocolPackage;
import org.eclipse.rcptt.tesla.core.protocol.RapDownloadFile;
import org.eclipse.rcptt.tesla.core.protocol.RapUploadFile;
import org.eclipse.rcptt.tesla.ecl.TeslaScriptletFactory;
import org.eclipse.rcptt.tesla.ecl.model.VerifyTrue;
import org.eclipse.rcptt.tesla.ecl.rap.model.DownloadFile;
import org.eclipse.rcptt.tesla.ecl.rap.model.ExecWithoutJs;
import org.eclipse.rcptt.tesla.ecl.rap.model.MatchBinary;
import org.eclipse.rcptt.tesla.ecl.rap.model.RapTeslaFactory;
import org.eclipse.rcptt.tesla.ecl.rap.model.UploadFile;
import org.eclipse.rcptt.tesla.recording.core.ecl.TeslaCommand;
import org.eclipse.rcptt.tesla.recording.core.ecl.parser.TeslaParser;
import org.eclipse.rcptt.util.StringUtils;

public class RapTeslaParser {

	@TeslaCommand(packageUri = ProtocolPackage.eNS_URI, classifier = "RapDownloadFile")
	public static Command downloadFile(TeslaParser parser, RapDownloadFile file) {
		final ExecWithoutJs command = RapTeslaFactory.eINSTANCE.createExecWithoutJs();

		final DownloadFile download = RapTeslaFactory.eINSTANCE.createDownloadFile();

		download.setHandlerId(file.getHandler());
		download.setUrl(file.getUrl());

		final MatchBinary matching = RapTeslaFactory.eINSTANCE.createMatchBinary();
		matching.setBase64(file.getContent());

		final VerifyTrue verify = TeslaScriptletFactory.makeVerifyTrue();

		final Pipeline pipe = ScriptletFactory.makePipe(download, matching, verify);

		//replace last command
		final List<Command> script = parser.getScriptCommand();
		if (!script.isEmpty()) {
			final Command replaced = script.get(script.size() - 1);
			command.setCommand(ScriptletFactory.makeSeq(EcoreUtil.copy(replaced) ,pipe));
			parser.removeCommand(replaced);
		} else {
			command.setCommand(ScriptletFactory.makeSeq(pipe));
		}

		return command;
	}

	@TeslaCommand(packageUri = ProtocolPackage.eNS_URI, classifier = "RapUploadFile")
	public static Command rapUploadFile(TeslaParser parser, RapUploadFile file) {
		final UploadFile upload = RapTeslaFactory.eINSTANCE.createUploadFile();
		if (!StringUtils.isEmpty(file.getBase64file())) {
			upload.setBase64(file.getBase64file());
		}

		return upload;
	}
}
