/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.internal.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rcptt.ecl.internal.core.CorePlugin;
import org.eclipse.rcptt.ecl.runtime.IParamConverter;

public class ParamConverterManager {
    private static ParamConverterManager instance;
    private static final String CONVERTER_EXTPT = "org.eclipse.rcptt.ecl.core.param_converter";
    private static final String CONVERTER_CLASS_ATTR = "class";
    private Map<Class<?>, IParamConverter<?>> converters;

    public static ParamConverterManager getInstance() {
        if (instance == null) {
            instance = new ParamConverterManager();
        }
        return instance;
    }

    private ParamConverterManager() {
    }

    public <T> IParamConverter<T> getConverter(Class<T> type) {
        if (this.converters == null) {
            this.loadScriptlets();
        }
        return this.converters.get(type);
    }

    public boolean hasConverter(Class<?> type) {
        if (this.converters == null) {
            this.loadScriptlets();
        }
        return this.converters.containsKey(type);
    }

    private void loadScriptlets() {
        IConfigurationElement[] configs;
        this.converters = new HashMap();
        IConfigurationElement[] iConfigurationElementArray = configs = Platform.getExtensionRegistry().getConfigurationElementsFor(CONVERTER_EXTPT);
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement config = iConfigurationElementArray[n2];
            try {
                IParamConverter converter = (IParamConverter)config.createExecutableExtension(CONVERTER_CLASS_ATTR);
                this.addConverter(converter);
            }
            catch (CoreException e) {
                CorePlugin.getDefault().getLog().log(e.getStatus());
            }
            ++n2;
        }
    }

    private <T> void addConverter(IParamConverter<T> converter) {
        Class<T> clazz = converter.forType();
        this.converters.put(clazz, converter);
    }
}

