/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.launching.ext;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.internal.launching.DetectVMInstallationsJob;
import org.eclipse.jdt.internal.launching.LaunchingPlugin;
import org.eclipse.jdt.launching.AbstractVMInstall;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMStandin;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.internal.launching.ext.OSArchitecture;

public class JDTUtils {
    private static final String SUN_ARCH_DATA_MODEL = "sun.arch.data.model";
    private static final String JAVA_VM_INFO = "java.vm.info";
    private static final String OS_ARCH = "os.arch";
    private static final ILog LOG = Platform.getLog(JDTUtils.class);
    private static final AtomicInteger FREE_ID = new AtomicInteger(1);

    private static IVMInstall registerCurrentJVM() {
        try {
            return JDTUtils.registerVM(new File(System.getProperty("java.home")));
        }
        catch (CoreException e) {
            LOG.log(e.getStatus());
            throw new IllegalStateException(e);
        }
    }

    public static Map<String, String> evaluateSystemPropertiesInThread(AbstractVMInstall install, IProgressMonitor monitor, int timeout) throws CoreException {
        GetPropertiesThread thread = new GetPropertiesThread(install, monitor);
        thread.start();
        try {
            thread.join(timeout);
        }
        catch (InterruptedException e) {
            RcpttPlugin.log((Throwable)e);
        }
        thread.interrupt();
        if (thread.getCoreException() != null) {
            throw thread.getCoreException();
        }
        return thread.getMap();
    }

    protected static void abort(String message, Throwable exception, int code) throws CoreException {
        throw new CoreException((IStatus)new Status(4, LaunchingPlugin.getUniqueIdentifier(), code, message, exception));
    }

    public static Map<String, String> evaluateSystemProperties(AbstractVMInstall install, IProgressMonitor monitor) throws CoreException {
        String[] properties = new String[]{OS_ARCH, "java.version", "java.specification.name", "java.specification.version", JAVA_VM_INFO, "java.vm.name", "java.vm.version", "java.runtime.name", "java.runtime.version", SUN_ARCH_DATA_MODEL};
        return install.evaluateSystemProperties(properties, monitor);
    }

    public static Map<String, String> getProperties(IVMInstall install) throws CoreException {
        if (install instanceof AbstractVMInstall) {
            AbstractVMInstall avi = (AbstractVMInstall)install;
            Map<String, String> properties = JDTUtils.evaluateSystemPropertiesInThread(avi, (IProgressMonitor)new NullProgressMonitor(), 60000);
            return properties;
        }
        throw new CoreException(RcpttPlugin.createStatus((String)("Failed to get JVM properties. Unknown JVM installation type: " + install.getClass().getName())));
    }

    public static OSArchitecture detect(IVMInstall install) throws CoreException {
        Preconditions.checkNotNull((Object)install);
        try {
            return JDTUtils.detect(JDTUtils.getProperties(install));
        }
        catch (CoreException e) {
            throw new CoreException(RcpttPlugin.createStatus((String)("Failed to get JVM arhitecture for " + String.valueOf(install.getInstallLocation())), (Throwable)e));
        }
    }

    private static OSArchitecture detect(Map<String, String> properties) throws CoreException {
        String arch = properties.get(OS_ARCH);
        if ("amd64".equals(arch)) {
            return OSArchitecture.x86_64;
        }
        if ("x86_64".equals(arch)) {
            return OSArchitecture.x86_64;
        }
        if ("i386".equals(arch)) {
            return OSArchitecture.x86;
        }
        if ("i686".equals(arch)) {
            return OSArchitecture.x86;
        }
        if ("i586".equals(arch)) {
            return OSArchitecture.x86;
        }
        if ("aarch64".equals(arch)) {
            return OSArchitecture.aarch64;
        }
        String model = properties.get(SUN_ARCH_DATA_MODEL);
        if (model != null && "32".equals(model)) {
            return OSArchitecture.x86;
        }
        if (model != null && "64".equals(model)) {
            return OSArchitecture.x86_64;
        }
        String message = String.format("Unknown combination:  %s = %s and %s = %s", SUN_ARCH_DATA_MODEL, model, OS_ARCH, arch);
        throw new CoreException(RcpttPlugin.createStatus((String)message));
    }

    public static IVMInstall registerVM(File jvmInstallationLocation) throws CoreException {
        String name;
        String id;
        IVMInstall found;
        File jvmInstallationLocationCopy;
        try {
            jvmInstallationLocationCopy = jvmInstallationLocation.getCanonicalFile();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid VM path " + String.valueOf(jvmInstallationLocation), e);
        }
        if (!jvmInstallationLocationCopy.exists()) {
            throw new CoreException(Status.error((String)("JVM location " + String.valueOf(jvmInstallationLocationCopy) + " does not exist")));
        }
        Optional<IVMInstall> first = JDTUtils.registeredInstalls().filter(i -> {
            try {
                return i.getInstallLocation().getCanonicalFile().equals(jvmInstallationLocationCopy);
            }
            catch (IOException e) {
                LOG.error("Invalid JVM path " + String.valueOf(i.getInstallLocation()));
                return false;
            }
        }).findFirst();
        if (first.isPresent()) {
            return first.get();
        }
        IVMInstallType type = JavaRuntime.getVMInstallType((String)"org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType");
        IStatus status = type.validateInstallLocation(jvmInstallationLocationCopy);
        if (status.matches(12)) {
            throw new CoreException(status);
        }
        while ((found = type.findVMInstall(id = (name = "RCPTT JVM " + FREE_ID.getAndIncrement()).replace(' ', '_'))) != null) {
        }
        VMStandin standin = new VMStandin(type, id);
        standin.setInstallLocation(jvmInstallationLocationCopy);
        standin.setName(name);
        IVMInstall result = standin.convertToRealVM();
        try {
            assert (result.getInstallLocation().getCanonicalFile().equals(jvmInstallationLocation));
        }
        catch (IOException e) {
            throw new CoreException(Status.error((String)("Can't register JVM from " + String.valueOf(jvmInstallationLocation)), (Throwable)e));
        }
        return result;
    }

    public static final Stream<IVMInstall> installedVms() {
        Stream<IVMInstall> preinstalled = JDTUtils.registeredInstalls();
        Stream<IVMInstall> currentJVM = Stream.generate(JDTUtils::registerCurrentJVM).limit(1L);
        return Stream.concat(preinstalled, currentJVM);
    }

    private static Stream<IVMInstall> registeredInstalls() {
        JavaRuntime.getVMInstallTypes();
        try {
            Job.getJobManager().join(DetectVMInstallationsJob.class, null);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new OperationCanceledException();
        }
        return Arrays.stream(JavaRuntime.getVMInstallTypes()).map(IVMInstallType::getVMInstalls).flatMap(Arrays::stream);
    }

    static class GetPropertiesThread
    extends Thread {
        private Map<String, String> map = new HashMap<String, String>();
        private CoreException coreException;
        private final AbstractVMInstall install;
        private final IProgressMonitor monitor;

        public Map<String, String> getMap() {
            return this.map;
        }

        public CoreException getCoreException() {
            return this.coreException;
        }

        public GetPropertiesThread(AbstractVMInstall install, IProgressMonitor monitor) {
            this.install = install;
            this.monitor = new ProgressMonitorWrapper(monitor){

                public boolean isCanceled() {
                    return super.isCanceled() || Thread.interrupted();
                }
            };
        }

        @Override
        public void run() {
            try {
                this.map = JDTUtils.evaluateSystemProperties(this.install, this.monitor);
            }
            catch (CoreException e) {
                this.coreException = e;
            }
        }
    }
}

