/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.queryrender;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class VarNameNormalizer {
    private static final List<String> DEFAULT_PREFIXES = Arrays.asList("_anon_collection_", "_anon_path_inverse_", "_anon_path_", "_anon_having_", "_anon_");

    private VarNameNormalizer() {
    }

    public static String normalizeVars(String input) {
        return VarNameNormalizer.normalizeVars(input, DEFAULT_PREFIXES);
    }

    public static String normalizeVars(String input, List<String> families) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        ArrayList<String> fams = new ArrayList<String>(families);
        fams.sort((a, b) -> Integer.compare(b.length(), a.length()));
        HashMap<String, BitSet> reserved = new HashMap<String, BitSet>();
        for (String f : fams) {
            reserved.put(f, new BitSet());
        }
        String shared = VarNameNormalizer.sharedPrefixEndingWithUnderscore(fams);
        if (!shared.isEmpty()) {
            VarNameNormalizer.reservePreNumberedFast(input, fams, reserved, shared);
            return VarNameNormalizer.rewriteHashedFast(input, fams, reserved, shared);
        }
        Map<Character, List<String>> byFirst = VarNameNormalizer.bucketByFirstChar(fams);
        VarNameNormalizer.reservePreNumberedGeneric(input, byFirst, reserved);
        return VarNameNormalizer.rewriteHashedGeneric(input, byFirst, reserved);
    }

    private static void reservePreNumberedFast(String s, List<String> fams, Map<String, BitSet> reserved, String shared) {
        int n = s.length();
        int i = s.indexOf(shared, 0);
        while (i >= 0) {
            int tailStart;
            String family;
            if ((i == 0 || !VarNameNormalizer.isWordChar(s.charAt(i - 1))) && (family = VarNameNormalizer.matchFamilyAt(s, i, fams)) != null && (tailStart = i + family.length()) < n && VarNameNormalizer.isWordChar(s.charAt(tailStart))) {
                int j;
                for (j = tailStart + 1; j < n && VarNameNormalizer.isWordChar(s.charAt(j)); ++j) {
                }
                int num = VarNameNormalizer.parsePositiveIntOrMinusOne(s, tailStart, j);
                if (num >= 0) {
                    reserved.get(family).set(num);
                }
            }
            i = s.indexOf(shared, i + 1);
        }
    }

    private static String rewriteHashedFast(String s, List<String> fams, Map<String, BitSet> reserved, String shared) {
        int n = s.length();
        StringBuilder out = new StringBuilder(n + 16);
        LinkedHashMap<String, Object> mapping = new LinkedHashMap<String, Object>();
        int writePos = 0;
        int i = s.indexOf(shared, 0);
        while (i >= 0) {
            int j;
            if (i != 0 && VarNameNormalizer.isWordChar(s.charAt(i - 1))) {
                i = s.indexOf(shared, i + 1);
                continue;
            }
            String family = VarNameNormalizer.matchFamilyAt(s, i, fams);
            if (family == null) {
                i = s.indexOf(shared, i + 1);
                continue;
            }
            int tailStart = i + family.length();
            if (tailStart >= n || !VarNameNormalizer.isWordChar(s.charAt(tailStart))) {
                i = s.indexOf(shared, i + 1);
                continue;
            }
            for (j = tailStart + 1; j < n && VarNameNormalizer.isWordChar(s.charAt(j)); ++j) {
            }
            if (VarNameNormalizer.isAllDigits(s, tailStart, j)) {
                out.append(s, writePos, j);
                writePos = j;
            } else {
                String original = s.substring(i, j);
                Object replacement = (String)mapping.get(original);
                if (replacement == null) {
                    BitSet bs = reserved.get(family);
                    int next = bs.nextClearBit(1);
                    bs.set(next);
                    replacement = family + next;
                    mapping.put(original, replacement);
                }
                out.append(s, writePos, i).append((String)replacement);
                writePos = j;
            }
            i = s.indexOf(shared, j);
        }
        out.append(s, writePos, n);
        return out.toString();
    }

    private static String matchFamilyAt(String s, int i, List<String> fams) {
        int n = s.length();
        for (String f : fams) {
            int len = f.length();
            if (i + len > n) continue;
            boolean ok = true;
            for (int k = 0; k < len; ++k) {
                if (s.charAt(i + k) == f.charAt(k)) continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            return f;
        }
        return null;
    }

    private static void reservePreNumberedGeneric(String s, Map<Character, List<String>> byFirst, Map<String, BitSet> reserved) {
        int n = s.length();
        int i = 0;
        while (i < n) {
            int j;
            char c = s.charAt(i);
            if (i != 0 && VarNameNormalizer.isWordChar(s.charAt(i - 1))) {
                ++i;
                continue;
            }
            List<String> cand = byFirst.get(Character.valueOf(c));
            if (cand == null) {
                ++i;
                continue;
            }
            String family = VarNameNormalizer.matchFamilyAtFromBucket(s, i, cand);
            if (family == null) {
                ++i;
                continue;
            }
            int tailStart = i + family.length();
            if (tailStart >= n || !VarNameNormalizer.isWordChar(s.charAt(tailStart))) {
                ++i;
                continue;
            }
            for (j = tailStart + 1; j < n && VarNameNormalizer.isWordChar(s.charAt(j)); ++j) {
            }
            int num = VarNameNormalizer.parsePositiveIntOrMinusOne(s, tailStart, j);
            if (num >= 0) {
                reserved.get(family).set(num);
            }
            i = j;
        }
    }

    private static String rewriteHashedGeneric(String s, Map<Character, List<String>> byFirst, Map<String, BitSet> reserved) {
        int n = s.length();
        StringBuilder out = new StringBuilder(n + 16);
        LinkedHashMap<String, Object> mapping = new LinkedHashMap<String, Object>();
        int writePos = 0;
        int i = 0;
        while (i < n) {
            int j;
            char c = s.charAt(i);
            if (i != 0 && VarNameNormalizer.isWordChar(s.charAt(i - 1))) {
                ++i;
                continue;
            }
            List<String> cand = byFirst.get(Character.valueOf(c));
            if (cand == null) {
                ++i;
                continue;
            }
            String family = VarNameNormalizer.matchFamilyAtFromBucket(s, i, cand);
            if (family == null) {
                ++i;
                continue;
            }
            int tailStart = i + family.length();
            if (tailStart >= n || !VarNameNormalizer.isWordChar(s.charAt(tailStart))) {
                ++i;
                continue;
            }
            for (j = tailStart + 1; j < n && VarNameNormalizer.isWordChar(s.charAt(j)); ++j) {
            }
            if (VarNameNormalizer.isAllDigits(s, tailStart, j)) {
                out.append(s, writePos, j);
                writePos = j;
            } else {
                String original = s.substring(i, j);
                Object replacement = (String)mapping.get(original);
                if (replacement == null) {
                    BitSet bs = reserved.get(family);
                    int next = bs.nextClearBit(1);
                    bs.set(next);
                    replacement = family + next;
                    mapping.put(original, replacement);
                }
                out.append(s, writePos, i).append((String)replacement);
                writePos = j;
            }
            i = j;
        }
        out.append(s, writePos, n);
        return out.toString();
    }

    private static Map<Character, List<String>> bucketByFirstChar(List<String> fams) {
        HashMap<Character, List<String>> byFirst = new HashMap<Character, List<String>>();
        for (String f : fams) {
            char c = f.charAt(0);
            byFirst.computeIfAbsent(Character.valueOf(c), k -> new ArrayList()).add(f);
        }
        return byFirst;
    }

    private static String matchFamilyAtFromBucket(String s, int i, List<String> fams) {
        int n = s.length();
        for (String f : fams) {
            int len = f.length();
            if (i + len > n) continue;
            boolean ok = true;
            for (int k = 0; k < len; ++k) {
                if (s.charAt(i + k) == f.charAt(k)) continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            return f;
        }
        return null;
    }

    private static String sharedPrefixEndingWithUnderscore(List<String> fams) {
        if (fams.isEmpty()) {
            return "";
        }
        char[] acc = fams.get(0).toCharArray();
        int end = acc.length;
        block0: for (int i = 1; i < fams.size(); ++i) {
            String f = fams.get(i);
            end = Math.min(end, f.length());
            for (int k = 0; k < end; ++k) {
                if (acc[k] == f.charAt(k)) continue;
                end = k;
                continue block0;
            }
        }
        while (end > 0 && acc[end - 1] != '_') {
            --end;
        }
        if (end == 0) {
            return "";
        }
        return new String(acc, 0, end);
    }

    private static boolean isAllDigits(String s, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (Character.isDigit(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isWordChar(char c) {
        return Character.isLetterOrDigit(c) || c == '_';
    }

    private static int parsePositiveIntOrMinusOne(String s, int start, int end) {
        int n = 0;
        for (int i = start; i < end; ++i) {
            char c = s.charAt(i);
            if (!Character.isDigit(c)) {
                return -1;
            }
            n = n * 10 + (c - 48);
        }
        return n;
    }
}

