/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.parser.sparql;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.rdf4j.common.annotation.InternalUseOnly;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.parser.sparql.AbstractASTVisitor;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTBasicGraphPattern;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTBlankNode;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTBlankNodePropertyList;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTCollection;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTOperationContainer;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTVar;
import org.eclipse.rdf4j.query.parser.sparql.ast.VisitorException;

@InternalUseOnly
public class BlankNodeVarProcessor
extends AbstractASTVisitor {
    public static Set<String> process(ASTOperationContainer qc) throws MalformedQueryException {
        try {
            BlankNodeToVarConverter converter = new BlankNodeToVarConverter();
            qc.jjtAccept(converter, null);
            return converter.getUsedBNodeIDs();
        }
        catch (VisitorException e) {
            throw new MalformedQueryException(e);
        }
    }

    private static class BlankNodeToVarConverter
    extends AbstractASTVisitor {
        private int anonVarNo = 1;
        private final Map<String, String> conversionMap = new HashMap<String, String>();
        private final Set<String> usedBNodeIDs = new HashSet<String>();

        private BlankNodeToVarConverter() {
        }

        private String createAnonVarName() {
            return "_anon_bnode_" + this.anonVarNo++;
        }

        private String createAnonUserVarName() {
            return "_anon_user_bnode_" + this.anonVarNo++;
        }

        private String createAnonCollectionVarName() {
            return "_anon_collection_" + this.anonVarNo++;
        }

        public Set<String> getUsedBNodeIDs() {
            this.usedBNodeIDs.addAll(this.conversionMap.keySet());
            return Collections.unmodifiableSet(this.usedBNodeIDs);
        }

        @Override
        public Object visit(ASTBasicGraphPattern node, Object data) throws VisitorException {
            this.usedBNodeIDs.addAll(this.conversionMap.keySet());
            this.conversionMap.clear();
            return super.visit(node, data);
        }

        @Override
        public Object visit(ASTBlankNode node, Object data) throws VisitorException {
            String bnodeID = node.getID();
            String varName = this.findVarName(bnodeID);
            if (varName == null) {
                varName = bnodeID == null ? this.createAnonVarName() : this.createAnonUserVarName();
                if (bnodeID != null) {
                    this.conversionMap.put(bnodeID, varName);
                }
            }
            ASTVar varNode = new ASTVar(49);
            varNode.setName(varName);
            varNode.setAnonymous(true);
            node.jjtReplaceWith(varNode);
            return super.visit(node, data);
        }

        private String findVarName(String bnodeID) throws VisitorException {
            if (bnodeID == null) {
                return null;
            }
            String varName = this.conversionMap.get(bnodeID);
            if (varName == null && this.usedBNodeIDs.contains(bnodeID)) {
                throw new VisitorException("BNodeID already used in another scope: " + bnodeID);
            }
            return varName;
        }

        @Override
        public Object visit(ASTBlankNodePropertyList node, Object data) throws VisitorException {
            node.setVarName(this.createAnonVarName());
            return super.visit(node, data);
        }

        @Override
        public Object visit(ASTCollection node, Object data) throws VisitorException {
            node.setVarName(this.createAnonCollectionVarName());
            return super.visit(node, data);
        }
    }
}

