/*
 * Decompiled with CFR 0.152.
 */
package no.hasmac.jsonld.lang;

import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.util.Arrays;
import java.util.Map;
import no.hasmac.jsonld.json.JsonUtils;
import no.hasmac.jsonld.lang.Keywords;
import no.hasmac.jsonld.lang.ValueObject;
import no.hasmac.jsonld.uri.UriUtils;

public final class NodeObject {
    private NodeObject() {
    }

    public static boolean isNodeObject(JsonValue value) {
        return JsonUtils.isObject(value) && (!value.asJsonObject().containsKey((Object)"@value") && !value.asJsonObject().containsKey((Object)"@list") && !value.asJsonObject().containsKey((Object)"@set") || Arrays.asList("@context", "@graph").containsAll(value.asJsonObject().keySet()));
    }

    public static boolean isNotNodeObject(JsonValue value) {
        return !NodeObject.isNodeObject(value);
    }

    public static boolean isNodeReference(JsonValue value) {
        return JsonUtils.containsKey(value, "@id") && value.asJsonObject().size() == 1;
    }

    public static boolean isEmbeddedNode(JsonValue value) {
        if (JsonUtils.isNotObject(value)) {
            return false;
        }
        JsonObject node = value.asJsonObject();
        boolean found = false;
        for (Map.Entry property : node.entrySet()) {
            if (((String)property.getKey()).equals("@index") || ((String)property.getKey()).equals("@context") || ((String)property.getKey()).equals("@reverse")) {
                return false;
            }
            if (!"@type".equals(property.getKey()) && Keywords.matchForm((String)property.getKey())) continue;
            if (!found && ("@type".equals(property.getKey()) || UriUtils.isURI((String)property.getKey()))) {
                JsonValue propertyValue = (JsonValue)property.getValue();
                if (JsonUtils.isArray(propertyValue)) {
                    if (propertyValue.asJsonArray().size() != 1) {
                        return false;
                    }
                    propertyValue = (JsonValue)propertyValue.asJsonArray().get(0);
                }
                if (ValueObject.isValueObject(propertyValue)) {
                    propertyValue = ValueObject.getValue(propertyValue).orElse(null);
                }
                if (JsonUtils.isString(propertyValue) || JsonUtils.isObject(propertyValue) && NodeObject.isEmbeddedNode((JsonValue)propertyValue.asJsonObject())) {
                    found = true;
                    continue;
                }
            }
            return false;
        }
        return true;
    }

    public static boolean isNotAnnotationObject(JsonValue annotation) {
        return !NodeObject.isAnnotationObject(annotation);
    }

    public static boolean isAnnotationObject(JsonValue annotation) {
        JsonValue value = annotation;
        if (JsonUtils.isArray(value)) {
            return value.asJsonArray().stream().allMatch(NodeObject::isAnnotationObject);
        }
        if (JsonUtils.isNotObject(value)) {
            return false;
        }
        for (Map.Entry property : value.asJsonObject().entrySet()) {
            if ("@annotation".equals(property.getKey()) && !NodeObject.isAnnotationObject((JsonValue)property.getValue())) {
                return false;
            }
            if (!Keywords.matchForm((String)property.getKey()) || "@type".equals(property.getKey()) || "@reverse".equals(property.getKey())) continue;
            return false;
        }
        return true;
    }
}

