/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.helpers.collectors;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractSimpleQueryModelVisitor;

public class VarNameCollector
extends AbstractSimpleQueryModelVisitor<RuntimeException> {
    private final List<String> varNames = new ArrayList<String>();
    private Set<String> varNamesSet;

    public VarNameCollector() {
        super(true);
    }

    public static Set<String> process(QueryModelNode node) {
        VarNameCollector collector = new VarNameCollector();
        node.visit(collector);
        return collector.getVarNames();
    }

    public static Set<String> process(List<? extends QueryModelNode> nodes) {
        VarNameCollector collector = new VarNameCollector();
        for (QueryModelNode queryModelNode : nodes) {
            queryModelNode.visit(collector);
        }
        return collector.getVarNames();
    }

    public Set<String> getVarNames() {
        if (this.varNamesSet == null) {
            this.varNamesSet = this.varNames.isEmpty() ? Set.of() : (this.varNames.size() == 1 ? Set.of(this.varNames.get(0)) : new LinkedHashSet<String>(this.varNames));
        }
        return this.varNamesSet;
    }

    @Override
    public void meet(Var var) {
        if (!var.hasValue()) {
            this.varNames.add(var.getName());
        }
    }
}

