/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.ext.macros;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jivesoftware.smackx.workgroup.ext.macros.Macro;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MacroGroup {
    private List<Macro> macros = new ArrayList<Macro>();
    private List<MacroGroup> macroGroups = new ArrayList<MacroGroup>();
    private String title;

    public void addMacro(Macro macro) {
        this.macros.add(macro);
    }

    public void removeMacro(Macro macro) {
        this.macros.remove(macro);
    }

    public Macro getMacroByTitle(String title) {
        List<Macro> col = Collections.unmodifiableList(this.macros);
        for (Macro macro : col) {
            if (!macro.getTitle().equalsIgnoreCase(title)) continue;
            return macro;
        }
        return null;
    }

    public void addMacroGroup(MacroGroup group) {
        this.macroGroups.add(group);
    }

    public void removeMacroGroup(MacroGroup group) {
        this.macroGroups.remove(group);
    }

    public Macro getMacro(int location) {
        return this.macros.get(location);
    }

    public MacroGroup getMacroGroupByTitle(String title) {
        List<MacroGroup> col = Collections.unmodifiableList(this.macroGroups);
        for (MacroGroup group : col) {
            if (!group.getTitle().equalsIgnoreCase(title)) continue;
            return group;
        }
        return null;
    }

    public MacroGroup getMacroGroup(int location) {
        return this.macroGroups.get(location);
    }

    public List<Macro> getMacros() {
        return this.macros;
    }

    public void setMacros(List<Macro> macros) {
        this.macros = macros;
    }

    public List<MacroGroup> getMacroGroups() {
        return this.macroGroups;
    }

    public void setMacroGroups(List<MacroGroup> macroGroups) {
        this.macroGroups = macroGroups;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String toXML() {
        StringBuilder buf = new StringBuilder();
        buf.append("<macrogroup>");
        buf.append("<title>" + this.getTitle() + "</title>");
        buf.append("<macros>");
        for (Macro macro : this.getMacros()) {
            buf.append("<macro>");
            buf.append("<title>" + macro.getTitle() + "</title>");
            buf.append("<type>" + macro.getType() + "</type>");
            buf.append("<description>" + macro.getDescription() + "</description>");
            buf.append("<response>" + macro.getResponse() + "</response>");
            buf.append("</macro>");
        }
        buf.append("</macros>");
        if (this.getMacroGroups().size() > 0) {
            buf.append("<macroGroups>");
            for (MacroGroup groups : this.getMacroGroups()) {
                buf.append(groups.toXML());
            }
            buf.append("</macroGroups>");
        }
        buf.append("</macrogroup>");
        return buf.toString();
    }
}

