/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.packet;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscoverInfo
extends IQ {
    public static final String NAMESPACE = "http://jabber.org/protocol/disco#info";
    private final List<Feature> features = new CopyOnWriteArrayList<Feature>();
    private final List<Identity> identities = new CopyOnWriteArrayList<Identity>();
    private String node;

    public DiscoverInfo() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiscoverInfo(DiscoverInfo d) {
        super(d);
        this.setNode(d.getNode());
        List<Object> list = d.features;
        synchronized (list) {
            for (Feature f : d.features) {
                this.addFeature(f);
            }
        }
        list = d.identities;
        synchronized (list) {
            for (Identity i : d.identities) {
                this.addIdentity(i);
            }
        }
    }

    public void addFeature(String feature) {
        this.addFeature(new Feature(feature));
    }

    public void addFeatures(Collection<String> featuresToAdd) {
        if (featuresToAdd == null) {
            return;
        }
        for (String feature : featuresToAdd) {
            this.addFeature(feature);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFeature(Feature feature) {
        List<Feature> list = this.features;
        synchronized (list) {
            this.features.add(feature);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<Feature> getFeatures() {
        List<Feature> list = this.features;
        synchronized (list) {
            return Collections.unmodifiableList(this.features).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIdentity(Identity identity) {
        List<Identity> list = this.identities;
        synchronized (list) {
            this.identities.add(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIdentities(Collection<Identity> identitiesToAdd) {
        if (identitiesToAdd == null) {
            return;
        }
        List<Identity> list = this.identities;
        synchronized (list) {
            this.identities.addAll(identitiesToAdd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<Identity> getIdentities() {
        List<Identity> list = this.identities;
        synchronized (list) {
            return Collections.unmodifiableList(this.identities).iterator();
        }
    }

    public String getNode() {
        return this.node;
    }

    public void setNode(String node) {
        this.node = node;
    }

    public boolean containsFeature(String feature) {
        Iterator<Feature> it = this.getFeatures();
        while (it.hasNext()) {
            if (!feature.equals(it.next().getVar())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getChildElementXML() {
        StringBuilder buf = new StringBuilder();
        buf.append("<query xmlns=\"http://jabber.org/protocol/disco#info\"");
        if (this.getNode() != null) {
            buf.append(" node=\"");
            buf.append(StringUtils.escapeForXML(this.getNode()));
            buf.append("\"");
        }
        buf.append(">");
        List<Object> list = this.identities;
        synchronized (list) {
            for (Identity identity : this.identities) {
                buf.append(identity.toXML());
            }
        }
        list = this.features;
        synchronized (list) {
            for (Feature feature : this.features) {
                buf.append(feature.toXML());
            }
        }
        buf.append(this.getExtensionsXML());
        buf.append("</query>");
        return buf.toString();
    }

    public boolean containsDuplicateIdentities() {
        LinkedList<Identity> checkedIdentities = new LinkedList<Identity>();
        for (Identity i : this.identities) {
            for (Identity i2 : checkedIdentities) {
                if (!i.equals(i2)) continue;
                return true;
            }
            checkedIdentities.add(i);
        }
        return false;
    }

    public boolean containsDuplicateFeatures() {
        LinkedList<Feature> checkedFeatures = new LinkedList<Feature>();
        for (Feature f : this.features) {
            for (Feature f2 : checkedFeatures) {
                if (!f.equals(f2)) continue;
                return true;
            }
            checkedFeatures.add(f);
        }
        return false;
    }

    public static class Feature {
        private String variable;

        public Feature(String variable) {
            if (variable == null) {
                throw new IllegalArgumentException("variable cannot be null");
            }
            this.variable = variable;
        }

        public String getVar() {
            return this.variable;
        }

        public String toXML() {
            StringBuilder buf = new StringBuilder();
            buf.append("<feature var=\"").append(StringUtils.escapeForXML(this.variable)).append("\"/>");
            return buf.toString();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            Feature other = (Feature)obj;
            return this.variable.equals(other.variable);
        }

        public int hashCode() {
            return 37 * this.variable.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Identity
    implements Comparable<Identity> {
        private String category;
        private String name;
        private String type;
        private String lang;

        public Identity(String category, String name) {
            this.category = category;
            this.name = name;
        }

        public Identity(String category, String name, String type) {
            if (category == null || type == null) {
                throw new IllegalArgumentException("category and type cannot be null");
            }
            this.category = category;
            this.name = name;
            this.type = type;
        }

        public String getCategory() {
            return this.category;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setLanguage(String lang) {
            this.lang = lang;
        }

        public String getLanguage() {
            return this.lang;
        }

        public String toXML() {
            StringBuilder buf = new StringBuilder();
            buf.append("<identity");
            if (this.lang != null) {
                buf.append(" xml:lang=\"").append(StringUtils.escapeForXML(this.lang)).append("\"");
            }
            buf.append(" category=\"").append(StringUtils.escapeForXML(this.category)).append("\"");
            buf.append(" name=\"").append(StringUtils.escapeForXML(this.name)).append("\"");
            if (this.type != null) {
                buf.append(" type=\"").append(StringUtils.escapeForXML(this.type)).append("\"");
            }
            buf.append("/>");
            return buf.toString();
        }

        public boolean equals(Object obj) {
            String thisName;
            String thisType;
            String thisLang;
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            Identity other = (Identity)obj;
            if (!this.category.equals(other.category)) {
                return false;
            }
            String otherLang = other.lang == null ? "" : other.lang;
            String string = thisLang = this.lang == null ? "" : this.lang;
            if (!otherLang.equals(thisLang)) {
                return false;
            }
            String otherType = other.type == null ? "" : other.type;
            String string2 = thisType = this.type == null ? "" : this.type;
            if (!otherType.equals(thisType)) {
                return false;
            }
            String otherName = other.name == null ? "" : other.name;
            String string3 = thisName = this.name == null ? "" : other.name;
            return thisName.equals(otherName);
        }

        public int hashCode() {
            int result = 1;
            result = 37 * result + this.category.hashCode();
            result = 37 * result + (this.lang == null ? 0 : this.lang.hashCode());
            result = 37 * result + (this.type == null ? 0 : this.type.hashCode());
            result = 37 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        @Override
        public int compareTo(Identity other) {
            String thisType;
            String otherLang = other.lang == null ? "" : other.lang;
            String thisLang = this.lang == null ? "" : this.lang;
            String otherType = other.type == null ? "" : other.type;
            String string = thisType = this.type == null ? "" : this.type;
            if (this.category.equals(other.category)) {
                if (thisType.equals(otherType)) {
                    if (thisLang.equals(otherLang)) {
                        return 0;
                    }
                    return thisLang.compareTo(otherLang);
                }
                return thisType.compareTo(otherType);
            }
            return this.category.compareTo(other.category);
        }
    }
}

