/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.overviewplan.track;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.set.feature.overviewplan.track.OverviewplanTrack;
import org.eclipse.set.feature.overviewplan.track.TOPKanteMetaData;
import org.eclipse.set.feature.overviewplan.track.TrackNetworkService;
import org.eclipse.set.model.planpro.Geodaten.TOP_Kante;
import org.eclipse.set.model.planpro.Geodaten.TOP_Knoten;
import org.eclipse.set.model.siteplan.Position;
import org.eclipse.set.model.siteplan.SiteplanFactory;
import org.eclipse.set.ppmodel.extensions.TopKnotenExtensions;

public class TopKnotenPosition {
    Map<TOP_Knoten, Double> topNodeHorizontalCoor;
    Map<TOP_Knoten, Position> topNodePosition;
    TrackNetworkService trackService;
    TOP_Knoten firstNode;

    public TopKnotenPosition(TrackNetworkService trackService, TOP_Knoten firstNode) {
        this.trackService = trackService;
        this.firstNode = firstNode;
        this.topNodeHorizontalCoor = new HashMap<TOP_Knoten, Double>();
        this.findAllTOPNodeHorizontalCoor();
    }

    public Map<TOP_Knoten, Double> findAllTOPNodeHorizontalCoor() {
        List allTopNodes = this.trackService.getTracksCache().stream().flatMap(track -> track.getTopNodes().stream()).distinct().toList();
        if (!this.topNodeHorizontalCoor.isEmpty() && this.topNodeHorizontalCoor.keySet().containsAll(allTopNodes)) {
            return this.topNodeHorizontalCoor;
        }
        List edges = TopKnotenExtensions.getTopKanten((TOP_Knoten)this.firstNode);
        if (edges.isEmpty()) {
            throw new IllegalArgumentException(String.format("TOP_Knoten: %s haven't TOP_Kante", this.firstNode.getIdentitaet().getWert()));
        }
        this.findTOPNodeHorizontalCoor(this.trackService.getTOPKanteMetaData((TOP_Kante)edges.get(0)), this.firstNode, 0.0, true);
        return this.topNodeHorizontalCoor;
    }

    private void findTOPNodeHorizontalCoor(TOPKanteMetaData md, TOP_Knoten topNode, double posX, boolean isForward) {
        if (this.topNodeHorizontalCoor.containsKey(topNode)) {
            return;
        }
        this.topNodeHorizontalCoor.put(topNode, posX);
        md.getIntersectEdgeAt(topNode).forEach(intersectEdge -> this.findTOPNodeHorizontalCoor(md, (TOPKanteMetaData)intersectEdge, topNode, posX, isForward));
    }

    private void findTOPNodeHorizontalCoor(TOPKanteMetaData md, TOPKanteMetaData intersectEdge, TOP_Knoten topNode, double posX, boolean inDirection) {
        TOP_Knoten nextNode = intersectEdge.getNextTopNode(topNode);
        if (nextNode == null) {
            throw new IllegalArgumentException(String.format("TOP_Kante: %s haven only one TOP_Knoten", intersectEdge.getTopEdge().getIdentitaet().getWert()));
        }
        boolean isSameDirection = md.isSameDirection(intersectEdge);
        int edgeLength = intersectEdge.getLength();
        boolean newDirection = isSameDirection ? inDirection : !inDirection;
        double nextNodePosX = posX + (double)((newDirection ? 1 : -1) * edgeLength);
        this.findTOPNodeHorizontalCoor(intersectEdge, nextNode, nextNodePosX, newDirection);
    }

    public Position getTopNodePosition(TOP_Knoten node, OverviewplanTrack track) {
        if (this.topNodeHorizontalCoor.isEmpty() || !this.topNodeHorizontalCoor.containsKey(node)) {
            throw new IllegalArgumentException("TOP_Knoten horizontal coordinate aren't registered");
        }
        if (!track.getTopNodes().contains(node)) {
            throw new IllegalArgumentException("The track isn't contains TOP_Knoten");
        }
        Position pos = SiteplanFactory.eINSTANCE.createPosition();
        pos.setX(this.topNodeHorizontalCoor.get(node).doubleValue());
        if (TopKnotenPosition.isConnectNode(node, track)) {
            List<OverviewplanTrack> connect = this.trackService.getTracksCache().stream().filter(connectTrack -> connectTrack.getTopNodes().contains(node) && track != connectTrack).toList();
            pos.setY((double)connect.get((int)0).lvl);
        } else {
            pos.setY((double)track.lvl);
        }
        return pos;
    }

    private static boolean isConnectNode(TOP_Knoten node, OverviewplanTrack track) {
        List<TOPKanteMetaData> edges = track.getTopEdges().stream().filter(edge -> edge.getTopNodes().contains(node)).toList();
        if (edges.size() > 1) {
            return false;
        }
        return !edges.get(0).getIntersectEdgeAt(node).isEmpty();
    }
}

